/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.preprocessing.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.contexts.ServiceContext;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.Filter;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.FilterManager;
import org.kxml2.io.KXmlParser;

public class FilterReader {
    private GCUBEGenericResource resource;
    protected GCUBELog logger = new GCUBELog((Object)this);

    protected FilterReader() {
        if (!this.loadFiltersFromIS(ServiceContext.getContext().getInstance().getScopes().values())) {
            this.loadFiltersFromFile(ServiceContext.getContext().getFile("ResourceFilters.xml", new boolean[]{false}));
        }
    }

    private boolean loadFiltersFromFile(File file) {
        try {
            this.resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
            this.resource.load((Reader)new FileReader(file));
            this.parseFilters(this.resource.getBody());
            return true;
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Unable to load the ISFilters Resource from " + file.getAbsolutePath()), (Throwable)e);
                throw new Exception("Unable to load the ISFilters Resource from " + file.getAbsolutePath());
            }
            catch (Exception e1) {
                this.logger.error((Object)"", (Throwable)e1);
                return false;
            }
        }
    }

    private boolean loadFiltersFromIS(Collection<GCUBEScope> scopes) {
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//SecondaryType", "ISFilters")});
            this.logger.trace((Object)query.toString());
            for (GCUBEScope scope : scopes) {
                List results = client.execute((ISQuery)query, scope);
                if (results != null && results.size() > 0) {
                    this.resource = (GCUBEGenericResource)results.get(0);
                    this.parseFilters(this.resource.getBody());
                    this.logger.debug((Object)"ISFilters Resource loaded from the IS");
                    return true;
                }
                this.logger.warn((Object)("Unable to load the ISFilters for " + scope.toString() + " from the IS"));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"ISFilters not available on the IS", (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFilters(String body) throws Exception {
        KXmlParser parser = new KXmlParser();
        parser.setInput((Reader)new BufferedReader(new StringReader(body)));
        try {
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("Filter")) {
                            this.logger.debug((Object)("New filter found for " + parser.getAttributeValue("", "resourceType")));
                            FilterManager.getFilters(parser.getAttributeValue("", "resourceType")).add(this.parseFilter(parser));
                        }
                        break;
                    }
                    case 3: {
                        if (parser.getName().equals("Filters")) return;
                    }
                    case 1: {
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new Exception("Unable to parse the ISFilters body");
        }
    }

    private Filter parseFilter(KXmlParser parser) throws Exception {
        Filter filter;
        block11: {
            filter = new Filter();
            try {
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("Target")) {
                                filter.setTarget(parser.nextText().trim());
                                break;
                            }
                            if (parser.getName().equals("Value")) {
                                filter.setValue(parser.nextText().trim());
                                break;
                            }
                            if (parser.getName().equals("Operation")) {
                                filter.setOperation(Filter.FILTEROPERATION.valueOf(parser.nextText().trim()));
                                break;
                            }
                            parser.nextText();
                            break;
                        }
                        case 3: {
                            if (parser.getName().equals("Filter")) break block11;
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to parse at Filter");
            }
        }
        return filter;
    }
}

