/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.local;

import java.io.StringWriter;
import java.io.Writer;
import org.gcube.common.core.informationsystem.publisher.ISLocalPublisher;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.contexts.ServiceContext;
import org.gcube.informationsystem.registry.impl.porttypes.ResourceRegistration;
import org.gcube.informationsystem.registry.stubs.resourceregistration.CreateMessage;
import org.gcube.informationsystem.registry.stubs.resourceregistration.RemoveMessage;
import org.gcube.informationsystem.registry.stubs.resourceregistration.UpdateMessage;

public class LocalProfileConsumerImpl
extends ISLocalPublisher.LocalProfileConsumer {
    private final GCUBELog logger = new GCUBELog(LocalProfileConsumerImpl.class);

    protected void onProfileRegistered(final GCUBEResource resource, final GCUBEScope scope) {
        this.logger.debug((Object)("onProfileRegistered event received in scope " + scope));
        new Thread(){

            @Override
            public void run() {
                ServiceContext.getContext().waitUntilReady();
                ResourceRegistration factory = new ResourceRegistration();
                try {
                    ServiceContext.getContext().setScope(scope);
                    CreateMessage crm = new CreateMessage();
                    StringWriter writer = new StringWriter();
                    resource.store((Writer)writer);
                    crm.setProfile(writer.toString());
                    crm.setType(resource.getType());
                    LocalProfileConsumerImpl.this.logger.debug((Object)"Creating resource ");
                    factory.create(crm);
                }
                catch (Exception e) {
                    LocalProfileConsumerImpl.this.logger.error((Object)("cannot handle the create resource event" + e));
                }
            }
        }.start();
    }

    protected void onProfileRemoved(final String resourceID, final String type, final GCUBEScope scope) {
        this.logger.debug((Object)"onProfileRemoved event received");
        new Thread(){

            @Override
            public void run() {
                ServiceContext.getContext().waitUntilReady();
                ServiceContext.getContext().setScope(scope);
                ResourceRegistration factory = new ResourceRegistration();
                RemoveMessage rrm = new RemoveMessage();
                rrm.setType(type);
                rrm.setUniqueID(resourceID);
                try {
                    factory.remove(rrm);
                }
                catch (Exception e) {
                    LocalProfileConsumerImpl.this.logger.error((Object)("cannot handle the remove resource event" + e));
                }
            }
        }.start();
    }

    protected void onProfileUpdated(final GCUBEResource resource, final GCUBEScope scope) {
        this.logger.debug((Object)"onProfileUpdated event received");
        new Thread(){

            @Override
            public void run() {
                ServiceContext.getContext().waitUntilReady();
                ServiceContext.getContext().setScope(scope);
                ResourceRegistration factory = new ResourceRegistration();
                try {
                    UpdateMessage urm = new UpdateMessage();
                    StringWriter writer = new StringWriter();
                    resource.store((Writer)writer);
                    urm.setXmlProfile(writer.toString());
                    urm.setType(resource.getType());
                    urm.setUniqueID(resource.getID());
                    factory.update(urm);
                }
                catch (Exception e) {
                    LocalProfileConsumerImpl.this.logger.error((Object)("cannot handle the update resource event" + e));
                }
            }
        }.start();
    }
}

