/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.porttypes;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Calendar;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.contexts.FactoryContext;
import org.gcube.informationsystem.registry.impl.contexts.ServiceContext;
import org.gcube.informationsystem.registry.impl.porttypes.ResourceRegistration;
import org.gcube.informationsystem.registry.impl.state.Definitions;
import org.gcube.informationsystem.registry.impl.state.RegistryFactoryResource;
import org.gcube.informationsystem.registry.stubs.CreateResourceMessage;
import org.gcube.informationsystem.registry.stubs.ProfileAlreadyRegisteredFault;
import org.gcube.informationsystem.registry.stubs.RegistryProperty;
import org.gcube.informationsystem.registry.stubs.RemoveResourceMessage;
import org.gcube.informationsystem.registry.stubs.RemoveResourceResponse;
import org.gcube.informationsystem.registry.stubs.ResourceNotAcceptedFault;
import org.gcube.informationsystem.registry.stubs.SchemaValidationFault;
import org.gcube.informationsystem.registry.stubs.UpdateResourceMessage;
import org.gcube.informationsystem.registry.stubs.UpdateResourceResponse;
import org.gcube.informationsystem.registry.stubs.resourceregistration.CreateMessage;
import org.gcube.informationsystem.registry.stubs.resourceregistration.RemoveMessage;
import org.gcube.informationsystem.registry.stubs.resourceregistration.UpdateMessage;
import org.globus.wsrf.ResourceKey;

public class RegistryFactory
extends GCUBEPortType {
    protected static final GCUBELog logger = new GCUBELog(RegistryFactory.class);
    public static final String NOTIFICATOR_RESOURCE_KEY = "RegistryResource";
    private static RegistryFactoryResource singletonResource = null;

    protected void onInitialisation() throws Exception {
        if (singletonResource != null) {
            return;
        }
        logger.info((Object)"Initialising the factory state...");
        new Thread(){

            @Override
            public void run() {
                int attempts = 0;
                boolean created = false;
                while (attempts++ < 10) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        logger.error((Object)"Failed to sleep in between factory creation");
                        ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                        break;
                    }
                    try {
                        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                            logger.info((Object)("Creating the notification resource RegistryResource within the scope " + scope.getName()));
                            ServiceContext.getContext().setScope(scope);
                            singletonResource = (RegistryFactoryResource)FactoryContext.getContext().getWSHome().create(FactoryContext.getContext().makeKey(RegistryFactory.NOTIFICATOR_RESOURCE_KEY), new Object[0]);
                            singletonResource.store();
                        }
                        created = true;
                        break;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to create the resource", (Throwable)e);
                    }
                }
                if (!created) {
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                }
            }
        }.start();
    }

    public String createResource(CreateResourceMessage mess) throws SchemaValidationFault, RemoteException, ProfileAlreadyRegisteredFault, ResourceNotAcceptedFault {
        logger.info((Object)("CreateResource operation invoked in scope " + ServiceContext.getContext().getScope()));
        try {
            ResourceRegistration registration = new ResourceRegistration();
            CreateMessage message = new CreateMessage(mess.getProfile(), mess.getType());
            registration.create(message);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new ResourceNotAcceptedFault();
        }
        return "";
    }

    public UpdateResourceResponse updateResource(UpdateResourceMessage mess) throws RemoteException, SchemaValidationFault, ResourceNotAcceptedFault, GCUBEFault {
        logger.info((Object)("UpdateResource operation invoked in scope " + ServiceContext.getContext().getScope()));
        try {
            ResourceRegistration registration = new ResourceRegistration();
            UpdateMessage message = new UpdateMessage(mess.getType(), mess.getUniqueID(), mess.getXmlProfile());
            registration.update(message);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new ResourceNotAcceptedFault();
        }
        return new UpdateResourceResponse();
    }

    public RemoveResourceResponse removeResource(RemoveResourceMessage mess) throws RemoteException, GCUBEFault {
        logger.info((Object)("RemoveResource operation invoked in scope " + ServiceContext.getContext().getScope()));
        try {
            ResourceRegistration registration = new ResourceRegistration();
            RemoveMessage message = new RemoveMessage(mess.getType(), mess.getUniqueID());
            registration.remove(message);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new RemoteException();
        }
        return new RemoveResourceResponse();
    }

    protected static synchronized void updateCounterInfo(String ID, Definitions.ResourceMappings resType, Definitions.OperationType opType, Calendar updateTime, String profile, GCUBEScope scope) throws Exception {
        RegistryProperty property = new RegistryProperty();
        property.setUniqueID(ID);
        property.setProfile(profile);
        property.setOperationType(opType.name());
        property.setChangeTime(updateTime);
        property.setInvocationScope(scope.toString());
        logger.trace((Object)("Notifying about resource " + ID + ", event: " + (Object)((Object)opType)));
        for (Method method : ((Object)((Object)RegistryFactory.getResource())).getClass().getDeclaredMethods()) {
            if (!method.getName().contains(resType.name()) || !method.getName().contains("set")) continue;
            method.invoke((Object)RegistryFactory.getResource(), property);
            break;
        }
        RegistryFactory.getResource().store();
    }

    private static RegistryFactoryResource getResource() throws RemoteException {
        if (singletonResource != null) {
            return singletonResource;
        }
        GCUBEWSResource resource = null;
        try {
            resource = FactoryContext.getContext().getWSHome().find((ResourceKey)FactoryContext.getContext().makeKey(NOTIFICATOR_RESOURCE_KEY));
        }
        catch (Exception e) {
            logger.error((Object)" Unable to access resource", (Throwable)e);
        }
        RegistryFactoryResource factoryResource = (RegistryFactoryResource)resource;
        return factoryResource;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

