/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache;

import java.util.Hashtable;
import org.apache.axis.message.addressing.EndpointReference;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.ISCache;
import org.gcube.informationsystem.cache.ISCacheConsistencyManager;
import org.gcube.informationsystem.cache.ISCacheMM;
import org.gcube.informationsystem.cache.ISCacheRegistry;

public class ISCacheManager {
    private ISCacheConsistencyManager ccm;
    private ISCache cache;
    private GCUBEScope scope;
    static Hashtable<String, ISCacheManager> managers = new Hashtable();
    private static GCUBELog log = new GCUBELog(ISCacheManager.class);

    public static void initialize() throws Exception {
        ISCacheMM.init();
        ISCacheRegistry r = new ISCacheRegistry();
        String obName = "org.gcube:type=ISCacheRegistry";
        ISCacheMM.registerISMBean(obName, r);
    }

    public static boolean addManager(GCUBEScope scope) throws Exception {
        log.info((Object)("Creating new CacheManager in scope: " + scope.getName() + "\t" + scope.toString()));
        if (managers.get(scope.toString()) == null) {
            return managers.put(scope.toString(), new ISCacheManager(scope)) == null;
        }
        return false;
    }

    public static ISCacheManager getManager(GCUBEScope scope) throws Exception {
        return managers.get(scope.toString());
    }

    public static boolean delManager(GCUBEScope scope) throws Exception {
        log.info((Object)("Deleting CacheManager in scope: " + scope.getName() + "\t" + scope.toString()));
        managers.get(scope.toString()).unpublicISCache();
        managers.get(scope.toString()).unpublicISCacheConsistency();
        ISCacheManager.managers.get((Object)scope.toString()).ccm.unregisterCCManager(Class.forName(ISCacheManager.managers.get((Object)scope.toString()).ccm.getActiveCCManager()));
        return managers.remove(scope.toString()) == null;
    }

    public boolean equals(Object o) {
        if (o instanceof ISCacheManager) {
            // empty if block
        }
        return false;
    }

    public int hashCode() {
        return this.scope.toString().hashCode();
    }

    private void publicISCache() throws Exception {
        ISCacheMM.init();
        this.cache = new ISCache(this.scope);
        String obName = "org.gcube:type=" + this.cache.getRegistry().getScope().toString() + ",name=ISCache";
        ISCacheMM.registerISMBean(obName, this.getCache());
    }

    void unpublicISCache() throws Exception {
        String obName = "org.gcube:type=" + this.cache.getRegistry().getScope().toString() + ",name=ISCache";
        ISCacheMM.unregisterISMBean(obName);
    }

    private void publicISCacheConsistency() throws Exception {
        ISCacheMM.init();
        String obName = "org.gcube:type=" + this.cache.getRegistry().getScope().toString() + ",name=ISCacheCA";
        this.ccm = new ISCacheConsistencyManager(this.cache);
        this.publicStdConsistencyManager(this.ccm);
        ISCacheMM.registerISMBean(obName, this.ccm);
    }

    void unpublicISCacheConsistency() throws Exception {
        String obName = "org.gcube:type=" + this.cache.getRegistry().getScope().toString() + ",name=ISCacheCA";
        ISCacheMM.unregisterISMBean(obName);
    }

    private void publicStdConsistencyManager(ISCacheConsistencyManager cc) throws Exception {
        String CCManagerFQName = "org.gcube.informationsystem.cache.consistency.manager.poll.PollManager";
        cc.addCCManager(CCManagerFQName);
        cc.setActiveCCManager(CCManagerFQName);
    }

    public ISCacheManager(GCUBEScope scope) throws Exception {
        this.scope = scope;
        this.publicISCache();
        this.publicISCacheConsistency();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            ISCacheManager.printUsageAndExit();
        }
        ISCacheManager.initialize();
        Thread.sleep(Long.MAX_VALUE);
    }

    private static void printEPRs(EndpointReference[] eprs) {
        for (int i = 0; i < eprs.length; ++i) {
            System.out.println("::::::::" + eprs[i].toString());
        }
    }

    private static void printUsageAndExit() {
        System.err.println("Wrong number of arguments.\nUsage: java\nAborting...\n");
        System.exit(1);
    }

    public ISCache getCache() {
        return this.cache;
    }

    public ISCacheConsistencyManager getCCM() {
        return this.ccm;
    }
}

