/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.notifier.util;

import javax.xml.namespace.QName;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.notifier.impl.entities.Consumer;
import org.gcube.informationsystem.notifier.thread.RemoveSubscriptionThread;
import org.gcube.informationsystem.notifier.util.EPR;
import org.gcube.informationsystem.notifier.util.SubscriptionObject;
import org.gcube.informationsystem.notifier.util.Util;
import org.oasis.wsn.NotificationProducer;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.properties.QueryExpressionType;

public class Subscription
extends SubscriptionObject<EPR, Consumer> {
    private static final long serialVersionUID = -4637067173535597897L;
    public static GCUBELog logger = new GCUBELog(Subscription.class);

    public Subscription(Consumer consumer, EPR producer) {
        this.setConsumer(consumer);
        this.setProducer(producer);
        this.setSubscribed(false);
    }

    @Override
    public synchronized void removeSubscription() throws Exception {
        if (this.isSubscribed()) {
            try {
                logger.trace((Object)("subscription EPR  " + this.getNotificationResourceEnpoint().getEpr()));
                RemoveSubscriptionThread rst = new RemoveSubscriptionThread(this.getNotificationResourceEnpoint().getEpr());
                rst.start();
                this.setSubscribed(false);
            }
            catch (Exception e) {
                logger.error((Object)"error deleting the subscription ");
                throw e;
            }
        }
    }

    @Override
    public synchronized void subscribe(QName topic) throws Exception {
        if (!this.isSubscribed()) {
            try {
                logger.debug((Object)("subscribing for the topic " + topic.toString() + " consumer:" + ((Consumer)this.getConsumer()).getEpr() + " producer:" + ((EPR)this.getProducer()).getEpr()));
                long start = System.currentTimeMillis();
                Subscribe request = new Subscribe();
                request.setUseNotify(Boolean.TRUE);
                request.setConsumerReference(((Consumer)this.getConsumer()).getEpr());
                TopicExpressionType topicExpression = new TopicExpressionType();
                topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
                topicExpression.setValue((Object)new QName(topic.getNamespaceURI(), topic.getLocalPart()));
                request.setTopicExpression(topicExpression);
                if (((Consumer)this.getConsumer()).getPrecondition() != null) {
                    request.setPrecondition(new QueryExpressionType("http://www.w3.org/TR/1999/REC-xpath-19991116", (Object)((Consumer)this.getConsumer()).getPrecondition()));
                }
                if (((Consumer)this.getConsumer()).getSelection() != null) {
                    // empty if block
                }
                if (!Util.isEndpointReachable(((EPR)this.getProducer()).getEpr())) {
                    logger.error((Object)"the producer is unreachable");
                    throw new Exception("the producer " + ((EPR)this.getProducer()).getEpr().toString() + " is unreachable");
                }
                logger.info((Object)"the prducer is reachable");
                if (!Util.isEndpointReachable(((Consumer)this.getConsumer()).getEpr())) {
                    logger.error((Object)"the consumer is unreachable");
                    throw new Exception("the consumer " + ((Consumer)this.getConsumer()).getEpr().toString() + " is unreachable");
                }
                logger.info((Object)"the consumer is reachable");
                logger.trace((Object)("consumer EPR is " + ((Consumer)this.getConsumer()).getEpr()));
                WSBaseNotificationServiceAddressingLocator notifLocator = new WSBaseNotificationServiceAddressingLocator();
                NotificationProducer producerPort = notifLocator.getNotificationProducerPort(((EPR)this.getProducer()).getEpr());
                logger.trace((Object)"near the creation of the new subscription resource");
                SubscribeResponse response = producerPort.subscribe(request);
                this.setNotificationResourceEnpoint(new EPR(response.getSubscriptionReference()));
                long end = System.currentTimeMillis();
                logger.trace((Object)("time to subscribe a cosumer to a producer is " + (end - start) + " ms"));
                logger.info((Object)("subscribed client " + ((Consumer)this.getConsumer()).getEpr().toString() + " to producer " + ((EPR)this.getProducer()).getEpr().toString()));
            }
            catch (Exception e) {
                logger.error((Object)(" Error subscribing client :" + ((Consumer)this.getConsumer()).getEpr().toString() + " to producer " + ((EPR)this.getProducer()).getEpr().toString()));
                this.setSubscribed(false);
                throw e;
            }
            this.setSubscribed(true);
        }
    }
}

