/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.producer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class ActiveMQClient
implements Runnable {
    private static int ackMode;
    private static boolean transacted;
    private static ActiveMQClient singleton;
    private String selectorBase = "MessageType";
    private static Integer MAX_MONITORING_QUEUE_SIZE;
    private static Integer MAX_ACCOUNTING_QUEUE_SIZE;
    private static ConcurrentLinkedQueue<GCUBEMessage> messageForQueue;
    private static ConcurrentLinkedQueue<GCUBEMessage> messageForTopic;

    private ActiveMQClient() {
    }

    public void sendMessage(GCUBEMessage gCUBEMessage, String ... stringArray) {
        ArrayList<TopicConnection> arrayList = GCUBELocalProducer.getTopicConnection(GCUBEScope.getScope((String)gCUBEMessage.getScope()));
        if (arrayList != null) {
            for (TopicConnection topicConnection : arrayList) {
                try {
                    TopicSession topicSession = topicConnection.createTopicSession(transacted, ackMode);
                    Topic topic = topicSession.createTopic(gCUBEMessage.getTopic());
                    TopicPublisher topicPublisher = topicSession.createPublisher(topic);
                    topicPublisher.setDeliveryMode(2);
                    topicPublisher.setTimeToLive(86400000L);
                    ObjectMessage objectMessage = topicSession.createObjectMessage();
                    objectMessage.setObject((Serializable)gCUBEMessage);
                    objectMessage.setJMSMessageID(this.createRandomString());
                    if (stringArray.length != 0) {
                        objectMessage.setStringProperty(this.selectorBase, stringArray[0]);
                    }
                    topicPublisher.send((Message)objectMessage);
                    GCUBELocalProducer.logger.debug((Object)("Message " + gCUBEMessage.toString() + " SENT"));
                    return;
                }
                catch (JMSException jMSException) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)jMSException);
                    this.enqueueMessageForTopic(gCUBEMessage);
                }
                catch (Exception exception) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)exception);
                    this.enqueueMessageForTopic(gCUBEMessage);
                }
            }
        }
        GCUBELocalProducer.reloadConnection(GCUBEScope.getScope((String)gCUBEMessage.getScope()));
    }

    public void sendMessageToQueue(GCUBEMessage gCUBEMessage) {
        ArrayList<QueueConnection> arrayList = GCUBELocalProducer.getQueueConnection(GCUBEScope.getScope((String)gCUBEMessage.getScope()));
        if (arrayList != null) {
            for (QueueConnection queueConnection : arrayList) {
                try {
                    QueueSession queueSession = queueConnection.createQueueSession(transacted, ackMode);
                    Queue queue = queueSession.createQueue(gCUBEMessage.getTopic());
                    QueueSender queueSender = queueSession.createSender(queue);
                    queueSender.setDeliveryMode(2);
                    ObjectMessage objectMessage = queueSession.createObjectMessage();
                    objectMessage.setObject((Serializable)gCUBEMessage);
                    objectMessage.setJMSMessageID(this.createRandomString());
                    queueSender.send((Message)objectMessage);
                    GCUBELocalProducer.logger.debug((Object)("Message " + gCUBEMessage.toString() + " SENT"));
                    return;
                }
                catch (JMSException jMSException) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)jMSException);
                    this.enqueueMessageForQueue(gCUBEMessage);
                }
                catch (Exception exception) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)exception);
                    this.enqueueMessageForQueue(gCUBEMessage);
                }
            }
        }
        GCUBELocalProducer.reloadConnection(GCUBEScope.getScope((String)gCUBEMessage.getScope()));
    }

    private String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long l = random.nextLong();
        return Long.toHexString(l);
    }

    public static ActiveMQClient getSingleton() {
        return singleton;
    }

    public void setSingleton(ActiveMQClient activeMQClient) {
        singleton = activeMQClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessageForQueue(GCUBEMessage gCUBEMessage) {
        try {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                if (messageForQueue.size() >= MAX_ACCOUNTING_QUEUE_SIZE) {
                    GCUBELocalProducer.logger.error((Object)"Reached Maximum queue size, message discarded");
                    GCUBELocalProducer.logger.error((Object)gCUBEMessage.toString());
                } else {
                    messageForQueue.add(gCUBEMessage);
                }
            }
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)("Error enqueuing GCUBEMessage : " + gCUBEMessage.toString()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessageForTopic(GCUBEMessage gCUBEMessage) {
        try {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForTopic;
            synchronized (concurrentLinkedQueue) {
                if (messageForTopic.size() >= MAX_MONITORING_QUEUE_SIZE) {
                    GCUBELocalProducer.logger.error((Object)"Reached Maximum queue size, message discarded");
                    GCUBELocalProducer.logger.error((Object)gCUBEMessage.toString());
                } else {
                    messageForTopic.add(gCUBEMessage);
                }
            }
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)("Error enqueuing GCUBEMessage : " + gCUBEMessage.toString()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        int n2 = 0;
        while (true) {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue;
            GCUBEMessage gCUBEMessage = messageForQueue;
            synchronized (gCUBEMessage) {
                n = messageForQueue.size();
            }
            gCUBEMessage = messageForTopic;
            synchronized (gCUBEMessage) {
                n2 = messageForTopic.size();
            }
            if (n == 0 && n2 == 0) {
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            if (n > 0) {
                gCUBEMessage = null;
                concurrentLinkedQueue = messageForQueue;
                synchronized (concurrentLinkedQueue) {
                    gCUBEMessage = messageForQueue.poll();
                }
                this.sendMessageToQueue(gCUBEMessage);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (n2 <= 0) continue;
            gCUBEMessage = null;
            concurrentLinkedQueue = messageForTopic;
            synchronized (concurrentLinkedQueue) {
                gCUBEMessage = messageForTopic.poll();
            }
            this.sendMessage(gCUBEMessage, new String[0]);
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        MAX_MONITORING_QUEUE_SIZE = 1000;
        MAX_ACCOUNTING_QUEUE_SIZE = 1000;
        messageForQueue = null;
        messageForTopic = null;
        ackMode = 1;
        transacted = false;
        singleton = new ActiveMQClient();
        messageForQueue = new ConcurrentLinkedQueue();
        messageForTopic = new ConcurrentLinkedQueue();
        Thread thread = new Thread(singleton);
        thread.start();
    }
}

