/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.producer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBETestProbe;
import org.gcube.common.core.monitoring.LocalMonitor;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.messaging.common.producer.BrokerNotConfiguredInScopeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCUBELocalProducer
extends LocalMonitor {
    private static HashMap<GCUBEScope, ArrayList<ActiveMQConnectionFactory>> connectionFactoryMap = null;
    private static HashMap<GCUBEScope, ArrayList<TopicConnection>> topicConnectionMap = null;
    private static HashMap<GCUBEScope, ArrayList<QueueConnection>> queueConnectionMap = null;
    public static GCUBEClientLog logger = null;
    static Properties resources = new Properties();

    public void loadProbes(Map<String, Class<? extends GCUBETestProbe>> map) {
        try {
            Properties properties = new Properties();
            properties.load(GCUBELocalProducer.class.getResourceAsStream("probes.properties"));
            for (Object object : properties.keySet()) {
                try {
                    map.put((String)object, Class.forName((String)properties.get(object)));
                }
                catch (Exception exception) {
                    logger.error((Object)"Error loading probe class", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error loading probes configuration", (Throwable)exception);
        }
    }

    public static ArrayList<TopicConnection> getTopicConnection(GCUBEScope gCUBEScope) {
        ArrayList<TopicConnection> arrayList = topicConnectionMap.get(gCUBEScope);
        if (arrayList == null) {
            logger.debug((Object)"CONNECTION MAP NULL");
        }
        return arrayList;
    }

    public static ArrayList<QueueConnection> getQueueConnection(GCUBEScope gCUBEScope) {
        ArrayList<QueueConnection> arrayList = queueConnectionMap.get(gCUBEScope);
        if (arrayList == null) {
            logger.debug((Object)"CONNECTION MAP NULL");
        }
        return arrayList;
    }

    public static synchronized void addScope(GCUBEScope gCUBEScope) throws BrokerNotConfiguredInScopeException, GCUBEScopeNotSupportedException {
        if (!brokerMap.containsKey(gCUBEScope)) {
            if (gCUBEScope.getServiceMap().getEndpoints((Object)"MessageBroker") != null) {
                ArrayList<EndpointReferenceType> arrayList = new ArrayList<EndpointReferenceType>();
                for (EndpointReferenceType endpointReferenceType : gCUBEScope.getServiceMap().getEndpoints((Object)"MessageBroker")) {
                    logger.info((Object)("MSG-Broker found: " + endpointReferenceType.getAddress().toString() + " for scope: " + gCUBEScope.toString()));
                    arrayList.add(endpointReferenceType);
                }
                brokerMap.put(gCUBEScope, arrayList);
            } else {
                throw new BrokerNotConfiguredInScopeException();
            }
        }
    }

    public static synchronized Set<GCUBEScope> getMonitoredScope() {
        return brokerMap.keySet();
    }

    public static synchronized void removeScope(GCUBEScope gCUBEScope) {
        brokerMap.remove(gCUBEScope);
    }

    public static synchronized void reloadConnection(GCUBEScope gCUBEScope) {
        GCUBELocalProducer.stopConnections(gCUBEScope);
        ArrayList<ActiveMQConnectionFactory> arrayList = new ArrayList<ActiveMQConnectionFactory>();
        ArrayList<TopicConnection> arrayList2 = new ArrayList<TopicConnection>();
        ArrayList<QueueConnection> arrayList3 = new ArrayList<QueueConnection>();
        logger.debug((Object)"Reload JMS connections");
        for (EndpointReferenceType endpointReferenceType : (ArrayList)brokerMap.get(gCUBEScope)) {
            try {
                logger.info((Object)("MSG-Broker found: " + endpointReferenceType.getAddress().toString() + " for scope: " + gCUBEScope.toString()));
                ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(endpointReferenceType.getAddress().toString());
                arrayList.add(activeMQConnectionFactory);
                TopicConnection topicConnection = activeMQConnectionFactory.createTopicConnection();
                arrayList2.add(topicConnection);
                topicConnection.start();
                QueueConnection queueConnection = activeMQConnectionFactory.createQueueConnection();
                arrayList3.add(queueConnection);
                queueConnection.start();
            }
            catch (JMSException jMSException) {
                logger.error((Object)"Error creating Topic Connection", (Throwable)jMSException);
            }
            catch (Exception exception) {
                logger.error((Object)"Error creating Topic Connection", (Throwable)exception);
            }
        }
        topicConnectionMap.put(gCUBEScope, arrayList2);
        queueConnectionMap.put(gCUBEScope, arrayList3);
        connectionFactoryMap.put(gCUBEScope, arrayList);
    }

    public void run() {
        connectionFactoryMap = new HashMap();
        topicConnectionMap = new HashMap();
        queueConnectionMap = new HashMap();
        try {
            resources.load(GCUBELocalProducer.class.getResourceAsStream("GCUBELocalProducerLogger.properties"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        logger = new GCUBEClientLog(GCUBELocalProducer.class, new Properties[]{resources});
        for (Object object : brokerMap.keySet()) {
            logger.info((Object)("Broker Map, scope to monitor: " + object.toString()));
            GCUBELocalProducer.reloadConnection((GCUBEScope)object);
        }
        if (this.implementationMap == null) {
            this.implementationMap = Collections.synchronizedMap(new HashMap());
            this.loadProbes(this.implementationMap);
        }
        for (Object object : this.implementationMap.values()) {
            try {
                GCUBETestProbe gCUBETestProbe = (GCUBETestProbe)((Class)object).newInstance();
                gCUBETestProbe.setInterval(this.interval);
                logger.info((Object)("Initializing " + object + " Probe"));
                gCUBETestProbe.execute();
            }
            catch (Exception exception) {
                logger.error((Object)("Error Initializing probe " + object), (Throwable)exception);
            }
        }
    }

    public static boolean checkStartScope(GCUBEScope gCUBEScope) {
        boolean bl = false;
        for (GCUBEScope gCUBEScope2 : GHNContext.getContext().getStartScopes()) {
            if (!gCUBEScope.equals((Object)gCUBEScope2) && !gCUBEScope.isInfrastructure()) continue;
            bl = true;
        }
        return bl;
    }

    private static void stopConnections(GCUBEScope gCUBEScope) {
        if (topicConnectionMap != null && topicConnectionMap.get(gCUBEScope) != null) {
            for (TopicConnection topicConnection : topicConnectionMap.get(gCUBEScope)) {
                try {
                    topicConnection.stop();
                    topicConnection.close();
                }
                catch (JMSException jMSException) {
                    logger.error((Object)"Error stopping topicConnections", (Throwable)jMSException);
                }
            }
        }
        if (queueConnectionMap != null && queueConnectionMap.get(gCUBEScope) != null) {
            for (QueueConnection queueConnection : queueConnectionMap.get(gCUBEScope)) {
                try {
                    queueConnection.stop();
                    queueConnection.close();
                }
                catch (JMSException jMSException) {
                    logger.error((Object)"Error stopping queueConnections", (Throwable)jMSException);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        long l = 1200L;
        String string = "tcp://ui.grid.research-infrastructures.eu:6166";
        GCUBEScope gCUBEScope = GCUBEScope.getScope((String)"/gcube/devsec");
        if (stringArray.length == 3) {
            string = stringArray[0];
            l = Long.parseLong(stringArray[1]);
            gCUBEScope = GCUBEScope.getScope((String)stringArray[2]);
        }
        HashMap hashMap = new HashMap();
        ArrayList<EndpointReferenceType> arrayList = new ArrayList<EndpointReferenceType>();
        try {
            arrayList.add(new EndpointReferenceType(new Address(string)));
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        hashMap.put(gCUBEScope, arrayList);
        GCUBELocalProducer gCUBELocalProducer = new GCUBELocalProducer();
        gCUBELocalProducer.setBrokerMap(hashMap);
        gCUBELocalProducer.setInterval(l);
        gCUBELocalProducer.run();
    }
}

