/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubeapps.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlets.user.gcubeapps.client.stubs.NewLoginService;
import org.gcube.portlets.user.gcubeapps.server.EmailNotification;
import org.gcube.portlets.user.gcubeapps.server.UserBelonging;
import org.gcube.portlets.user.gcubeapps.server.VO;
import org.gcube.portlets.user.gcubeapps.server.VRE;
import org.gcube.portlets.user.gcubeapps.shared.VOClient;
import org.gcube.portlets.user.gcubeapps.shared.VObject;
import org.gcube.portlets.user.gcubeapps.shared.VREClient;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;
import org.gcube.vomanagement.usermanagement.model.RoleModel;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class AppsLoginServiceImpl
extends RemoteServiceServlet
implements NewLoginService {
    public static final String CACHED_VOS = "CACHED_VOS";
    private static final long serialVersionUID = 6776921559146742541L;
    private VO rootVO = new VO();
    private boolean withinPortal = false;
    private static Log _log = LogFactoryUtil.getLog(AppsLoginServiceImpl.class);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.debug((Object)("\n\n LOGIN PORTLET: USER IS NULL \n\n SESSION ID READ: " + sessionID));
            user = "test.user";
            System.out.print("\n\n session ID= *" + sessionID + "*  user= *" + user + "*");
        } else {
            this.withinPortal = true;
            _log.debug((Object)("******* LIFERAY PORTAL DETECTED ******* SESSION ID= *" + sessionID + "*  user= *" + user + "*"));
        }
        _log.debug((Object)("session ID= *" + sessionID + "*  user= *" + user + "*"));
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isPending(String screenName, long organizationId) {
        try {
            for (UserModel userModel : new LiferayUserManager().listPendingUsersByGroup("" + organizationId)) {
                if (userModel.getScreenName().compareTo(screenName) != 0) continue;
                return true;
            }
        }
        catch (UserManagementSystemException e) {
            e.printStackTrace();
        }
        catch (GroupRetrievalFault e) {
            e.printStackTrace();
        }
        catch (UserRetrievalFault e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<VOClient> getInfrastructureVOs() {
        _log.info((Object)"getInfrastructureVOs method called");
        if (!this.withinPortal) {
            _log.debug((Object)("getRootOrganizationName " + this.getRootOrganizationName() + "*"));
            return this.getFakeVOs();
        }
        try {
            User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
            List userRoles = currUser.getRoles();
            List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
            Organization rootOrganization = null;
            for (Organization organization : organizations) {
                if (!organization.getName().equals(this.getRootOrganizationName())) continue;
                rootOrganization = organization;
                break;
            }
            try {
                _log.info((Object)("root: " + rootOrganization.getName()));
            }
            catch (NullPointerException e) {
                System.out.println("Cannot find root organziation, please edit resource.properties file in config folder");
                e.printStackTrace();
            }
            ArrayList<VO> infrastructureVOs = new ArrayList<VO>();
            this.rootVO = new VO();
            this.rootVO.setVOName(rootOrganization.getName());
            this.rootVO.setVomsGroupName("/" + rootOrganization.getName());
            this.rootVO.setIsRoot(true);
            Group orgGroup = rootOrganization.getGroup();
            String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
            this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
            long logoId = rootOrganization.getLogoId();
            String logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
            this.rootVO.setImageURL(logoURL);
            if (rootOrganization.getComments() != null) {
                this.rootVO.setDescription(rootOrganization.getComments());
            }
            if (this.hasRole(this.getVoAdminRoleName(), rootOrganization.getName(), currUser)) {
                this.rootVO.setUserBelonging(UserBelonging.BELONGING);
            } else if (this.isPending(currUser.getScreenName(), rootOrganization.getOrganizationId())) {
                this.rootVO.setUserBelonging(UserBelonging.PENDING);
            } else {
                this.rootVO.setUserBelonging(UserBelonging.NOT_BELONGING);
            }
            for (Organization vOrg : rootOrganization.getSuborganizations()) {
                if (!vOrg.getName().equals("gCubeApps")) continue;
                _log.info((Object)("FOUND gCubeApps: " + vOrg.getName()));
                VO voToAdd = new VO();
                voToAdd.setVOName(vOrg.getName());
                voToAdd.setVomsGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName());
                voToAdd.setIsRoot(false);
                for (Organization vre : vOrg.getSuborganizations()) {
                    VRE vreToAdd = new VRE();
                    vreToAdd.setVREName(vre.getName());
                    vreToAdd.setVomsGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName() + "/" + vre.getName());
                    logoId = vre.getLogoId();
                    logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
                    vreToAdd.setImageURL(logoURL);
                    String vreUrl = vre.getGroup().getPathFriendlyURL(true, themeDisplay) + vre.getGroup().getFriendlyURL();
                    vreToAdd.setFriendlyURL(this.getPortalBasicUrl() + vreUrl);
                    if (vre.getComments() != null) {
                        vreToAdd.setDescription(vre.getComments());
                    }
                    if (currUser.getOrganizations().contains(vre)) {
                        vreToAdd.setUserBelonging(UserBelonging.BELONGING);
                    } else if (this.isPending(currUser.getScreenName(), vre.getOrganizationId())) {
                        vreToAdd.setUserBelonging(UserBelonging.PENDING);
                    } else {
                        vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                    }
                    voToAdd.addVRE(vreToAdd);
                }
                Group group = vOrg.getGroup();
                String url = group.getPathFriendlyURL(true, themeDisplay) + group.getFriendlyURL();
                voToAdd.setFriendlyURL(this.getPortalBasicUrl() + url);
                if (vOrg.getComments() != null) {
                    voToAdd.setDescription(vOrg.getComments());
                }
                if (currUser.getOrganizations().contains(vOrg)) {
                    voToAdd.setUserBelonging(UserBelonging.BELONGING);
                } else if (this.isPending(currUser.getScreenName(), vOrg.getOrganizationId())) {
                    voToAdd.setUserBelonging(UserBelonging.PENDING);
                } else {
                    voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                }
                infrastructureVOs.add(voToAdd);
            }
            LinkedList<VOClient> toReturn = new LinkedList<VOClient>();
            for (VO vo : infrastructureVOs) {
                toReturn.add(this.getVOSerializable(vo));
            }
            Collections.sort(toReturn, Collections.reverseOrder());
            toReturn.add(0, this.getVOSerializable(this.rootVO));
            LinkedList<VOClient> toStoreInSession = toReturn;
            this.getASLSession().setAttribute("CACHED_VOS", toStoreInSession);
            return toReturn;
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return new LinkedList<VOClient>();
    }

    public VObject getSelectedRE() {
        HttpSession session = this.getThreadLocalRequest().getSession();
        String selectedGroupName = this.getASLSession().getScopeName();
        LinkedList vos = (LinkedList)session.getAttribute("CACHED_VOS");
        for (VOClient vo : vos) {
            if (vo.getGroupName().equals(selectedGroupName)) {
                return vo;
            }
            List vres = vo.getVres();
            for (VREClient vre : vres) {
                if (!vre.getGroupName().equals(selectedGroupName)) continue;
                this.setVREBelonginApplication(vre);
                return vre;
            }
        }
        return null;
    }

    private void setVREBelonginApplication(VREClient vre) {
        ArrayList<String> toSet = new ArrayList<String>();
        toSet.add("AnnotationFrontEnd_V2");
        this.getASLSession().setAttribute("availablePortlets", toSet);
    }

    public String[] getVOMSRoles() {
        return null;
    }

    private boolean hasRole(String rolename, String organizationName, User user) {
        try {
            for (Role role : user.getRoles()) {
                if (role.getName().compareTo(rolename + "-" + organizationName) != 0) continue;
                return true;
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String getVoAdminRoleName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = this.getServletContext().getRealPath("") + "/config/resources.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("voadminRole");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private String getVreAdminRoleName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = this.getServletContext().getRealPath("") + "/config/resources.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("voadminRole");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private String getRootOrganizationName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = this.getServletContext().getRealPath("") + "/config/resources.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("rootorganization");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public Boolean isLayoutLoaded() {
        this.getASLSession();
        return new Boolean(false);
    }

    public void loadLayout(String scope, String URL2) {
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), session.getAttribute("username").toString());
        mysession.setAttribute("loadlayout", (Object)"true");
        session.setAttribute("loadLayout", (Object)"true");
        session.setAttribute("selectedVRE", (Object)scope);
        mysession.logUserLogin(scope);
        mysession.setScope(scope);
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        request.getQueryString();
        return toReturn;
    }

    protected static ArrayList<String> getAdministratorsEmails(String scope) {
        LiferayUserManager userManager = new LiferayUserManager();
        LiferayGroupManager groupManager = new LiferayGroupManager();
        String groupId = null;
        try {
            List allGroups = groupManager.listGroups();
            _log.debug((Object)("Number of groups retrieved: " + allGroups.size()));
            for (int i = 0; i < allGroups.size(); ++i) {
                String grId = ((GroupModel)allGroups.get(i)).getGroupId();
                String groupScope = groupManager.getScope(grId);
                System.out.println("Comparing: " + groupScope + " " + scope);
                if (!groupScope.equals(scope)) continue;
                groupId = ((GroupModel)allGroups.get(i)).getGroupId();
                break;
            }
        }
        catch (UserManagementSystemException e) {
            e.printStackTrace();
        }
        catch (GroupRetrievalFault e) {
            e.printStackTrace();
        }
        HashMap usersAndRoles = null;
        try {
            usersAndRoles = userManager.listUsersAndRolesByGroup(groupId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Set users = usersAndRoles.keySet();
        ArrayList<String> adminEmailsList = new ArrayList<String>();
        block6: for (UserModel usr : users) {
            List roles = (List)usersAndRoles.get(usr);
            for (int i = 0; i < roles.size(); ++i) {
                if (!((RoleModel)roles.get(i)).getRoleName().equals("VO-Admin") && !((RoleModel)roles.get(i)).getRoleName().equals("VRE-Manager")) continue;
                adminEmailsList.add(usr.getEmail());
                _log.debug((Object)("Admin: " + usr.getFullname()));
                continue block6;
            }
        }
        return adminEmailsList;
    }

    public void addMembershipRequest(String scope, String optionalMessage) {
        String username = this.getASLSession().getUsername();
        AppsLoginServiceImpl.addMembershipRequest((String)username, (VO)this.rootVO, (String)scope, (String)optionalMessage, (String)this.getPortalBasicUrl());
    }

    public static void addMembershipRequest(String username, VO rootVO, String scope, String optionalMessage, String portalbasicurl) {
        ArrayList adminEmails = AppsLoginServiceImpl.getAdministratorsEmails((String)scope);
        User currUser = null;
        try {
            currUser = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = currUser.getFirstName();
        String lastname = currUser.getLastName();
        String selectedVRE = scope.substring(scope.lastIndexOf("/") + 1, scope.length());
        _log.info((Object)("Request MEMBERSHIP for: " + selectedVRE + " scope: " + scope));
        LiferayUserManager um = new LiferayUserManager();
        LiferayGroupManager gm = new LiferayGroupManager();
        String userid = "";
        try {
            userid = um.getUserId(currUser.getScreenName());
            um.requestMembership(userid, gm.getGroupId(selectedVRE), optionalMessage);
        }
        catch (UserManagementSystemException e) {
            e.printStackTrace();
        }
        catch (GroupRetrievalFault e) {
            e.printStackTrace();
        }
        catch (UserRetrievalFault e) {
            e.printStackTrace();
        }
        String imageURL = portalbasicurl + rootVO.getImageURL();
        StringBuffer body = new StringBuffer();
        body.append("<img src=\"" + imageURL + "\" />");
        body.append("<br /><br />");
        body.append("<p>Dear manager of " + scope + ",<br />this email message was automatically generated by " + portalbasicurl + " to inform you that ");
        body.append("</p>");
        body.append("<p>");
        body.append("<b>" + name + " " + lastname + "</b> has requested access to the following environment: ");
        body.append("<br /><br />");
        body.append("<b>" + scope + "</b>");
        body.append("<br />");
        body.append("<br />");
        body.append("<b>Username: </b>" + username);
        body.append("<br />");
        body.append("<b>e-mail: </b>" + currUser.getEmailAddress());
        body.append("</p>");
        body.append("<p>");
        body.append("The request is annotated with the following text: " + optionalMessage);
        body.append("</p>");
        body.append("<p>");
        body.append("You are kindly asked to manage such request by either approving or rejecting it through the user management facilities available at ");
        body.append("<br />" + portalbasicurl);
        body.append("</p>");
        body.append("<p>");
        body.append("WARNING / LEGAL TEXT: This message is intended only for the use of the individual or entity to which it is addressed and may contain information which is privileged, confidential, proprietary, or exempt from disclosure under applicable law. If you are not the intended recipient or the person responsible for delivering the message to the intended recipient, you are strictly prohibited from disclosing, distributing, copying, or in any way using this message.");
        body.append("</p>");
        String[] allMails = new String[adminEmails.size()];
        adminEmails.toArray(allMails);
        EmailNotification mailToAdmin = new EmailNotification("no-reply@d4science.org", allMails, "[D4Science.org Gateway] - Request registration to VO/VREs", body.toString());
        mailToAdmin.sendEmail();
    }

    private Document getAdminEmailsDocument() {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            doc = builder.parse(this.getServletContext().getRealPath("") + "/config/admin.emails.xml");
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    private User validateUser(String username) throws PortalException, SystemException {
        Company company = OrganizationsUtil.getCompany();
        return UserLocalServiceUtil.getUserByScreenName((long)company.getCompanyId(), (String)username);
    }

    public Company getCompany(String webId) throws PortalException, SystemException {
        return CompanyLocalServiceUtil.getCompanyByWebId((String)webId);
    }

    public VREClient getVRESerializable(VRE vre) {
        return new VREClient(vre.getVREname(), vre.getVomsGroupName(), vre.getDescription(), vre.getImageURL(), vre.getFriendlyURL(), this.getUserBelonging(vre.isUserBelonging()));
    }

    public VOClient getVOSerializable(VO vo) {
        List vres = vo.getVres();
        LinkedList<VREClient> newVres = new LinkedList<VREClient>();
        for (VRE vre : vres) {
            newVres.add(this.getVRESerializable(vre));
        }
        return new VOClient(vo.getVoName(), vo.getVomsGroupName(), vo.getDescription(), vo.getImageURL(), vo.getFriendlyURL(), this.getUserBelonging(vo.isUserBelonging()), vo.isRoot(), newVres);
    }

    public VObject.UserBelongingClient getUserBelonging(UserBelonging userBelonging) {
        if (userBelonging == UserBelonging.BELONGING) {
            return VObject.UserBelongingClient.BELONGING;
        }
        if (userBelonging == UserBelonging.NOT_BELONGING) {
            return VObject.UserBelongingClient.NOT_BELONGING;
        }
        return VObject.UserBelongingClient.PENDING;
    }

    public VOClient getRootVO() {
        _log.info((Object)"root call");
        this.getASLSession().invalidate();
        if (this.rootVO != null) {
            return this.getVOSerializable(this.rootVO);
        }
        Organization rootOrganization = null;
        List organizations = null;
        try {
            organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        for (Organization organization : organizations) {
            if (!organization.getName().equals(this.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        this.rootVO.setVOName(rootOrganization.getName());
        this.rootVO.setVomsGroupName("/" + rootOrganization.getName());
        this.rootVO.setIsRoot(true);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
        Group orgGroup = rootOrganization.getGroup();
        String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
        this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
        return this.getVOSerializable(this.rootVO);
    }

    private List<VOClient> getFakeVOs() {
        VO rootVO = new VO();
        rootVO.setIsRoot(true);
        rootVO.setVOName("/d4science.research-infrastructures.eu/");
        rootVO.setDescription("This is the description for the ROOT VO");
        rootVO.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
        rootVO.setUserBelonging(UserBelonging.BELONGING);
        VO emVO = new VO();
        emVO.setIsRoot(false);
        emVO.setVomsGroupName("/d4science.research-infrastructures.eu/EM/");
        emVO.setVOName("EM VO");
        emVO.setDescription("EM and AEM Virtual Organisation The FARM Virtual Organisation is the dynamic group of individuals and/or institutions defined around a set of sharing rules in which resource providers and consumers specify clearly and carefully just what is shared, who is allowed to share, and the conditions under which sharing occurs to serve the needs of the Fisheries and Aquaculture Resources Management.");
        emVO.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
        emVO.setUserBelonging(UserBelonging.NOT_BELONGING);
        VRE cool_EM_VRE = new VRE();
        cool_EM_VRE.setVREName("COOL EM VRE");
        cool_EM_VRE.setVomsGroupName("/d4science.research-infrastructures.eu/EM/COOLEMVRE");
        cool_EM_VRE.setDescription("cool_EM_VRE VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        cool_EM_VRE.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/gcm-preview.jpg");
        emVO.addVRE(cool_EM_VRE);
        VRE cool_EM_VRE2 = new VRE();
        cool_EM_VRE2.setVREName("COOL VRE 2");
        cool_EM_VRE2.setVomsGroupName("/d4science.research-infrastructures.eu/EM/COOLEMVRE2");
        cool_EM_VRE2.setDescription("Cool VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        cool_EM_VRE2.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/aquamaps-preview.jpg");
        cool_EM_VRE2.setUserBelonging(UserBelonging.NOT_BELONGING);
        cool_EM_VRE2.setUserBelonging(UserBelonging.NOT_BELONGING);
        VRE cool_EM_VRE3 = new VRE();
        cool_EM_VRE3.setVREName("VesselActivitiesAnalyzer");
        cool_EM_VRE3.setVomsGroupName("/d4science.research-infrastructures.eu/EM/COOlVRE3");
        cool_EM_VRE3.setDescription("Cool VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        cool_EM_VRE3.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/aquamaps-preview.jpg");
        cool_EM_VRE3.setUserBelonging(UserBelonging.BELONGING);
        VRE demo = new VRE();
        demo.setVREName("Demo");
        demo.setVomsGroupName("/d4science.research-infrastructures.eu/EM/Demo");
        demo.setDescription("Cool VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        demo.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
        demo.setUserBelonging(UserBelonging.BELONGING);
        VRE vreGCM = new VRE();
        vreGCM.setVREName("BiodiversityResearchEnvironment");
        vreGCM.setVomsGroupName("/d4science.research-infrastructures.eu/EM/GCM");
        vreGCM.setDescription("Global Ocean Chlorophyll Monitoring (GCM) Virtual Research Environment<br />The phytoplankton plays a similar role to terrestrial green plants in the photosynthetic process and are credited with removing as much carbon dioxide from the atmosphere as their earthbound counterparts, making it important to monitor and model plankton into calculations of future climate change.");
        vreGCM.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/aquamaps-preview.jpg");
        vreGCM.setUserBelonging(UserBelonging.BELONGING);
        emVO.addVRE(cool_EM_VRE);
        emVO.addVRE(cool_EM_VRE2);
        emVO.addVRE(cool_EM_VRE3);
        emVO.addVRE(demo);
        emVO.addVRE(vreGCM);
        LinkedList<VOClient> toReturn = new LinkedList<VOClient>();
        toReturn.add(this.getVOSerializable(rootVO));
        toReturn.add(this.getVOSerializable(emVO));
        toReturn.add(this.getVOSerializable(emVO));
        return toReturn;
    }
}

