/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications.cache;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class NotificationsActionCache {
    private static final Log logger = LogFactoryUtil.getLog(NotificationsActionCache.class);
    private SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
    private static NotificationsActionCache instance = new NotificationsActionCache();
    private Map<String, Long> cache = new ConcurrentHashMap();
    private static final long EXPIRED_AFTER = 180000L;

    private NotificationsActionCache() {
        logger.info((Object)"NotificationsActionCache created");
    }

    public static NotificationsActionCache getCacheInstance() {
        return instance;
    }

    public Long get(String key) {
        logger.debug((Object)("GET REQUEST: <" + key + ">"));
        if (this.cache.containsKey(key)) {
            Long timestamp = (Long)this.cache.get(key);
            if (NotificationsActionCache.expired((long)timestamp)) {
                this.cache.remove(key);
                logger.debug((Object)("Information expired for user <" + key + ">"));
            } else {
                logger.debug((Object)("Information not expired for user " + key));
                return timestamp;
            }
        }
        return null;
    }

    public boolean insert(String key, Long value) {
        Date d = new Date(value);
        logger.debug((Object)("INSERT REQUEST: <" + key + "," + this.ft.format(d) + ">"));
        this.cache.put(key, value);
        return true;
    }

    private static boolean expired(long timestamp) {
        long currentTime = System.currentTimeMillis();
        return timestamp + 180000L <= currentTime;
    }

    public void removeKey(String key) {
        logger.debug((Object)("REMOVE REQUEST: <" + key + ">"));
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
        }
    }
}

