/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.socialmail;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.sun.mail.util.MailSSLSocketFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.GenderType;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.mailing.AppType;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.CommentNotificationsThread;
import org.gcube.portal.notifications.thread.LikeNotificationsThread;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portal.socialmail.EmailPopAccount;
import org.gcube.portal.socialmail.Utils;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class PeriodicTask
implements Runnable {
    private static final Log _log = LogFactoryUtil.getLog(PeriodicTask.class);
    private static final String APP_ID_NEWSFEED = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";
    private DatabookStore socialStore;
    private EmailPopAccount popAccount;
    private SocialNetworkingSite site;
    private static final String DEFAULT_ROLE = "OrganizationMember";

    public PeriodicTask(DatabookStore store, EmailPopAccount popAccount, HttpServletRequest request) {
        this.socialStore = store;
        this.popAccount = popAccount;
        this.site = new SocialNetworkingSite(request);
        String serverName = request.getServerName();
        this.site.setSiteURL("https://" + serverName);
        _log.debug((Object)("PeriodicTask instanciated, request serverName=" + serverName));
    }

    @Override
    public void run() {
        try {
            _log.debug((Object)("PeriodicTask starting for portal/site having name: " + this.popAccount.getPortalName()));
            this.check(this.popAccount.getPortalName(), this.popAccount.getPop3Server(), this.popAccount.getPop3user(), this.popAccount.getPop3password());
        }
        catch (Exception e) {
            _log.error((Object)"Exception during check email account, exiting ans stopping thread... ");
            Thread.currentThread().interrupt();
        }
    }

    private ASLSession getFakeASLSession(String emailAddress) {
        ASLSession toReturn = null;
        String sessionID = UUID.randomUUID().toString();
        PortalContext context = PortalContext.getConfiguration();
        String scope = "/" + context.getInfrastructureName();
        String username = "";
        try {
            LiferayUserManager um = new LiferayUserManager();
            GCubeUser user = um.getUserByEmail(emailAddress);
            username = user.getUsername();
            SessionManager.getInstance().getASLSession(sessionID, username).setScope(scope);
            String fullName = user.getFirstName() + " " + user.getLastName();
            String email = user.getEmail();
            String thumbnailURL = user.getUserAvatarURL();
            boolean isMale = user.isMale();
            SessionManager.getInstance().getASLSession(sessionID, username).setUserFullName(fullName);
            SessionManager.getInstance().getASLSession(sessionID, username).setUserEmailAddress(email);
            SessionManager.getInstance().getASLSession(sessionID, username).setUserAvatarId(thumbnailURL);
            SessionManager.getInstance().getASLSession(sessionID, username).setUserGender(isMale ? GenderType.MALE : GenderType.FEMALE);
            _log.debug((Object)("Created fakesession for user " + username + " email=" + emailAddress));
            _log.debug((Object)("Setting token for user " + username));
            toReturn = SessionManager.getInstance().getASLSession(sessionID, username);
            PeriodicTask.setAuthorizationToken((ASLSession)toReturn);
        }
        catch (Exception e) {
            _log.error((Object)("Exception while trying to get the user from email address: " + e.getMessage()));
            return null;
        }
        return toReturn;
    }

    private static void setAuthorizationToken(ASLSession session) throws Exception {
        String username = session.getUsername();
        String scope = session.getScope();
        ScopeProvider.instance.set(scope);
        _log.debug((Object)("calling service token on scope " + scope));
        ArrayList<String> userRoles = new ArrayList<String>();
        userRoles.add("OrganizationMember");
        session.setSecurityToken(null);
        String token = Constants.authorizationService().generateUserToken(new UserInfo(session.getUsername(), userRoles), scope);
        _log.debug((Object)("received token: " + token));
        session.setSecurityToken(token);
        _log.debug((Object)("PeriodicTask EmailParser: Security token set in session for: " + username + " on " + scope));
    }

    public void check(String portalName, String host, String user, String password) {
        try {
            MailSSLSocketFactory sf = null;
            try {
                sf = new MailSSLSocketFactory();
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            sf.setTrustAllHosts(true);
            Properties pop3Props = new Properties();
            pop3Props.setProperty("mail.pop3.ssl.enable", "true");
            pop3Props.setProperty("mail.protocol.ssl.trust", host);
            pop3Props.put("mail.pop3s.ssl.socketFactory", sf);
            pop3Props.setProperty("mail.pop3s.port", "995");
            pop3Props.setProperty("mail.pop3.timeout", "3000");
            pop3Props.setProperty("mail.pop3.connectiontimeout", "3000");
            Session emailSession = Session.getDefaultInstance((Properties)pop3Props);
            emailSession.setDebug(false);
            Store store = emailSession.getStore("pop3s");
            _log.debug((Object)("Trying to connect to " + host + ", user=" + user + " passwd (first 3 char)=" + password.substring(0, 3) + "******"));
            store.connect(host, user, password);
            Folder emailFolder = store.getFolder("INBOX");
            emailFolder.open(2);
            Message[] messages = emailFolder.getMessages();
            _log.debug((Object)("Found " + messages.length + " new messages ..."));
            for (Message message : messages) {
                _log.info((Object)"--------------- FOUND EMAIL ------------------");
                String subject = message.getSubject();
                _log.info((Object)("Parsing email of " + message.getFrom()[0] + " with subject: " + subject));
                if (this.isValidReply(message)) {
                    String subAddressField = PeriodicTask.extractSubaddress((Message)message);
                    _log.info((Object)("extractSubaddress filed = " + subAddressField));
                    Address[] froms = message.getFrom();
                    String emailAddress = froms == null ? null : ((InternetAddress)froms[0]).getAddress();
                    ASLSession fakeSession = this.getFakeASLSession(emailAddress);
                    if (fakeSession != null && subAddressField != null) {
                        if (subAddressField.endsWith(AppType.POST.toString()) || subAddressField.endsWith(AppType.POST.toString().toLowerCase())) {
                            _log.debug((Object)"Looks like a post, a comment on a post or a mention to me");
                            String feedId = PeriodicTask.extractIdentifier((String)subAddressField);
                            this.handlePostReply(portalName, feedId, message, fakeSession);
                        } else if (subAddressField.endsWith(AppType.MSG.toString()) || subAddressField.endsWith(AppType.MSG.toString().toLowerCase())) {
                            _log.debug((Object)"Looks like a message reply to me");
                            String messageId = PeriodicTask.extractIdentifier((String)subAddressField);
                            this.handleMessageReply(portalName, messageId, message, fakeSession);
                        } else {
                            _log.warn((Object)("cannot identify the type of this email reply from " + message.getFrom()[0] + " with subject: " + subject));
                        }
                    } else {
                        _log.warn((Object)("User Not Recognized, going to discard Message from emailAddress = " + emailAddress));
                    }
                } else {
                    _log.warn((Object)("Message is not a valid reply, going to discard Message with subject = " + subject));
                }
                message.setFlag(Flags.Flag.DELETED, true);
                _log.debug((Object)("Marked DELETE for message: " + subject));
            }
            emailFolder.close(true);
            store.close();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleMessageReply(String portalName, String messageId, Message message, ASLSession fakeSession) {
        String subject = "";
        String messageText = "";
        try {
            subject = message.getSubject();
            messageText = PeriodicTask.extractText((String)portalName, (String)messageId, (Message)message);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        _log.debug((Object)("Found message reply, subject: " + subject + " body: " + messageText));
        String newMessageId = null;
        List recipientIds = null;
        try {
            Workspace workspace = this.getWorkspace(fakeSession);
            WorkspaceMessageManager messageManager = workspace.getWorkspaceMessageManager();
            WorkspaceMessage theMessage = messageManager.getReceivedMessage(messageId);
            recipientIds = theMessage.getAddresses();
            String sender = theMessage.getSender().getPortalLogin();
            String originalText = theMessage.getBody();
            Date originalSentTime = theMessage.getSendTime().getTime();
            recipientIds.add(sender);
            recipientIds.remove(fakeSession.getUsername());
            _log.debug((Object)"Message Recipients:");
            for (String rec : recipientIds) {
                _log.debug((Object)rec);
            }
            _log.debug((Object)"Constructing reply message");
            messageText = messageText + this.getReplyHeaderMessage(sender, originalSentTime, originalText);
            _log.debug((Object)("Trying to send message with subject: " + subject + " to: " + recipientIds.toString()));
            newMessageId = messageManager.sendMessageToPortalLogins(subject, messageText, new ArrayList(), recipientIds);
        }
        catch (HomeNotFoundException | InternalErrorException | ItemNotFoundException | WorkspaceFolderNotFoundException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("Message with subject: " + subject + " hase been sent, returned id: " + newMessageId));
        if (newMessageId != null) {
            _log.debug((Object)("Sending message notifications ... site server URL= " + this.site.getSiteURL()));
            List recipients = this.getUsersbyUserId(recipientIds);
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.site, fakeSession.getScope(), new SocialNetworkingUser(fakeSession.getUsername(), fakeSession.getUserEmailAddress(), fakeSession.getUserFullName(), fakeSession.getUserAvatarId()));
            Thread thread = new Thread((Runnable)new MessageNotificationsThread(recipients, newMessageId, subject, messageText, (NotificationsManager)nm));
            thread.start();
        } else {
            _log.debug((Object)"Could not send message reply");
        }
    }

    private String getReplyHeaderMessage(String senderId, Date date, String message) {
        ArrayList<String> toPass = new ArrayList<String>();
        toPass.add(senderId);
        List theSender = this.getUsersbyUserId(toPass);
        String senderFullName = senderId;
        if (theSender != null && !theSender.isEmpty()) {
            senderFullName = ((GenericItemBean)theSender.get(0)).getAlternativeName();
        }
        String toReturn = "\n\n---\n on " + date + " " + senderFullName + " wrote:";
        toReturn = toReturn + "\n\n" + message;
        return toReturn;
    }

    private List<GenericItemBean> getUsersbyUserId(List<String> recipientIds) {
        ArrayList<GenericItemBean> recipients = new ArrayList<GenericItemBean>();
        for (String userid : recipientIds) {
            try {
                GCubeUser user = new LiferayUserManager().getUserByUsername(userid);
                recipients.add(new GenericItemBean("" + user.getUserId(), user.getUsername(), user.getFullname(), ""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recipients;
    }

    private void handlePostReply(String portalName, String feedId, Message message, ASLSession fakeSession) throws Exception {
        String commentText = PeriodicTask.extractText((String)portalName, (String)feedId, (Message)message);
        _log.info((Object)("Extracted id: " + feedId + " text=" + commentText));
        String escapedCommentText = Utils.escapeHtmlAndTransformUrl((String)commentText);
        String subject = message.getSubject();
        if (escapedCommentText.trim().compareTo("") == 0) {
            _log.debug((Object)("Found favorite/subscription for feed with subject: " + subject));
            this.favoriteFeed(feedId, fakeSession);
        } else {
            Comment comment = new Comment(UUID.randomUUID().toString(), fakeSession.getUsername(), new Date(), feedId, escapedCommentText, fakeSession.getUserFullName(), fakeSession.getUserAvatarId());
            _log.debug((Object)("The EscapedCommentText =>" + escapedCommentText));
            boolean commentCommitResult = false;
            try {
                if (this.socialStore.addComment(comment)) {
                    commentCommitResult = true;
                }
            }
            catch (FeedIDNotFoundException e) {
                _log.error((Object)("Related post not found for this comment " + e.getMessage()));
                e.printStackTrace();
            }
            if (commentCommitResult) {
                this.notifyUsersInvolved(comment, escapedCommentText, feedId, fakeSession);
            }
        }
    }

    private void favoriteFeed(String feedId, ASLSession fakeSession) {
        if (feedId == null || feedId.compareTo("") == 0) {
            _log.warn((Object)("Found email with no feedId from " + fakeSession.getUserEmailAddress() + ". Going to trash it"));
            return;
        }
        Like like = new Like(UUID.randomUUID().toString(), fakeSession.getUsername(), new Date(), feedId, fakeSession.getUserFullName(), fakeSession.getUserAvatarId());
        boolean likeCommitResult = false;
        try {
            if (this.socialStore.like(like)) {
                // empty if block
            }
            likeCommitResult = true;
        }
        catch (FeedIDNotFoundException e) {
            _log.error((Object)("Related post not found for this like " + e.getMessage()));
            e.printStackTrace();
        }
        if (likeCommitResult) {
            try {
                Feed feed = this.socialStore.readFeed(feedId);
                String feedOwnerId = feed.getEntityId();
                boolean isAppFeed = feed.isApplicationFeed();
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.site, fakeSession.getScope(), new SocialNetworkingUser(fakeSession.getUsername(), fakeSession.getUserEmailAddress(), fakeSession.getUserFullName(), fakeSession.getUserAvatarId()), "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
                if (!fakeSession.getUsername().equals(feedOwnerId) && !isAppFeed) {
                    boolean result = nm.notifyLikedFeed(feedOwnerId, feedId, "");
                    _log.trace((Object)("Like Notification to post owner added? " + result));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyUsersInvolved(Comment comment, String commentText, String feedId, ASLSession fakeSession) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        Feed feed = this.socialStore.readFeed(feedId);
        String feedOwnerId = feed.getEntityId();
        boolean isAppFeed = feed.isApplicationFeed();
        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.site, feed.getVreid(), new SocialNetworkingUser(fakeSession.getUsername(), fakeSession.getUserEmailAddress(), fakeSession.getUserFullName(), fakeSession.getUserAvatarId()), "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
        if (!fakeSession.getUsername().equals(feedOwnerId) && !isAppFeed) {
            boolean result = nm.notifyOwnCommentReply(feedOwnerId, feedId, commentText, comment.getKey());
            _log.trace((Object)("Comment Notification to post owner added? " + result));
        }
        ArrayList favorites = this.getAllLikesByFeed(feedId);
        Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(commentText, (NotificationsManager)nm, favorites, feedOwnerId, comment.getKey()));
        likesThread.start();
        LiferayUserManager userManager = new LiferayUserManager();
        Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(this.socialStore, (UserManager)userManager, fakeSession.getUsername(), comment.getFeedid(), commentText, (NotificationsManager)nm, feedOwnerId, comment.getKey(), favorites));
        commentsNotificationthread.start();
    }

    public ArrayList<Like> getAllLikesByFeed(String feedid) {
        _log.trace((Object)("Asking likes for " + feedid));
        ArrayList toReturn = (ArrayList)this.socialStore.getAllLikesByFeed(feedid);
        return toReturn;
    }

    private static String extractSubaddress(Message message) throws MessagingException {
        Address[] emails = message.getRecipients(MimeMessage.RecipientType.TO);
        String subAddressToReturn = null;
        for (int i = 0; i < emails.length; ++i) {
            String toParse = emails[i].toString();
            int plus = toParse.lastIndexOf(43);
            int at = toParse.indexOf(64);
            if (plus >= 0) {
                subAddressToReturn = toParse.substring(plus + 1, at);
                break;
            }
            _log.warn((Object)("Found recipient with no subaddress, skipping " + toParse));
        }
        return subAddressToReturn;
    }

    private static String extractIdentifier(String subAddress) {
        String id = subAddress;
        int at = subAddress.indexOf(36);
        if (at > -1) {
            id = subAddress.substring(0, at);
        }
        return id;
    }

    private boolean isValidReply(Message message) {
        try {
            Object messageContent = message.getContent();
            String toParse = null;
            String SEPARATOR = "- Write ABOVE THIS LINE to reply via email, reply with empty msg to subscribe -".substring(0, 23);
            if (messageContent instanceof Multipart) {
                _log.debug((Object)("Checking if isValidReply, found Multipart Message, getting text part ... looking for separator " + SEPARATOR));
                Multipart multipart = (Multipart)messageContent;
                BodyPart part = multipart.getBodyPart(0);
                part.toString();
                toParse = part.getContent().toString();
            } else {
                _log.debug((Object)("Found a text/plain Message, getting text ... looking for separator " + SEPARATOR));
                toParse = messageContent.toString();
            }
            String[] lines = toParse.split(System.getProperty("line.separator"));
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].contains(SEPARATOR)) continue;
                _log.debug((Object)"Yes, it is a valid Reply");
                return true;
            }
            _log.debug((Object)"NOT a valid Reply");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error((Object)"Exceptiom returning NOT a valid Reply");
            return false;
        }
    }

    private static String extractText(String portalName, String subjectId, Message message) throws Exception {
        Object messageContent = message.getContent();
        String toParse = null;
        String SEPARATOR = "- Write ABOVE THIS LINE to reply via email, reply with empty msg to subscribe -".substring(0, 23);
        if (messageContent instanceof Multipart) {
            _log.debug((Object)("Found Multipart Message, getting text part ... looking for separator " + SEPARATOR));
            Multipart multipart = (Multipart)messageContent;
            BodyPart part = multipart.getBodyPart(0);
            part.toString();
            toParse = part.getContent().toString();
        } else {
            _log.debug((Object)"Found text/plain Message, getting text");
            toParse = messageContent.toString();
        }
        _log.debug((Object)("Got Message content = " + toParse));
        String[] lines = toParse.split(System.getProperty("line.separator"));
        int until = -1;
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].contains(SEPARATOR)) continue;
            until = i;
            break;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < until; ++i) {
            if (!(lines[i].contains(portalName) || lines[i].contains(subjectId) || lines[i].startsWith("> ") && lines[i].trim().length() < 2)) {
                sb.append(lines[i]);
            }
            if (i == until - 1) continue;
            sb.append("\n");
        }
        String toReturn = sb.toString().trim();
        _log.debug((Object)("Returning text extracted = " + toReturn));
        return toReturn;
    }

    private Workspace getWorkspace(ASLSession session) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        Workspace workspace = HomeLibrary.getUserWorkspace((String)session.getUsername());
        return workspace;
    }
}

