/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.invitessent.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portal.databook.shared.ex.InviteIDNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteStatusNotFoundException;
import org.gcube.portlets.admin.invitessent.client.InvitesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvitesServiceImpl
extends RemoteServiceServlet
implements InvitesService {
    private static final Logger _log = LoggerFactory.getLogger(InvitesServiceImpl.class);
    public static final String TEST_USER = "test.user";
    public static final String TEST_SCOPE = "/gcube/devsec/devVRE";
    private DatabookStore store;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    public String getDevelopmentUser() {
        String user = TEST_USER;
        return user;
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting testing user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope(TEST_SCOPE);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public ArrayList<Invite> getInvites(InviteStatus[] statuses) {
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        if (userName.compareTo(TEST_USER) == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        String vreid = session.getScope();
        ArrayList<Invite> toReturn = new ArrayList<Invite>();
        try {
            toReturn.addAll(this.store.getInvitedEmailsByVRE(vreid, statuses));
        }
        catch (InviteIDNotFoundException | InviteStatusNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return toReturn;
    }
}

