/**
 * 
 */
package org.gcube.portlets.user.homelibrary.home.data.fs;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;

/**
 * This class represent a generic element into the data home, like folder o file.
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public interface DataAreaItem {
	
	/**
	 * Return the item parent.
	 * @return the item parent.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	DataFolder getParent() throws InternalErrorException;
	
	/**
	 * Return this element name.
	 * @return the item name.
	 */
	String getName();
	
	/**
	 * Return this element path.
	 * @return the item path.
	 */
	String getPath();
	
	/**
	 * Indicates if this is a folder.
	 * @return <code>true</code> if this item is a folder, <code>false</code> otherwise.
	 */
	boolean isFolder();

}
