package org.gcube.portlets.user.notifications.client.view.templates;

import java.util.Date;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class DayWrapper extends Composite {

	private static DayWrapperUiBinder uiBinder = GWT
			.create(DayWrapperUiBinder.class);

	interface DayWrapperUiBinder extends UiBinder<Widget, DayWrapper> {
	}
	
	@UiField HTML dayLabel;
	
	public DayWrapper(Date day) {
		initWidget(uiBinder.createAndBindUi(this));
	
		String notificationDate = DateTimeFormat.getFormat("yyyy MMMM dd").format(day);
		String today = DateTimeFormat.getFormat("yyyy MMMM dd").format(new Date());
		if (notificationDate.equals(today))
			dayLabel.setHTML("Today");
		else
			dayLabel.setHTML(DateTimeFormat.getFormat("EE, dd MMMM").format(day));
	}

}
