/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.reader.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.DATA_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.exception.SdmxSyntaxException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.constants.EDI_TIME_FORMAT;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIDataReader;
import org.sdmxsource.sdmx.ediparser.util.EDIUtil;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyableImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.ObservationImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class EDIDataReaderEngineImpl
implements DataReaderEngine {
    private static final String OBS_STATUS = "OBS_STATUS";
    private static final String OBS_PRE_BREAK = "OBS_PRE_BREAK";
    private String OBS_CONF = "OBS_CONF";
    private String SIBLING_GROUP = EDIUtil.getSiblingGroupId();
    protected boolean hasNext = true;
    protected boolean hasNextObs = true;
    protected boolean isTimeSeries = true;
    protected String crossSectionConcept;
    protected Observation currentObs;
    protected Keyable currentKey;
    private DataStructureBean dataStructureBean;
    private EDIDataReader ediDataReader;
    private String missingValue;
    private String[] dimensions;
    private String[] observations = null;
    private int currentObsPos = -1;
    private int keyablePosition = -1;
    private boolean hasObsStatus;
    private boolean hasObsConf;
    private boolean hasObsPreBeak;
    private List<String> obsDates;
    private EDI_TIME_FORMAT ediTimeFormat;
    boolean inFootNoteSection;
    private boolean lookedAhead = false;
    private boolean hasCurrentKey = false;
    private List<KeyValue> datasetAttributes = new ArrayList<KeyValue>();
    private Map<String, String> dateMap = new HashMap<String, String>();
    private Map<TIME_FORMAT, CachedTimeRanges> timeRangeCache = new HashMap<TIME_FORMAT, CachedTimeRanges>();
    private List<EDIDataReader> ediDataReaders = new ArrayList<EDIDataReader>();
    private int currentlyProcessingReaderIndex = -1;
    private HeaderBean header;
    private SdmxBeanRetrievalManager beanRetrievalManager;
    private DataflowBean dataflowBean;

    public EDIDataReaderEngineImpl(HeaderBean header, SdmxBeanRetrievalManager beanRetrievalManager, List<EDIDataReader> ediDataReaders) {
        this.header = header;
        this.ediDataReaders = ediDataReaders;
        this.beanRetrievalManager = beanRetrievalManager;
    }

    public EDIDataReaderEngineImpl(HeaderBean header, DataflowBean dataflow, DataStructureBean dataStructureBean, List<EDIDataReader> ediDataReaders) {
        this.header = header;
        this.dataStructureBean = dataStructureBean;
        this.dataflowBean = dataflow;
        this.ediDataReaders = ediDataReaders;
    }

    public EDIDataReaderEngineImpl(HeaderBean header, DataflowBean dataflowBean, DataStructureBean dataStructureBean, EDIDataReader ediDataReader) {
        this.header = header;
        this.dataStructureBean = dataStructureBean;
        this.dataflowBean = dataflowBean;
        this.ediDataReaders.add(ediDataReader);
    }

    public HeaderBean getHeader() {
        return this.header;
    }

    public DataReaderEngine createCopy() {
        if (this.beanRetrievalManager != null) {
            return new EDIDataReaderEngineImpl(this.header, this.beanRetrievalManager, this.ediDataReaders);
        }
        return new EDIDataReaderEngineImpl(this.header, this.dataflowBean, this.dataStructureBean, this.ediDataReaders);
    }

    public DataStructureBean getDataStructure() {
        return this.dataStructureBean;
    }

    public DataflowBean getDataFlow() {
        return this.dataflowBean;
    }

    public ProvisionAgreementBean getProvisionAgreement() {
        return null;
    }

    private void obtainDataStructureInformation() {
        ArrayList<String> dimList = new ArrayList<String>();
        for (DimensionBean currentDimension : this.dataStructureBean.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
            dimList.add(currentDimension.getId());
        }
        for (GroupBean group : this.dataStructureBean.getGroups()) {
            if (!group.getId().toLowerCase().startsWith("sibling")) continue;
            this.SIBLING_GROUP = group.getId();
        }
        this.dimensions = new String[dimList.size()];
        dimList.toArray(this.dimensions);
        this.determineObsAttributes();
    }

    private void start() {
        this.ediDataReader = this.ediDataReaders.get(this.currentlyProcessingReaderIndex);
        this.ediDataReader.resetReader();
        this.inFootNoteSection = false;
        this.missingValue = this.ediDataReader.getMissingValue();
        if (this.beanRetrievalManager != null) {
            this.dataStructureBean = (DataStructureBean)this.beanRetrievalManager.getMaintainableBean(DataStructureBean.class, this.ediDataReader.getDatasetHeaderBean().getDataStructureReference().getStructureReference().getMaintainableReference());
        }
        if (this.dataStructureBean == null) {
            throw new RuntimeException("Can not read EDI Data File - Data Structure can not be found:" + this.ediDataReader.getDatasetHeaderBean().getDataStructureReference().getStructureReference().getMaintainableReference());
        }
        if (this.dataStructureBean.getAttribute(this.OBS_CONF) == null && this.dataStructureBean.getAttribute("CONF_STATUS") != null) {
            this.OBS_CONF = "CONF_STATUS";
        }
        this.datasetAttributes = this.ediDataReader.getDatasetAttributes();
        this.obtainDataStructureInformation();
    }

    private void determineObsAttributes() {
        this.hasObsStatus = this.dataStructureBean.getObservationAttribute(OBS_STATUS) != null;
        this.hasObsConf = this.dataStructureBean.getObservationAttribute(this.OBS_CONF) != null;
        this.hasObsPreBeak = this.dataStructureBean.getObservationAttribute(OBS_PRE_BREAK) != null;
    }

    private void assertMoveNext() {
        if (!this.ediDataReader.moveNext()) {
            throw new SdmxSyntaxException("Unexpected end of file" + this.ediDataReader.getCurrentLine());
        }
    }

    public DatasetHeaderBean getCurrentDatasetHeaderBean() {
        return this.ediDataReader.getDatasetHeaderBean();
    }

    public boolean isTimeSeries() {
        return true;
    }

    public String getCrossSectionConcept() {
        return "TIME_PERIOD";
    }

    public int getDatasetPosition() {
        return this.currentlyProcessingReaderIndex;
    }

    public int getObsPosition() {
        return this.currentObsPos;
    }

    public Keyable getCurrentKey() {
        return this.currentKey;
    }

    public List<KeyValue> getDatasetAttributes() {
        return new ArrayList<KeyValue>(this.datasetAttributes);
    }

    public boolean moveNextDataset() {
        ++this.currentlyProcessingReaderIndex;
        if (this.ediDataReaders.size() > this.currentlyProcessingReaderIndex) {
            this.ediDataReader = this.ediDataReaders.get(this.currentlyProcessingReaderIndex);
            this.start();
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public boolean moveNextKeyable() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Observation getCurrentObservation() {
        return this.currentObs;
    }

    public int getKeyablePosition() {
        return this.keyablePosition;
    }

    private void processEDIDataLine() {
        this.currentObsPos = -1;
        this.observations = EDIUtil.splitOnPlus(this.ediDataReader.getCurrentLine());
        String firstDataLine = this.observations[0];
        String[] dataLineSplit = EDIUtil.splitOnColon(firstDataLine);
        ArrayList<KeyValueImpl> seriesKey = new ArrayList<KeyValueImpl>();
        if (dataLineSplit.length < this.dimensions.length) {
            throw new SdmxSemmanticException("Reported key '" + firstDataLine + "' is less then key length '" + this.dimensions.length + "' ");
        }
        boolean isGroup = false;
        int i = 0;
        while (i < this.dimensions.length) {
            String val = dataLineSplit[i];
            if (val.length() == 0) {
                isGroup = true;
            } else {
                seriesKey.add(new KeyValueImpl(val, this.dimensions[i]));
            }
            ++i;
        }
        this.observations[0] = null;
        String firstObservation = "";
        int i2 = this.dimensions.length + 2;
        while (i2 < dataLineSplit.length) {
            firstObservation = String.valueOf(firstObservation) + dataLineSplit[i2];
            if (dataLineSplit.length > i2 + 1) {
                firstObservation = String.valueOf(firstObservation) + ":";
            }
            ++i2;
        }
        if (ObjectUtil.validString((String[])new String[]{firstObservation})) {
            this.observations[0] = firstObservation;
        } else {
            this.observations = null;
        }
        this.processObservations(dataLineSplit);
        TIME_FORMAT timeFormat = this.ediTimeFormat == null ? null : this.ediTimeFormat.getSdmxTimeFormat();
        this.currentKey = isGroup ? new KeyableImpl(this.dataflowBean, this.dataStructureBean, seriesKey, null, this.SIBLING_GROUP, new AnnotationBean[0]) : new KeyableImpl(this.dataflowBean, this.dataStructureBean, seriesKey, null, timeFormat, new AnnotationBean[0]);
    }

    private void processObservations(String[] dataLineSplit) {
        this.obsDates = new ArrayList<String>();
        if (dataLineSplit.length > this.dimensions.length) {
            String reportedDate = dataLineSplit[this.dimensions.length];
            String dateFormat = dataLineSplit[this.dimensions.length + 1];
            this.ediTimeFormat = EDI_TIME_FORMAT.parseString(dateFormat);
            if (this.observations != null && this.observations.length > 1) {
                this.processObservationRange(reportedDate);
            } else {
                this.processSingleObservation(reportedDate);
            }
        }
    }

    private void processObservationRange(String reportedDate) {
        Map<String, List<String>> timeRangeMap;
        if (!this.ediTimeFormat.isRange()) {
            throw new SdmxSyntaxException("More than one observation found for a ARR segment declaring a single time period");
        }
        CachedTimeRanges timeRanges = this.timeRangeCache.get(this.ediTimeFormat.getSdmxTimeFormat());
        if (timeRanges == null) {
            timeRanges = new CachedTimeRanges();
            this.timeRangeCache.put(this.ediTimeFormat.getSdmxTimeFormat(), timeRanges);
        }
        if ((timeRangeMap = timeRanges.getTimeRangeMap()).containsKey(reportedDate)) {
            this.obsDates = timeRangeMap.get(reportedDate);
        } else {
            Date startDate = this.ediTimeFormat.parseDate(reportedDate);
            Date endDate = this.ediTimeFormat.parseEndDate(reportedDate);
            this.obsDates = DateUtil.createTimeValues((Date)startDate, (Date)endDate, (TIME_FORMAT)this.ediTimeFormat.getSdmxTimeFormat());
            if (this.obsDates.size() != this.observations.length) {
                throw new SdmxSyntaxException("Expecting '" + this.obsDates.size() + "' observations for time range '" + reportedDate + "' in format '" + (Object)((Object)this.ediTimeFormat) + "' but got '" + this.observations.length + "'");
            }
            timeRangeMap.put(reportedDate, this.obsDates);
        }
        if (this.obsDates.size() != this.observations.length) {
            throw new SdmxSyntaxException("ARR segment decares time range requiring " + this.obsDates.size() + " observations, only " + this.observations.length + " observations reported");
        }
    }

    private void processSingleObservation(String reportedDate) {
        String mapKey = String.valueOf(this.ediTimeFormat.getEdiValue()) + ":" + reportedDate;
        if (this.dateMap.containsKey(mapKey)) {
            this.obsDates.add(this.dateMap.get(mapKey));
        } else {
            Date startDate = this.ediTimeFormat.parseDate(reportedDate);
            String parsedDate = DateUtil.formatDate((Date)startDate, (TIME_FORMAT)this.ediTimeFormat.getSdmxTimeFormat());
            this.obsDates.add(parsedDate);
            this.dateMap.put(mapKey, parsedDate);
        }
    }

    private boolean processEDIAttributeSegment() {
        if (EDIUtil.assertPrefix(this.ediDataReader, EDI_PREFIX.DATASET_ATTRIBUTE_SCOPE, false)) {
            int scope = Integer.parseInt(this.ediDataReader.getCurrentLine());
            if (scope == 1) {
                this.ediDataReader.moveNext();
                EDIUtil.assertPrefix(this.ediDataReader, EDI_PREFIX.DATASET_DATAATTRIBUTE, true);
                return false;
            }
        } else {
            this.ediDataReader.moveBackLine();
        }
        this.assertMoveNext();
        EDIUtil.assertPrefix(this.ediDataReader, EDI_PREFIX.DATASET_DATAATTRIBUTE, true);
        String currentLine = this.ediDataReader.getCurrentLine();
        String[] posKeySplit = EDIUtil.splitOnPlus(currentLine);
        if (posKeySplit.length != 2) {
            throw new SdmxSyntaxException("Can not parse current line '" + currentLine + "' expecting integer+key example 5+A:B:C:D");
        }
        String key = posKeySplit[1];
        String[] keySplit = EDIUtil.splitOnColon(key);
        ArrayList<KeyValueImpl> keyableKey = new ArrayList<KeyValueImpl>();
        if (keySplit.length < this.dimensions.length) {
            throw new SdmxSemmanticException("Reported attributes '" + key + "' are less then key length '" + this.dimensions.length + "' ");
        }
        boolean isGroup = false;
        int i = 0;
        while (i < this.dimensions.length) {
            String val = keySplit[i];
            if (val.length() == 0) {
                isGroup = true;
            } else {
                keyableKey.add(new KeyValueImpl(val, this.dimensions[i]));
            }
            ++i;
        }
        List<KeyValue> attributes = this.processAttributeValues();
        this.currentObs = null;
        String obsDateAsSdmxString = null;
        if (keySplit.length > this.dimensions.length) {
            if (keySplit.length != this.dimensions.length + 2) {
                throw new SdmxSemmanticException("Reported attributes '" + key + "' unexpected information, expecting length '" + (this.dimensions.length + 2) + "' ");
            }
            if (isGroup) {
                throw new SdmxSemmanticException("Illegal observation level attribute reported against a wildcarded series key '" + key + "'.  Observation attributes must be reported against the full key.");
            }
            String timeFormatString = keySplit[this.dimensions.length + 1];
            String dateString = keySplit[this.dimensions.length];
            EDI_TIME_FORMAT timeFormat = EDI_TIME_FORMAT.parseString(timeFormatString);
            Date obsDate = timeFormat.parseDate(dateString);
            obsDateAsSdmxString = DateUtil.formatDate((Date)obsDate, (TIME_FORMAT)timeFormat.getSdmxTimeFormat());
        }
        if (isGroup) {
            this.currentKey = obsDateAsSdmxString != null ? new KeyableImpl(this.dataflowBean, this.dataStructureBean, keyableKey, null, this.SIBLING_GROUP, new AnnotationBean[0]) : new KeyableImpl(this.dataflowBean, this.dataStructureBean, keyableKey, attributes, this.SIBLING_GROUP, new AnnotationBean[0]);
        } else if (obsDateAsSdmxString != null) {
            this.currentKey = new KeyableImpl(this.dataflowBean, this.dataStructureBean, keyableKey, null, null, null, null);
            this.currentObs = new ObservationImpl(this.currentKey, obsDateAsSdmxString, null, attributes, new AnnotationBean[0]);
        } else {
            this.currentKey = new KeyableImpl(this.dataflowBean, this.dataStructureBean, keyableKey, attributes, null, null, null);
        }
        return true;
    }

    private List<KeyValue> processAttributeValues() {
        ArrayList<KeyValue> returnList = new ArrayList<KeyValue>();
        while (true) {
            this.assertMoveNext();
            if (this.ediDataReader.getLineType() != EDI_PREFIX.DATASET_ATTRIBUTE_CODED && this.ediDataReader.getLineType() != EDI_PREFIX.DATASET_ATTRIBUTE_UNCODED) {
                this.ediDataReader.moveBackLine();
                Collections.sort(returnList, new Comparator<KeyValue>(){

                    @Override
                    public int compare(KeyValue o1, KeyValue o2) {
                        return o1.getConcept().compareTo(o2.getConcept());
                    }
                });
                return returnList;
            }
            String attributeConceptId = this.ediDataReader.getCurrentLine();
            String attributeValue = null;
            if (this.ediDataReader.getLineType() == EDI_PREFIX.DATASET_ATTRIBUTE_CODED) {
                this.assertMoveNext();
                if (EDIUtil.assertPrefix(this.ediDataReader, EDI_PREFIX.CODE_VALUE, false)) {
                    attributeValue = this.ediDataReader.getCurrentLine();
                } else {
                    this.ediDataReader.moveBackLine();
                }
                this.checkAttributeValueValidity(attributeConceptId, attributeValue, EDI_PREFIX.DATASET_ATTRIBUTE_CODED);
            } else if (this.ediDataReader.getLineType() == EDI_PREFIX.DATASET_ATTRIBUTE_UNCODED) {
                String compositeValue = "";
                while (true) {
                    this.assertMoveNext();
                    if (!EDIUtil.assertPrefix(this.ediDataReader, EDI_PREFIX.STRING, false)) break;
                    compositeValue = String.valueOf(compositeValue) + this.ediDataReader.parseTextString();
                }
                this.checkAttributeValueValidity(attributeConceptId, compositeValue, EDI_PREFIX.DATASET_ATTRIBUTE_UNCODED);
                attributeValue = compositeValue;
                this.ediDataReader.moveBackLine();
            }
            returnList.add((KeyValue)new KeyValueImpl(attributeValue, attributeConceptId));
        }
    }

    private void checkAttributeValueValidity(String attribute, String value, EDI_PREFIX type) {
        DATASET_ACTION action = null;
        if (this.getCurrentDatasetHeaderBean() != null) {
            action = this.getCurrentDatasetHeaderBean().getAction();
        }
        if (action == null && this.header != null && this.header.getAction() != null) {
            action = this.header.getAction();
        }
        if (action != DATASET_ACTION.DELETE && (value == null || value.equals(""))) {
            if (type.equals((Object)EDI_PREFIX.DATASET_ATTRIBUTE_UNCODED)) {
                throw new SdmxSyntaxException("Processing Uncoded Dataset Attribute (IDE+Z11) encountered illegal empty value for attribute: " + attribute);
            }
            throw new SdmxSyntaxException("Processing Coded Dataset Attribute (IDE+Z10) encountered illegal empty code for attribute: " + attribute);
        }
    }

    public boolean moveNextObservation() {
        if (this.inFootNoteSection) {
            return false;
        }
        this.processEDIObservation();
        return this.currentObs != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processEDIObservation() {
        while (true) {
            ++this.currentObsPos;
            this.currentObs = null;
            if (this.observations == null) {
                if (this.obsDates.size() <= this.currentObsPos) return;
                String obsDate = this.obsDates.size() > this.currentObsPos ? this.obsDates.get(this.currentObsPos) : null;
                this.currentObs = new ObservationImpl(this.currentKey, obsDate, null, null, new AnnotationBean[0]);
                return;
            }
            if (this.observations.length > this.currentObsPos) {
                boolean obsPreBreakPresent;
                String currentObsLine = this.observations[this.currentObsPos];
                String obsDate = this.obsDates.size() > this.currentObsPos ? this.obsDates.get(this.currentObsPos) : null;
                String obsVal = null;
                ArrayList<KeyValueImpl> attributes = new ArrayList<KeyValueImpl>();
                if (!ObjectUtil.validString((String[])new String[]{currentObsLine}) && !ObjectUtil.validString((String[])new String[]{obsDate})) {
                    ++this.currentObsPos;
                    continue;
                }
                String[] obsArr = EDIUtil.splitOnColon(currentObsLine);
                obsVal = obsArr[0];
                boolean obsStatusPresent = obsArr.length > 1 && ObjectUtil.validString((String[])new String[]{obsArr[1]});
                boolean obsConfPresent = obsArr.length > 2 && ObjectUtil.validString((String[])new String[]{obsArr[2]});
                boolean bl = obsPreBreakPresent = obsArr.length > 3 && ObjectUtil.validString((String[])new String[]{obsArr[3]});
                if (obsStatusPresent) {
                    if (!this.hasObsStatus) throw new IllegalArgumentException("No observation attribute 'OBS_STATUS' present on DSD, but the data contains a value for this attribute");
                    attributes.add(new KeyValueImpl(obsArr[1], OBS_STATUS));
                } else if (!ObjectUtil.validString((String[])new String[]{obsVal})) continue;
                if (obsConfPresent) {
                    if (!this.hasObsConf) throw new IllegalArgumentException("No observation attribute '" + this.OBS_CONF + "' present on DSD, but the data contains a value for this attribute");
                    attributes.add(new KeyValueImpl(obsArr[2], this.OBS_CONF));
                }
                if (obsPreBreakPresent) {
                    if (!this.hasObsPreBeak) throw new IllegalArgumentException("No observation attribute 'OBS_PRE_BREAK' present on DSD, but the data contains a value for this attribute");
                    String obsAttr = obsArr[3].equals(this.missingValue) ? "NaN" : obsArr[3];
                    attributes.add(new KeyValueImpl(obsAttr, OBS_PRE_BREAK));
                }
                if (obsVal == null) {
                    obsVal = "";
                }
                if (obsVal.equals(this.missingValue)) {
                    obsVal = "NaN";
                }
                this.currentObs = new ObservationImpl(this.currentKey, obsDate, obsVal, attributes, new AnnotationBean[0]);
                return;
            }
            Keyable prevKey = this.currentKey;
            if (!this.moveNextKeyable()) return;
            if (!this.currentKey.equals(prevKey)) break;
        }
        this.lookedAhead = true;
    }

    public void reset() {
        this.currentlyProcessingReaderIndex = -1;
        this.ediDataReader = null;
        this.currentObsPos = -1;
        this.keyablePosition = -1;
        this.currentKey = null;
        this.currentObs = null;
    }

    public DATA_TYPE getDataType() {
        return DATA_TYPE.EDI_TS;
    }

    public void copyToOutputStream(OutputStream outputStream) {
        this.ediDataReader.copyToStream(outputStream);
    }

    public void close() {
        for (EDIDataReader dataReader : this.ediDataReaders) {
            dataReader.close();
        }
    }

    private class CachedTimeRanges {
        private Map<String, List<String>> timeRangeMap = new HashMap<String, List<String>>();

        private CachedTimeRanges() {
        }

        public Map<String, List<String>> getTimeRangeMap() {
            return this.timeRangeMap;
        }
    }
}

