/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.reader.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIReader;
import org.sdmxsource.sdmx.ediparser.model.reader.FileReader;
import org.sdmxsource.sdmx.ediparser.model.reader.impl.FileReaderImpl;
import org.sdmxsource.sdmx.ediparser.util.EDIUtil;

public class EDIReaderImpl
extends FileReaderImpl
implements EDIReader,
FileReader {
    private static Pattern unreservedPlus = Pattern.compile("(?<!\\?)\\+");
    private static Pattern unreservedDash = Pattern.compile("(?<!\\?)\\'");
    private static Pattern unreservedQuestionMark = Pattern.compile("(?<!\\?)\\?(?![\\+\\.'\\?:])");
    private EDI_PREFIX lineType;
    private List<String> tmpStore;
    public boolean endOfFileReached;

    public EDIReaderImpl(ReadableDataLocation dataFile) {
        super(dataFile, "(?<!\\?)\\'", "ISO-8859-1");
    }

    public EDIReaderImpl(ReadableDataLocation dataFile, int startindex, int endIndex) {
        super(dataFile, "(?<!\\?)\\'", startindex, endIndex, "ISO-8859-1");
    }

    @Override
    public EDI_PREFIX getLineType() {
        return this.lineType;
    }

    @Override
    public boolean moveNext() {
        if (this.tmpStore != null) {
            this.currentLine = this.tmpStore.remove(0);
            ++this.filePosition;
            if (this.tmpStore.isEmpty()) {
                this.tmpStore = null;
            }
            this.lineType = EDI_PREFIX.parseString(this.currentLine);
            String linePrefix = this.lineType.getPrefix();
            this.currentLine = this.getCurrentLine().substring(linePrefix.length());
            return true;
        }
        if (this.backLine) {
            this.backLine = false;
            return true;
        }
        boolean nextLine = super.moveNext();
        if (!nextLine) {
            return false;
        }
        if (this.endOfFileReached && this.currentLine.trim().equals("")) {
            this.currentLine = "";
            return true;
        }
        int idx = this.currentLine.indexOf("'");
        if (idx != -1) {
            this.tmpStore = new ArrayList<String>();
            String evaluationString = this.currentLine;
            while (idx != -1) {
                int questionMarkCount = 0;
                int j = idx - 1;
                while (j >= 0) {
                    if (evaluationString.charAt(j) != '?') break;
                    ++questionMarkCount;
                    --j;
                }
                if (questionMarkCount == 0 || questionMarkCount % 2 == 0) {
                    this.tmpStore.add(evaluationString.substring(0, idx));
                    evaluationString = evaluationString.substring(idx + 1);
                    idx = evaluationString.indexOf("'");
                } else {
                    idx = evaluationString.indexOf("'", idx + 1);
                }
                if (idx != -1) continue;
                this.tmpStore.add(evaluationString);
            }
            this.currentLine = this.tmpStore.remove(0);
            if (this.tmpStore.isEmpty()) {
                this.tmpStore = null;
            }
        }
        this.lineType = EDI_PREFIX.parseString(this.currentLine);
        String linePrefix = this.lineType.getPrefix();
        if (linePrefix.equals("UNZ+")) {
            this.endOfFileReached = true;
        }
        this.currentLine = this.getCurrentLine().substring(linePrefix.length());
        return true;
    }

    @Override
    public String parseTextString() {
        String inputString = this.currentLine;
        if (unreservedPlus.matcher(inputString).find()) {
            throw new IllegalArgumentException("Error processing line '" + this.currentLine + "' Reserved character '+' must be escaped by escape character '?'");
        }
        if (unreservedDash.matcher(inputString).find()) {
            throw new IllegalArgumentException("Reserved character ''' must be escaped by escape character '?'");
        }
        if (unreservedQuestionMark.matcher(inputString).find()) {
            throw new IllegalArgumentException("Reserved character '?' must be escaped by escape character '?'");
        }
        return EDIUtil.ediToString(inputString);
    }
}

