/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.util.io.URIUtil;

public class OverflowWriteableDataLocation
implements WriteableDataLocation {
    private static final long serialVersionUID = 2278635606454143014L;
    private static long maxMemory = 0x1E00000L;
    private static long currentMemory = 0L;
    private URI tmpUri;
    private OutputStream out;
    private Buffer inMemoryBuffer = new Buffer();
    private String name;

    public OverflowWriteableDataLocation() {
        this(null);
    }

    public OverflowWriteableDataLocation(String name) {
        if (currentMemory > maxMemory) {
            this.tmpUri = URIUtil.getTemporaryURI();
            this.out = URIUtil.getOutputStream(this.tmpUri);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        if (this.out == null) {
            return new ByteArrayInputStream(this.inMemoryBuffer.toByteArray());
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return URIUtil.getInputStream(this.tmpUri);
    }

    public OutputStream getOutputStream() {
        return this.inMemoryBuffer;
    }

    public void close() {
        if (this.out != null) {
            URIUtil.closeUri(this.tmpUri);
            URIUtil.deleteUri(this.tmpUri);
        } else if (this.inMemoryBuffer != null) {
            currentMemory -= (long)this.inMemoryBuffer.getCount();
            this.inMemoryBuffer = null;
        }
    }

    public String toString() {
        if (this.tmpUri == null) {
            return new String(this.inMemoryBuffer.toByteArray());
        }
        return "OverflowWriteableDataLocation: " + this.tmpUri.toString();
    }

    public static void setMaxMemoryKb(long maxMemory) {
        OverflowWriteableDataLocation.maxMemory = maxMemory * 1024L;
    }

    public static long getCurrentMemory() {
        return currentMemory;
    }

    public static long getMaxMemory() {
        return maxMemory;
    }

    private class Buffer
    extends ByteArrayOutputStream {
        private boolean isOverflow;

        private Buffer() {
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            if (this.isOverflow) {
                try {
                    OverflowWriteableDataLocation.this.out.write(b, off, len);
                }
                catch (IOException e) {
                    throw new SdmxException((Throwable)e, "IO Exception whilst trying to write to file output stream:" + OverflowWriteableDataLocation.this.tmpUri);
                }
            } else {
                super.write(b, off, len);
                this.overflow();
            }
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void write(int b) {
            if (this.isOverflow) {
                try {
                    OverflowWriteableDataLocation.this.out.write(b);
                }
                catch (IOException e) {
                    throw new SdmxException((Throwable)e, "IO Exception whilst trying to write to file output stream:" + OverflowWriteableDataLocation.this.tmpUri);
                }
            } else {
                super.write(b);
                this.overflow();
            }
        }

        private void overflow() {
            currentMemory = this.count;
            if (currentMemory >= maxMemory) {
                this.isOverflow = true;
                if (OverflowWriteableDataLocation.this.tmpUri == null) {
                    OverflowWriteableDataLocation.this.tmpUri = URIUtil.getTemporaryURI();
                    OverflowWriteableDataLocation.this.out = URIUtil.getOutputStream(OverflowWriteableDataLocation.this.tmpUri);
                }
                try {
                    this.writeTo(OverflowWriteableDataLocation.this.out);
                }
                catch (IOException e) {
                    throw new SdmxException((Throwable)e, "IO Exception whilst trying to overflow from in memory outputstream to file output stream:" + OverflowWriteableDataLocation.this.tmpUri);
                }
                currentMemory -= this.count;
                this.buf = new byte[100];
                this.count = 0;
            }
        }

        @Override
        public void flush() throws IOException {
            if (OverflowWriteableDataLocation.this.out != null) {
                OverflowWriteableDataLocation.this.out.flush();
            }
        }
    }
}

