/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxServiceUnavailableException;
import org.sdmxsource.sdmx.api.exception.SdmxUnauthorisedException;

public class URLUtil {
    private static final Logger LOG = Logger.getLogger(URLUtil.class);

    public static InputStream getInputStream(URL url) {
        LOG.debug((Object)("Get Input Stream from URL: " + url));
        URLConnection connection = URLUtil.getconnection(url);
        return URLUtil.getInputStream(connection, null);
    }

    private static URLConnection getconnection(URL url) {
        URLConnection urlc;
        LOG.debug((Object)("Get URLConnection: " + url));
        try {
            urlc = url.openConnection();
        }
        catch (IOException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, new Object[]{url.toString()});
        }
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        urlc.addRequestProperty("Accept-Encoding", "gzip");
        return urlc;
    }

    private static InputStream getInputStream(URLConnection urlc, Object payload) {
        InputStream stream;
        try {
            if (payload != null) {
                PrintStream ps = new PrintStream(urlc.getOutputStream());
                ps.print(payload);
                ps.close();
            }
            stream = URLUtil.getInputStream(urlc);
        }
        catch (IOException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, new Object[]{e.getMessage()});
        }
        if (urlc.getContentEncoding() != null && urlc.getContentEncoding().equals("gzip")) {
            LOG.debug((Object)"Response recieved as GZIP");
            try {
                stream = new GZIPInputStream(stream);
            }
            catch (IOException e) {
                throw new SdmxException((Throwable)e, "I/O Ecception while trying to unzip stream retrieved from service:" + urlc.getURL());
            }
        }
        return stream;
    }

    private static InputStream getInputStream(URLConnection urlc) {
        try {
            return urlc.getInputStream();
        }
        catch (ConnectException c) {
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, new Object[]{urlc.getURL()});
        }
        catch (SocketException c) {
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, new Object[]{urlc.getURL()});
        }
        catch (SocketTimeoutException c) {
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_SOCKET_TIMEOUT, new Object[]{urlc.getReadTimeout()});
        }
        catch (IOException e) {
            if (urlc instanceof HttpURLConnection) {
                try {
                    if (((HttpURLConnection)urlc).getResponseCode() == 401) {
                        throw new SdmxUnauthorisedException(e.getMessage());
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                HttpURLConnection httpConnection = (HttpURLConnection)urlc;
                InputStream is = httpConnection.getErrorStream();
                if (is != null) {
                    return is;
                }
            }
            String message = null;
            if (e.getMessage().contains("Server returned HTTP response code:")) {
                String split = e.getMessage().split(":")[1];
                split = split.trim();
                split = split.substring(0, split.indexOf(" "));
                try {
                    int responseCode = Integer.parseInt(split);
                    switch (responseCode) {
                        case 400: {
                            message = "Response Code 400 = The request could not be understood by the server due to malformed syntax";
                            break;
                        }
                        case 401: {
                            message = "Response Code 401 = Authentication failure";
                            break;
                        }
                        case 403: {
                            message = "Response Code 403 = The server understood the request, but is refusing to fulfill it";
                            break;
                        }
                        case 404: {
                            message = "Response Code 404 = Page not found";
                        }
                    }
                    System.out.println(responseCode);
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            if (message != null) {
                throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, new Object[]{message});
            }
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, new Object[]{urlc.getURL()});
        }
    }

    public static URL getURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new SdmxException("Malformed URL: " + urlStr);
        }
    }

    public static boolean urlExists(URL url) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            if (Integer.toString(con.getResponseCode()).startsWith("2")) {
                return true;
            }
            LOG.warn((Object)("URL " + url + " returns status code: " + con.getResponseCode()));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

