/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.DimensionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DimensionListType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionListBean;
import org.sdmxsource.sdmx.api.model.mutable.base.IdentifiableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionListMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DimensionBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class DimensionListBeanImpl
extends IdentifiableBeanImpl
implements DimensionListBean {
    private static final long serialVersionUID = 8263386049386394325L;
    private List<DimensionBean> dimensions = new ArrayList<DimensionBean>();

    public DimensionListBeanImpl(DimensionListMutableBean bean, DataStructureBean parent) {
        super((IdentifiableMutableBean)bean, (SdmxStructureBean)parent);
        if (bean.getDimensions() != null) {
            int pos = 1;
            for (DimensionMutableBean currentDimension : bean.getDimensions()) {
                this.dimensions.add(new DimensionBeanImpl(currentDimension, pos, this));
                ++pos;
            }
        }
    }

    public DimensionListBeanImpl(DimensionListType dimensionList, MaintainableBean parent) {
        super(dimensionList, SDMX_STRUCTURE_TYPE.DIMENSION_DESCRIPTOR, (SdmxStructureBean)parent);
        int pos = 1;
        if (dimensionList.getDimensionList() != null) {
            for (org.sdmx.resources.sdmxml.schemas.v21.structure.DimensionType dimension : dimensionList.getDimensionList()) {
                this.dimensions.add(new DimensionBeanImpl(dimension, (DimensionListBean)this, pos));
                ++pos;
            }
        }
        if (ObjectUtil.validCollection(dimensionList.getMeasureDimensionList())) {
            if (dimensionList.getMeasureDimensionList().size() > 1) {
                throw new SdmxSemmanticException("Can not have more then one measure dimension");
            }
            this.dimensions.add(new DimensionBeanImpl(dimensionList.getMeasureDimensionList().get(0), (DimensionListBean)this, pos));
            ++pos;
        }
        if (ObjectUtil.validCollection(dimensionList.getTimeDimensionList())) {
            if (dimensionList.getTimeDimensionList().size() > 1) {
                throw new SdmxSemmanticException("Can not have more then one time dimension");
            }
            this.dimensions.add(new DimensionBeanImpl(dimensionList.getTimeDimensionList().get(0), (DimensionListBean)this, pos));
        }
        this.validateDimensionList();
    }

    public DimensionListBeanImpl(KeyFamilyType bean, MaintainableBean parent) {
        super("DimensionDescriptor", SDMX_STRUCTURE_TYPE.DIMENSION_DESCRIPTOR, (SdmxStructureBean)parent);
        int pos = 1;
        ComponentsType components = bean.getComponents();
        try {
            if (components != null) {
                for (org.sdmx.resources.sdmxml.schemas.v20.structure.DimensionType currentDimension : components.getDimensionList()) {
                    this.dimensions.add(new DimensionBeanImpl(currentDimension, (DimensionListBean)this, pos));
                    ++pos;
                }
                if (components.getTimeDimension() != null) {
                    this.dimensions.add(new DimensionBeanImpl(components.getTimeDimension(), (DimensionListBean)this, pos));
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        this.validateDimensionList();
    }

    public DimensionListBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.KeyFamilyType bean, MaintainableBean parent) {
        super("DimensionDescriptor", SDMX_STRUCTURE_TYPE.DIMENSION_DESCRIPTOR, (SdmxStructureBean)parent);
        org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ComponentsType components = bean.getComponents();
        int pos = 1;
        if (components != null) {
            for (DimensionType currentDimension : components.getDimensionList()) {
                this.dimensions.add(new DimensionBeanImpl(currentDimension, (DimensionListBean)this, pos));
                ++pos;
            }
            if (components.getTimeDimension() != null) {
                this.dimensions.add(new DimensionBeanImpl(components.getTimeDimension(), (DimensionListBean)this, pos));
            }
        }
        this.validateDimensionList();
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            DimensionListBean that = (DimensionListBean)bean;
            if (!super.equivalent(this.getDimensions(), that.getDimensions(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal((IdentifiableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validateDimensionList() {
        ArrayList idList = new ArrayList();
        Collections.sort(this.dimensions);
        for (DimensionBean currentDimensionBean : this.dimensions) {
            if (!idList.contains(currentDimensionBean.getId())) continue;
            throw new SdmxSemmanticException("Duplicate Dimension Id : " + currentDimensionBean.getId());
        }
    }

    @Override
    public String getId() {
        return "DimensionDescriptor";
    }

    public List<DimensionBean> getDimensions() {
        return new ArrayList<DimensionBean>(this.dimensions);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.dimensions, composites);
        return composites;
    }
}

