/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v20.structure.GroupType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.GroupDimensionType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.IdentifiableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.GroupMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class GroupBeanImpl
extends IdentifiableBeanImpl
implements GroupBean {
    private static final long serialVersionUID = 1L;
    private List<String> dimensionRef = new ArrayList<String>();
    private CrossReferenceBean attachmentConstraintRef;

    public GroupBeanImpl(GroupMutableBean bean, SdmxStructureBean parent) {
        super((IdentifiableMutableBean)bean, parent);
        if (bean.getAttachmentConstraintRef() != null) {
            this.attachmentConstraintRef = new CrossReferenceBeanImpl((SDMXBean)this, bean.getAttachmentConstraintRef());
        }
        if (bean.getDimensionRef() != null) {
            this.dimensionRef = new ArrayList<String>(bean.getDimensionRef());
        }
        this.validateGroupAttributes();
    }

    public GroupBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.GroupType group, SdmxStructureBean parent) {
        super(group, SDMX_STRUCTURE_TYPE.GROUP, parent);
        if (group.getAttachmentConstraint() != null) {
            this.attachmentConstraintRef = RefUtil.createReference(this, group.getAttachmentConstraint());
        }
        if (group.getGroupDimensionList() != null) {
            this.dimensionRef = new ArrayList<String>();
            for (GroupDimensionType each : group.getGroupDimensionList()) {
                this.dimensionRef.add(RefUtil.createLocalIdReference(each.getDimensionReference()));
            }
        }
        this.validateGroupAttributes();
    }

    public GroupBeanImpl(GroupType group, SdmxStructureBean parent) {
        super((XmlObject)group, SDMX_STRUCTURE_TYPE.GROUP, group.getId(), null, group.getAnnotations(), parent);
        if (group.getDimensionRefList() != null) {
            this.dimensionRef = new ArrayList<String>(group.getDimensionRefList());
        }
        this.validateGroupAttributes();
    }

    public GroupBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.GroupType group, SdmxStructureBean parent) {
        super((XmlObject)group, SDMX_STRUCTURE_TYPE.GROUP, group.getId(), null, group.getAnnotations(), parent);
        if (group.getDimensionRefList() != null) {
            this.dimensionRef = new ArrayList<String>(group.getDimensionRefList());
        }
        this.validateGroupAttributes();
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            GroupBean that = (GroupBean)bean;
            if (!ObjectUtil.equivalentCollection(this.dimensionRef, (Collection)that.getDimensionRefs())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.attachmentConstraintRef, (Object)that.getAttachmentConstraintRef())) {
                return false;
            }
            return super.deepEqualsInternal((IdentifiableBean)that, includeFinalProperties);
        }
        return false;
    }

    protected void validateGroupAttributes() throws SdmxSemmanticException {
        if (this.attachmentConstraintRef == null && (this.dimensionRef == null || this.dimensionRef.size() == 0)) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, new Object[]{"Group", "DimensionRef/AttachmentConstraintRef"});
        }
        if (this.attachmentConstraintRef != null && this.dimensionRef.size() > 0) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MUTUALLY_EXCLUSIVE, new Object[]{"DimensionRef", "AttachmentConstraintRef", "Group"});
        }
    }

    public List<String> getDimensionRefs() {
        return new ArrayList<String>(this.dimensionRef);
    }

    public CrossReferenceBean getAttachmentConstraintRef() {
        return this.attachmentConstraintRef;
    }
}

