/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.DATA_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.DIMENSION_AT_OBSERVATION;
import org.sdmxsource.sdmx.api.constants.OBSERVATION_ACTION;
import org.sdmxsource.sdmx.api.constants.ORDERED_OPERATOR;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TEXT_SEARCH;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.TimeRange;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexComponentValue;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuery;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuerySelectionGroup;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.BaseDataQuery;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex.ComplexDataQuerySelectionGroupImpl;
import org.sdmxsource.util.ObjectUtil;

public class ComplexDataQueryImpl
extends BaseDataQuery
implements ComplexDataQuery {
    private static final long serialVersionUID = 2107508015963353910L;
    private Integer defaultLimit;
    private OBSERVATION_ACTION obsAction;
    private boolean hasExplicitMeasures = false;
    private DATA_QUERY_DETAIL queryDetail;
    private String datasetId;
    private TEXT_SEARCH datasetIdOperator;
    private Set<DataProviderBean> dataProviders = new HashSet<DataProviderBean>();
    private ProvisionAgreementBean provisionAgreement;
    private List<TimeRange> lastUpdatedDate = new ArrayList<TimeRange>();
    private List<ComplexDataQuerySelectionGroup> complexDataQuerySelectionGroups = new ArrayList<ComplexDataQuerySelectionGroup>();

    public ComplexDataQueryImpl(String datasetId, TEXT_SEARCH datasetIdOperator, Set<DataProviderBean> dataProviders, DataStructureBean dataStructure, DataflowBean dataFlow, ProvisionAgreementBean provisionAgreement, List<TimeRange> lastUpdatedDate, Integer maxObs, Integer defaultLimit, boolean orderAsc, OBSERVATION_ACTION obsAction, String dimensionAtObservation, boolean hasExplicitMeasures, DATA_QUERY_DETAIL queryDetail, Collection<ComplexDataQuerySelectionGroup> complexDataQuerySelectionGroup) {
        this.datasetId = datasetId;
        this.datasetIdOperator = datasetIdOperator != null ? datasetIdOperator : TEXT_SEARCH.EQUAL;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        this.dataStructureBean = dataStructure;
        this.dataflowBean = dataFlow;
        this.provisionAgreement = provisionAgreement;
        if (lastUpdatedDate != null) {
            this.lastUpdatedDate = new ArrayList<TimeRange>(lastUpdatedDate);
        }
        if (orderAsc) {
            this.firstNObs = maxObs;
        } else {
            this.lastNObs = maxObs;
        }
        this.defaultLimit = defaultLimit;
        this.obsAction = obsAction != null ? obsAction : OBSERVATION_ACTION.ACTIVE;
        this.dimensionAtObservation = dimensionAtObservation;
        if (dimensionAtObservation != null) {
            if (dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.ALL.getVal()) || dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.TIME.getVal())) {
                this.dimensionAtObservation = dimensionAtObservation;
            } else {
                this.checkDimensionExistence(dimensionAtObservation, dataStructure);
            }
        } else {
            this.dimensionAtObservation = this.getDimensionAtObservationLevel(dataStructure);
        }
        this.hasExplicitMeasures = hasExplicitMeasures;
        this.queryDetail = queryDetail != null ? queryDetail : DATA_QUERY_DETAIL.FULL;
        if (complexDataQuerySelectionGroup != null) {
            for (ComplexDataQuerySelectionGroup cdqsg : complexDataQuerySelectionGroup) {
                if (cdqsg == null) continue;
                this.complexDataQuerySelectionGroups.add(cdqsg);
            }
        }
        this.validateQuery();
        this.validateProvisionAgreement();
    }

    public ComplexDataQueryImpl(String datasetId, TEXT_SEARCH datasetIdOperator, Set<DataProviderBean> dataProviders, DataStructureBean dataStructure, DataflowBean dataFlow, ProvisionAgreementBean provisionAgreement, List<TimeRange> lastUpdatedDate, Integer firstNObs, Integer lastNObs, Integer defaultLimit, OBSERVATION_ACTION obsAction, String dimensionAtObservation, boolean hasExplicitMeasures, DATA_QUERY_DETAIL queryDetail, Collection<ComplexDataQuerySelectionGroup> complexDataQuerySelectionGroup) {
        this.datasetId = datasetId;
        this.datasetIdOperator = datasetIdOperator != null ? datasetIdOperator : TEXT_SEARCH.EQUAL;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        if (lastUpdatedDate != null) {
            this.lastUpdatedDate = new ArrayList<TimeRange>(lastUpdatedDate);
        }
        this.dimensionAtObservation = dimensionAtObservation;
        this.dataStructureBean = dataStructure;
        this.dataflowBean = dataFlow;
        this.provisionAgreement = provisionAgreement;
        this.firstNObs = firstNObs;
        this.lastNObs = lastNObs;
        this.defaultLimit = defaultLimit;
        this.obsAction = obsAction != null ? obsAction : OBSERVATION_ACTION.ACTIVE;
        if (dimensionAtObservation != null) {
            if (dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.ALL.getVal()) || dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.TIME.getVal())) {
                this.dimensionAtObservation = dimensionAtObservation;
            } else {
                this.checkDimensionExistence(dimensionAtObservation, dataStructure);
            }
        } else {
            this.dimensionAtObservation = this.getDimensionAtObservationLevel(dataStructure);
        }
        this.hasExplicitMeasures = hasExplicitMeasures;
        this.queryDetail = queryDetail != null ? queryDetail : DATA_QUERY_DETAIL.FULL;
        if (complexDataQuerySelectionGroup != null) {
            for (ComplexDataQuerySelectionGroup cdqsg : complexDataQuerySelectionGroup) {
                if (cdqsg == null) continue;
                this.complexDataQuerySelectionGroups.add(cdqsg);
            }
        }
        this.validateQuery();
        this.validateProvisionAgreement();
    }

    public ComplexDataQueryImpl(String datasetId, TEXT_SEARCH datasetIdOperator, Set<DataProviderBean> dataProviders, DataStructureBean dataStructure, DataflowBean dataFlow, ProvisionAgreementBean provisionAgreement, List<TimeRange> lastUpdatedDate, Integer maxObs, boolean orderAsc, Integer defaultLimit, OBSERVATION_ACTION obsAction, String dimensionAtObservation, boolean hasExplicitMeasures, DATA_QUERY_DETAIL queryDetail, ComplexDataQuerySelectionGroup ... complexDataQuerySelectionGroup) {
        this.datasetId = datasetId;
        this.datasetIdOperator = datasetIdOperator != null ? datasetIdOperator : TEXT_SEARCH.EQUAL;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        if (lastUpdatedDate != null) {
            this.lastUpdatedDate = new ArrayList<TimeRange>(lastUpdatedDate);
        }
        this.dimensionAtObservation = dimensionAtObservation;
        this.dataStructureBean = dataStructure;
        this.dataflowBean = dataFlow;
        this.provisionAgreement = provisionAgreement;
        if (orderAsc) {
            this.firstNObs = maxObs;
        } else {
            this.lastNObs = maxObs;
        }
        this.defaultLimit = defaultLimit;
        this.obsAction = obsAction != null ? obsAction : OBSERVATION_ACTION.ACTIVE;
        if (dimensionAtObservation != null) {
            if (dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.ALL.getVal()) || dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.TIME.getVal())) {
                this.dimensionAtObservation = dimensionAtObservation;
            } else {
                this.checkDimensionExistence(dimensionAtObservation, dataStructure);
            }
        } else {
            this.dimensionAtObservation = this.getDimensionAtObservationLevel(dataStructure);
        }
        this.hasExplicitMeasures = hasExplicitMeasures;
        this.queryDetail = queryDetail != null ? queryDetail : DATA_QUERY_DETAIL.FULL;
        if (complexDataQuerySelectionGroup != null) {
            for (ComplexDataQuerySelectionGroup cdqsg : complexDataQuerySelectionGroup) {
                if (cdqsg == null) continue;
                this.complexDataQuerySelectionGroups.add(cdqsg);
            }
        }
        this.validateQuery();
        this.validateProvisionAgreement();
    }

    public ComplexDataQueryImpl(String datasetId, TEXT_SEARCH datasetIdOperator, Set<DataProviderBean> dataProviders, DataStructureBean dataStructure, DataflowBean dataFlow, ProvisionAgreementBean provisionAgreement, List<TimeRange> lastUpdatedDate, Integer maxObs, boolean orderAsc, Integer defaultLimit, OBSERVATION_ACTION obsAction, String dimensionAtObservation, boolean hasExplicitMeasures, DATA_QUERY_DETAIL queryDetail, Set<ComplexDataQuerySelection> complexSelections, Date dateFrom, ORDERED_OPERATOR dateFromOperator, Date dateTo, ORDERED_OPERATOR dateToOperator, Set<ComplexComponentValue> primaryMeasureValues) {
        this.datasetId = datasetId;
        this.datasetIdOperator = datasetIdOperator != null ? datasetIdOperator : TEXT_SEARCH.EQUAL;
        if (dataProviders != null) {
            this.dataProviders = new HashSet<DataProviderBean>(dataProviders);
        }
        if (lastUpdatedDate != null) {
            this.lastUpdatedDate = new ArrayList<TimeRange>(lastUpdatedDate);
        }
        this.dimensionAtObservation = dimensionAtObservation;
        this.dataStructureBean = dataStructure;
        this.dataflowBean = dataFlow;
        this.provisionAgreement = provisionAgreement;
        if (orderAsc) {
            this.firstNObs = maxObs;
        } else {
            this.lastNObs = maxObs;
        }
        this.defaultLimit = defaultLimit;
        this.obsAction = obsAction != null ? obsAction : OBSERVATION_ACTION.ACTIVE;
        if (dimensionAtObservation != null) {
            if (dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.ALL.getVal()) || dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.TIME.getVal())) {
                this.dimensionAtObservation = dimensionAtObservation;
            } else {
                this.checkDimensionExistence(dimensionAtObservation, dataStructure);
            }
        } else {
            this.dimensionAtObservation = this.getDimensionAtObservationLevel(dataStructure);
        }
        this.hasExplicitMeasures = hasExplicitMeasures;
        this.queryDetail = queryDetail != null ? queryDetail : DATA_QUERY_DETAIL.FULL;
        if (ObjectUtil.validCollection(complexSelections) || dateFrom != null || dateTo != null) {
            SdmxDateImpl sdmxDateFrom = null;
            if (dateFrom != null) {
                sdmxDateFrom = new SdmxDateImpl(dateFrom, TIME_FORMAT.DATE);
            }
            SdmxDateImpl sdmxDateTo = null;
            if (dateFrom != null) {
                sdmxDateTo = new SdmxDateImpl(dateTo, TIME_FORMAT.DATE);
            }
            this.complexDataQuerySelectionGroups.add(new ComplexDataQuerySelectionGroupImpl(complexSelections, sdmxDateFrom, dateFromOperator, sdmxDateTo, dateToOperator, primaryMeasureValues));
        }
        this.validateQuery();
        this.validateProvisionAgreement();
    }

    public ComplexDataQueryImpl(String datasetId, TEXT_SEARCH datasetIdOperator, Set<DataProviderBean> dataProviders, DataStructureBean dataStructure, DataflowBean dataFlow, ProvisionAgreementBean provisionAgreement, List<TimeRange> lastUpdatedDate, Integer firstNObs, Integer lastNObs, Integer defaultLimit, OBSERVATION_ACTION obsAction, String dimensionAtObservation, boolean hasExplicitMeasures, DATA_QUERY_DETAIL queryDetail, Set<ComplexDataQuerySelection> complexSelections, Date dateFrom, ORDERED_OPERATOR dateFromOperator, Date dateTo, ORDERED_OPERATOR dateToOperator, Set<ComplexComponentValue> primaryMeasureValues) {
        this.datasetId = datasetId;
        this.datasetIdOperator = datasetIdOperator != null ? datasetIdOperator : TEXT_SEARCH.EQUAL;
        this.dataProviders = dataProviders;
        this.dataStructureBean = dataStructure;
        this.dataflowBean = dataFlow;
        this.provisionAgreement = provisionAgreement;
        this.lastUpdatedDate = lastUpdatedDate;
        this.firstNObs = firstNObs;
        this.lastNObs = lastNObs;
        this.defaultLimit = defaultLimit;
        this.obsAction = obsAction != null ? obsAction : OBSERVATION_ACTION.ACTIVE;
        this.dimensionAtObservation = dimensionAtObservation;
        if (dimensionAtObservation != null) {
            if (dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.ALL.getVal()) || dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.TIME.getVal())) {
                this.dimensionAtObservation = dimensionAtObservation;
            } else {
                this.checkDimensionExistence(dimensionAtObservation, dataStructure);
            }
        } else {
            this.dimensionAtObservation = this.getDimensionAtObservationLevel(dataStructure);
        }
        this.hasExplicitMeasures = hasExplicitMeasures;
        this.queryDetail = queryDetail != null ? queryDetail : DATA_QUERY_DETAIL.FULL;
        if (ObjectUtil.validCollection(complexSelections) || dateFrom != null || dateTo != null) {
            SdmxDateImpl sdmxDateFrom = null;
            if (dateFrom != null) {
                sdmxDateFrom = new SdmxDateImpl(dateFrom, TIME_FORMAT.DATE);
            }
            SdmxDateImpl sdmxDateTo = null;
            if (dateFrom != null) {
                sdmxDateTo = new SdmxDateImpl(dateTo, TIME_FORMAT.DATE);
            }
            this.complexDataQuerySelectionGroups.add(new ComplexDataQuerySelectionGroupImpl(complexSelections, sdmxDateFrom, dateFromOperator, sdmxDateTo, dateToOperator, primaryMeasureValues));
        }
        this.validateQuery();
        this.validateProvisionAgreement();
    }

    @Override
    protected Set<String> getQueryComponentIds() {
        HashSet<String> returnSet = new HashSet<String>();
        for (ComplexDataQuerySelectionGroup dqsg : this.getSelectionGroups()) {
            for (ComplexDataQuerySelection dqs : dqsg.getSelections()) {
                returnSet.add(dqs.getComponentId());
            }
        }
        return returnSet;
    }

    private void validateProvisionAgreement() {
        if (this.provisionAgreement != null) {
            CrossReferenceBean dataflowReference = this.provisionAgreement.getStructureUseage();
            if (dataflowReference == null) {
                throw new IllegalArgumentException("Can not create DataQuery, Dataflow is required");
            }
            if (!(dataflowReference.getMaintainableReference().getMaintainableId().equals(this.dataflowBean.getId()) && dataflowReference.getMaintainableReference().getVersion().equals(this.dataflowBean.getVersion()) && dataflowReference.getMaintainableReference().getAgencyId().equals(this.dataflowBean.getAgencyId()))) {
                throw new IllegalArgumentException("Can not create DataQuery, Dataflow provided is not referenced by the Provision Agreement");
            }
        }
    }

    private void checkDimensionExistence(String dimensionAtObs, DataStructureBean dataStructure) {
        DimensionBean dimension = dataStructure.getDimension(dimensionAtObs);
        if (dimension == null) {
            throw new IllegalArgumentException("Can not create DataQuery, The dimension at observation is not included in the Dimension list of the DSD ");
        }
    }

    private String getDimensionAtObservationLevel(DataStructureBean dataStructure) {
        if (dataStructure.getTimeDimension() != null) {
            return DIMENSION_AT_OBSERVATION.TIME.getVal();
        }
        return ((DimensionBean)dataStructure.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION}).get(0)).getId();
    }

    public OBSERVATION_ACTION getObservationAction() {
        return this.obsAction;
    }

    public String dimensionAtObservation() {
        return this.dimensionAtObservation;
    }

    public boolean hasExplicitMeasures() {
        return this.hasExplicitMeasures;
    }

    public DATA_QUERY_DETAIL getDataQueryDetail() {
        return this.queryDetail;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public TEXT_SEARCH getDatasetIdOperator() {
        return this.datasetIdOperator;
    }

    public List<TimeRange> getLastUpdatedDateTimeRange() {
        return new ArrayList<TimeRange>(this.lastUpdatedDate);
    }

    public Set<DataProviderBean> getDataProvider() {
        return new HashSet<DataProviderBean>(this.dataProviders);
    }

    public DataStructureBean getDataStructure() {
        return this.dataStructureBean;
    }

    public DataflowBean getDataflow() {
        return this.dataflowBean;
    }

    public ProvisionAgreementBean getProvisionAgreement() {
        return this.provisionAgreement;
    }

    public List<ComplexDataQuerySelectionGroup> getSelectionGroups() {
        return new ArrayList<ComplexDataQuerySelectionGroup>(this.complexDataQuerySelectionGroups);
    }

    public boolean hasSelections() {
        return this.complexDataQuerySelectionGroups.size() > 0;
    }

    public Integer getFirstNObservations() {
        return this.firstNObs;
    }

    public Integer getLastNObservations() {
        return this.lastNObs;
    }

    public Integer getDefaultLimit() {
        return this.defaultLimit;
    }
}

