/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.header;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.ContactType;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.PartyType;
import org.sdmx.resources.sdmxml.schemas.v21.message.SenderType;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.ContactBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ContactBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.util.ObjectUtil;

public class PartyBeanImpl
implements PartyBean,
Serializable {
    private static final long serialVersionUID = -4454791463810290878L;
    private List<TextTypeWrapper> name = new ArrayList<TextTypeWrapper>();
    private String id;
    private List<ContactBean> contacts = new ArrayList<ContactBean>();
    private String timeZone;

    public PartyBeanImpl(List<TextTypeWrapper> name, String id, List<ContactBean> contacts, String timeZone) {
        if (name != null) {
            this.name = new ArrayList<TextTypeWrapper>(name);
        }
        this.id = id;
        if (contacts != null) {
            this.contacts = new ArrayList<ContactBean>(contacts);
        }
        this.timeZone = timeZone;
        this.validate();
    }

    public PartyBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.message.PartyType partyType) {
        this.id = partyType.getId();
        if (ObjectUtil.validCollection(partyType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : partyType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (ObjectUtil.validCollection(partyType.getContactList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.message.ContactType contactType : partyType.getContactList()) {
                this.contacts.add(new ContactBeanImpl(contactType));
            }
        }
        this.validate();
    }

    public PartyBeanImpl(SenderType senderType) {
        this.id = senderType.getId();
        if (ObjectUtil.validCollection(senderType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : senderType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (ObjectUtil.validCollection(senderType.getContactList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.message.ContactType contactType : senderType.getContactList()) {
                this.contacts.add(new ContactBeanImpl(contactType));
            }
        }
        this.timeZone = senderType.getTimezone();
        this.validate();
    }

    public PartyBeanImpl(PartyType partyType) {
        this.id = partyType.getId();
        if (ObjectUtil.validCollection(partyType.getNameList())) {
            for (TextType tt : partyType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (ObjectUtil.validCollection(partyType.getContactList())) {
            for (org.sdmx.resources.sdmxml.schemas.v20.message.ContactType contactType : partyType.getContactList()) {
                this.contacts.add(new ContactBeanImpl(contactType));
            }
        }
        this.validate();
    }

    public PartyBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.PartyType partyType) {
        this.id = partyType.getId();
        if (ObjectUtil.validCollection(partyType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : partyType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (ObjectUtil.validCollection(partyType.getContactList())) {
            for (ContactType contactType : partyType.getContactList()) {
                this.contacts.add(new ContactBeanImpl(contactType));
            }
        }
        this.validate();
    }

    public void validate() throws SdmxSemmanticException {
        Pattern idPattern;
        if (!ObjectUtil.validString((String[])new String[]{this.id})) {
            throw new SdmxSemmanticException("Party missing mandatory id");
        }
        if (this.timeZone != null && !(idPattern = Pattern.compile("(\\+|\\-)(14:00|((0[0-9]|1[0-3]):[0-5][0-9]))")).matcher(this.timeZone).matches()) {
            throw new SdmxSemmanticException("Time zone '" + this.timeZone + "' is in an invalid format. please ensure the format matches the patttern (\\+|\\-)(14:00|((0[0-9]|1[0-3]):[0-5][0-9]) example +12:30");
        }
    }

    public List<TextTypeWrapper> getName() {
        return new ArrayList<TextTypeWrapper>(this.name);
    }

    public String getId() {
        return this.id;
    }

    public List<ContactBean> getContacts() {
        return new ArrayList<ContactBean>(this.contacts);
    }

    public String getTimeZone() {
        return this.timeZone;
    }
}

