/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.reference;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.reference.CodeRefMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.IdentifiableMutableBeanImpl;

public class CodeRefMutableBeanImpl
extends IdentifiableMutableBeanImpl
implements CodeRefMutableBean {
    private static final long serialVersionUID = 1L;
    private List<CodeRefMutableBean> codeRefs = new ArrayList<CodeRefMutableBean>();
    private StructureReferenceBean codeReference;
    private String codelistAliasRef;
    private String codeId;
    private Date validFrom;
    private Date validTo;
    private String levelReference;

    public CodeRefMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODE);
    }

    public CodeRefMutableBeanImpl(HierarchicalCodeBean codeRef) {
        super((IdentifiableBean)codeRef);
        this.codeReference = codeRef.getCodeReference().createMutableInstance();
        this.codelistAliasRef = codeRef.getCodelistAliasRef();
        this.codeId = codeRef.getCodeId();
        if (codeRef.getCodeRefs() != null) {
            for (HierarchicalCodeBean currentCodeRef : codeRef.getCodeRefs()) {
                this.codeRefs.add(new CodeRefMutableBeanImpl(currentCodeRef));
            }
        }
        if (codeRef.getLevel(false) != null) {
            this.levelReference = codeRef.getLevel(false).getFullIdPath(false);
        }
    }

    public String getLevelReference() {
        return this.levelReference;
    }

    public void setLevelReference(String levelReference) {
        this.levelReference = levelReference;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }

    public void setCodeRefs(List<CodeRefMutableBean> codeRefs) {
        this.codeRefs = codeRefs;
    }

    public void addCodeRef(CodeRefMutableBean codeRef) {
        this.codeRefs.add(codeRef);
    }

    public void setCodelistAliasRef(String codelistAliasRef) {
        this.codelistAliasRef = codelistAliasRef;
    }

    public void setCodeId(String codeId) {
        this.codeId = codeId;
    }

    public List<CodeRefMutableBean> getCodeRefs() {
        return this.codeRefs;
    }

    public StructureReferenceBean getCodeReference() {
        return this.codeReference;
    }

    public void setCodeReference(StructureReferenceBean codeReference) {
        this.codeReference = codeReference;
    }

    public String getCodelistAliasRef() {
        return this.codelistAliasRef;
    }

    public String getCodeId() {
        return this.codeId;
    }
}

