/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.conceptscheme;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.MaintainableSuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.conceptscheme.ConceptSuperBeanImpl;

public class ConceptSchemeSuperBeanImpl
extends MaintainableSuperBeanImpl
implements ConceptSchemeSuperBean {
    private static final long serialVersionUID = 1L;
    private Set<ConceptSuperBean> concepts;
    private ConceptSchemeBean conceptSchemeBean;

    public ConceptSchemeSuperBeanImpl(ConceptSchemeBean conceptSchemeType, Map<ConceptBean, CodelistSuperBean> representations) {
        super((MaintainableBean)conceptSchemeType);
        if (conceptSchemeType == null) {
            throw new SdmxSemmanticException(ExceptionCode.JAVA_REQUIRED_OBJECT_NULL, new Object[]{ConceptSchemeBean.class.getCanonicalName()});
        }
        this.conceptSchemeBean = conceptSchemeType;
        this.concepts = new HashSet<ConceptSuperBean>();
        if (conceptSchemeType.getItems() != null) {
            for (ConceptBean currentConcept : conceptSchemeType.getItems()) {
                ConceptSuperBeanImpl concept = new ConceptSuperBeanImpl(currentConcept, representations.get(currentConcept));
                this.concepts.add(concept);
            }
        }
    }

    public ConceptSchemeBean getBuiltFrom() {
        return this.conceptSchemeBean;
    }

    @Override
    public Set<MaintainableBean> getCompositeBeans() {
        Set<MaintainableBean> returnSet = super.getCompositeBeans();
        returnSet.add((MaintainableBean)this.conceptSchemeBean);
        for (ConceptSuperBean concept : this.concepts) {
            returnSet.addAll(concept.getCompositeBeans());
        }
        return returnSet;
    }

    public Set<ConceptSuperBean> getConcepts() {
        return new HashSet<ConceptSuperBean>(this.concepts);
    }
}

