/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.config;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.event.StoreClearEvent;
import com.sencha.gxt.widget.core.client.event.RowClickEvent;
import com.sencha.gxt.widget.core.client.event.RowMouseDownEvent;
import com.sencha.gxt.widget.core.client.event.XEvent;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.selection.CellSelection;
import java.util.Collections;
import java.util.List;
import org.gcube.portlets.user.tdwx.client.config.ExtendedLiveGridView;

public class GridAndCellSelectionModel<M>
extends GridSelectionModel<M> {
    private CellSelection<M> cellSelected;
    private boolean focusCellCalled;
    private int indexOnSelectNoShift;

    protected void onRowClick(RowClickEvent event) {
        if (Element.is((JavaScriptObject)event.getEvent().getEventTarget()) && !this.grid.getView().isSelectableTarget(Element.as((JavaScriptObject)event.getEvent().getEventTarget()))) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        if (this.fireSelectionChangeOnClick) {
            this.fireSelectionChange();
            this.fireSelectionChangeOnClick = false;
        }
        XEvent xe = (XEvent)event.getEvent().cast();
        int rowIndex = event.getRowIndex();
        int colIndex = event.getColumnIndex();
        if (rowIndex == -1) {
            this.deselectAll();
            return;
        }
        Object sel = this.listStore.get(rowIndex);
        boolean isSelected = this.isSelected(sel);
        boolean isControl = xe.getCtrlOrMetaKey();
        boolean isShift = xe.getShiftKey();
        if (this.selectionMode == Style.SelectionMode.MULTI) {
            this.cellSelected = new CellSelection(sel, rowIndex, colIndex);
            if (isSelected && isControl) {
                this.grid.getView().focusCell(rowIndex, colIndex, false);
                this.focusCellCalled = true;
                this.indexOnSelectNoShift = rowIndex;
                this.doDeselect(Collections.singletonList(sel), false);
            } else if (isControl) {
                this.grid.getView().focusCell(rowIndex, colIndex, false);
                this.focusCellCalled = true;
                this.indexOnSelectNoShift = rowIndex;
                this.doSelect(Collections.singletonList(sel), true, false);
            } else if (isSelected && !isControl && !isShift && this.selected.size() > 1) {
                this.doSelect(Collections.singletonList(sel), false, false);
            }
            if (!this.focusCellCalled) {
                this.grid.getView().focusCell(rowIndex, colIndex, false);
            }
        }
    }

    protected void onRowMouseDown(RowMouseDownEvent event) {
        if (Element.is((JavaScriptObject)event.getEvent().getEventTarget()) && !this.grid.getView().isSelectableTarget(Element.as((JavaScriptObject)event.getEvent().getEventTarget()))) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        int rowIndex = event.getRowIndex();
        int colIndex = event.getColumnIndex();
        if (rowIndex == -1) {
            return;
        }
        this.focusCellCalled = false;
        this.mouseDown = true;
        XEvent e = (XEvent)event.getEvent().cast();
        if (event.getEvent().getButton() == 2) {
            if (this.selectionMode != Style.SelectionMode.SINGLE && this.isSelected(this.listStore.get(rowIndex))) {
                return;
            }
            Object sel = this.listStore.get(rowIndex);
            this.cellSelected = new CellSelection(sel, rowIndex, colIndex);
            this.grid.getView().focusCell(rowIndex, colIndex, false);
            this.select(rowIndex, false);
            this.focusCellCalled = true;
        } else {
            Object sel = this.listStore.get(rowIndex);
            if (sel == null) {
                return;
            }
            boolean isSelected = this.isSelected(sel);
            boolean isMeta = e.getCtrlOrMetaKey();
            boolean isShift = event.getEvent().getShiftKey();
            switch (this.selectionMode) {
                case SIMPLE: {
                    this.grid.getView().focusCell(rowIndex, colIndex, false);
                    this.focusCellCalled = true;
                    if (!isSelected) {
                        this.cellSelected = new CellSelection(sel, rowIndex, colIndex);
                        this.select(sel, true);
                        break;
                    }
                    if (!isSelected || !this.deselectOnSimpleClick) break;
                    this.deselect(sel);
                    break;
                }
                case SINGLE: {
                    this.grid.getView().focusCell(rowIndex, colIndex, false);
                    this.focusCellCalled = true;
                    if (isSelected && isMeta) {
                        this.deselect(sel);
                        break;
                    }
                    if (isSelected) break;
                    this.cellSelected = new CellSelection(sel, rowIndex, colIndex);
                    this.select(sel, false);
                    break;
                }
                case MULTI: {
                    if (isMeta) break;
                    if (isShift && this.lastSelected != null) {
                        int end;
                        int start;
                        int last = this.listStore.indexOf(this.lastSelected);
                        this.grid.getView().focusCell(last, colIndex, false);
                        if (this.indexOnSelectNoShift < rowIndex) {
                            start = this.indexOnSelectNoShift;
                            end = rowIndex;
                        } else {
                            start = rowIndex;
                            end = this.indexOnSelectNoShift;
                        }
                        this.focusCellCalled = true;
                        this.select(start, end, false);
                        break;
                    }
                    if (isSelected) break;
                    this.cellSelected = new CellSelection(sel, rowIndex, colIndex);
                    this.indexOnSelectNoShift = rowIndex;
                    this.grid.getView().focusCell(rowIndex, colIndex, false);
                    this.focusCellCalled = true;
                    this.doSelect(Collections.singletonList(sel), false, false);
                }
            }
        }
        this.mouseDown = false;
    }

    public CellSelection<M> getCellSelected() {
        return this.cellSelected;
    }

    public void setCellSelected(CellSelection<M> cellSelected) {
        this.cellSelected = cellSelected;
    }

    public void refresh() {
    }

    protected void onClear(StoreClearEvent<M> event) {
    }

    protected void onRemove(M model) {
    }

    protected void onAdd(List<? extends M> models) {
        super.onAdd(models);
        ModelKeyProvider mod = this.grid.getStore().getKeyProvider();
        for (Object item : this.selected) {
            Log.debug((String)("Selected: " + mod.getKey(item)));
        }
        ExtendedLiveGridView gridView = (ExtendedLiveGridView)this.grid.getView();
        for (Object model : gridView.getCacheStore().getAll()) {
            boolean notChanged = true;
            for (Object item : this.selected) {
                if (mod.getKey(model).compareTo(mod.getKey(item)) != 0) continue;
                this.onSelectChange(model, true);
                notChanged = false;
                break;
            }
            if (!notChanged) continue;
            this.onSelectChange(model, false);
        }
    }

    public void onChangeNumberOfRows() {
        Log.debug((String)"Selection Model Called OnChangeNumberOfRows()");
        if (this.selected != null) {
            Log.debug((String)("Rows Selected: " + this.selected.size()));
        }
        int oldSize = this.selected.size();
        this.selected.clear();
        this.lastSelected = null;
        this.setLastFocused(null);
        if (oldSize > 0) {
            this.fireSelectionChange();
        }
        if (this.selected != null) {
            Log.debug((String)("After deselect Rows Selected: " + this.selected.size()));
        } else {
            Log.debug((String)"After deselect No Rows Selected");
        }
    }
}

