/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.filter.text;

import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.loader.FilterConfig;
import com.sencha.gxt.messages.client.DefaultMessages;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.tdwx.client.filter.text.TextFilterHandler;
import org.gcube.portlets.user.tdwx.client.filter.text.TextMenu;

public class TextFilter<M>
extends Filter<M, String> {
    private List<TextMenu.TextItem> textItems = new ArrayList<TextMenu.TextItem>();
    private TextMenu<M> textMenu;
    private TextFilterMessages messages = new DefaultTextFilterMessages();

    public TextFilter(ValueProvider<? super M, String> valueProvider) {
        super(valueProvider);
        this.setHandler(new TextFilterHandler());
        this.textItems.add(TextMenu.TextItem.CONTAINS);
        this.textItems.add(TextMenu.TextItem.BEGINS);
        this.textItems.add(TextMenu.TextItem.ENDS);
        this.textItems.add(TextMenu.TextItem.SOUNDEX);
        this.menu = this.textMenu = new TextMenu(this);
        this.textMenu.setTextItems(this.textItems);
    }

    public void setContainsValue(String value) {
        this.textMenu.ct.setValue((Object)value);
    }

    public void setBeginsValue(String value) {
        this.textMenu.bg.setValue((Object)value);
    }

    public void setEndsValue(String value) {
        this.textMenu.en.setValue((Object)value);
    }

    public void setSoundexValue(String value) {
        this.textMenu.sd.setValue((Object)value);
    }

    public void setValue(List<FilterConfig> values) {
        this.textMenu.setValue(values);
    }

    public List<FilterConfig> getFilterConfig() {
        return (List)this.getValue();
    }

    public TextFilterMessages getMessages() {
        return this.messages;
    }

    public Object getValue() {
        return this.textMenu.getValue();
    }

    public boolean isActivatable() {
        if (this.textMenu.ct != null && this.textMenu.ct.getCurrentValue() != null) {
            return true;
        }
        if (this.textMenu.bg != null && this.textMenu.bg.getCurrentValue() != null) {
            return true;
        }
        if (this.textMenu.en != null && this.textMenu.en.getCurrentValue() != null) {
            return true;
        }
        return this.textMenu.sd != null && this.textMenu.sd.getCurrentValue() != null;
    }

    public void setMessages(TextFilterMessages messages) {
        this.messages = messages;
        this.textMenu.setEmptyText(messages.emptyText());
    }

    protected Class<String> getType() {
        return String.class;
    }

    protected boolean validateModel(M model) {
        String v;
        String filterValue;
        boolean isValid = true;
        String modelValue = (String)this.getValueProvider().getValue(model);
        if (this.textMenu.ct != null) {
            filterValue = (String)this.textMenu.ct.getCurrentValue();
            String string = v = filterValue == null ? "" : filterValue.toString();
            if (v.length() == 0 && (modelValue == null || modelValue.length() == 0)) {
                isValid = true;
            } else if (modelValue == null) {
                isValid = false;
            } else {
                boolean bl = isValid = modelValue.toLowerCase().indexOf(v.toLowerCase()) > -1;
            }
        }
        if (this.textMenu.bg != null) {
            filterValue = (String)this.textMenu.bg.getCurrentValue();
            String string = v = filterValue == null ? "" : filterValue.toString();
            if (v.length() == 0 && (modelValue == null || modelValue.length() == 0)) {
                isValid = true;
            } else if (modelValue == null) {
                isValid = false;
            } else {
                boolean bl = isValid = modelValue.toLowerCase().indexOf(v.toLowerCase()) > -1;
            }
        }
        if (this.textMenu.en != null) {
            filterValue = (String)this.textMenu.en.getCurrentValue();
            String string = v = filterValue == null ? "" : filterValue.toString();
            if (v.length() == 0 && (modelValue == null || modelValue.length() == 0)) {
                isValid = true;
            } else if (modelValue == null) {
                isValid = false;
            } else {
                boolean bl = isValid = modelValue.toLowerCase().indexOf(v.toLowerCase()) > -1;
            }
        }
        if (this.textMenu.sd != null) {
            filterValue = (String)this.textMenu.sd.getCurrentValue();
            String string = v = filterValue == null ? "" : filterValue.toString();
            isValid = v.length() == 0 && (modelValue == null || modelValue.length() == 0) ? true : (modelValue == null ? false : modelValue.toLowerCase().indexOf(v.toLowerCase()) > -1);
        }
        return isValid;
    }

    public void setFilterConfig(List<FilterConfig> configs) {
        boolean hasValue = false;
        int i = 0;
        while (i < configs.size()) {
            FilterConfig config = configs.get(i);
            if (config.getValue() != null && !"".equals(config.getValue())) {
                hasValue = true;
            }
            ++i;
        }
        this.setValue(configs);
        this.setActive(hasValue, false);
    }

    protected void fireUpdate() {
        super.fireUpdate();
    }

    public class DefaultTextFilterMessages
    implements TextFilterMessages {
        @Override
        public String emptyText() {
            return DefaultMessages.getMessages().stringFilter_emptyText();
        }
    }

    public static interface TextFilterMessages {
        public String emptyText();
    }
}

