/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.filter.text;

import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.resources.CommonStyles;
import com.sencha.gxt.core.client.util.DelayedTask;
import com.sencha.gxt.data.shared.loader.FilterConfig;
import com.sencha.gxt.data.shared.loader.FilterConfigBean;
import com.sencha.gxt.widget.core.client.event.BeforeHideEvent;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.portlets.user.tdwx.client.filter.text.TextFilter;
import org.gcube.portlets.user.tdwx.client.resources.ResourceBundle;

public class TextMenu<M>
extends Menu {
    protected TextField ct;
    protected TextField bg;
    protected TextField en;
    protected TextField sd;
    private TextFilter<M> filter;
    private List<TextItem> textItems = new ArrayList<TextItem>();
    private DelayedTask updateTask = new DelayedTask(){

        public void onExecute() {
            TextMenu.this.fireUpdate();
        }
    };

    public TextMenu(TextFilter<M> filter) {
        this.filter = filter;
        this.addBeforeHideHandler(new BeforeHideEvent.BeforeHideHandler(){

            public void onBeforeHide(BeforeHideEvent event) {
                if (TextMenu.this.ct != null) {
                    TextMenu.this.ct.getElement().selectNode("input").blur();
                }
                if (TextMenu.this.bg != null) {
                    TextMenu.this.bg.getElement().selectNode("input").blur();
                }
                if (TextMenu.this.en != null) {
                    TextMenu.this.en.getElement().selectNode("input").blur();
                }
                if (TextMenu.this.sd != null) {
                    TextMenu.this.sd.getElement().selectNode("input").blur();
                }
            }
        });
    }

    public List<TextItem> getTextItems() {
        return Collections.unmodifiableList(this.textItems);
    }

    public List<FilterConfig> getValue() {
        FilterConfigBean config;
        ArrayList<FilterConfig> configs = new ArrayList<FilterConfig>();
        if (this.ct != null && this.ct.getCurrentValue() != null && this.ct.isCurrentValid()) {
            config = new FilterConfigBean();
            config.setType("string");
            config.setComparison("contains");
            config.setValue(((String)this.ct.getCurrentValue()).toString());
            configs.add((FilterConfig)config);
        }
        if (this.bg != null && this.bg.getCurrentValue() != null && this.bg.isCurrentValid()) {
            config = new FilterConfigBean();
            config.setType("string");
            config.setComparison("begins");
            config.setValue(((String)this.bg.getCurrentValue()).toString());
            configs.add((FilterConfig)config);
        }
        if (this.en != null && this.en.getCurrentValue() != null && this.en.isCurrentValid()) {
            config = new FilterConfigBean();
            config.setType("string");
            config.setComparison("ends");
            config.setValue(((String)this.en.getCurrentValue()).toString());
            configs.add((FilterConfig)config);
        }
        if (this.sd != null && this.sd.getCurrentValue() != null && this.sd.isCurrentValid()) {
            config = new FilterConfigBean();
            config.setType("string");
            config.setComparison("soundex");
            config.setValue(((String)this.sd.getCurrentValue()).toString());
            configs.add((FilterConfig)config);
        }
        return configs;
    }

    public void setEmptyText(String emptyText) {
        if (this.ct != null) {
            this.ct.setEmptyText(emptyText);
        }
        if (this.bg != null) {
            this.bg.setEmptyText(emptyText);
        }
        if (this.en != null) {
            this.en.setEmptyText(emptyText);
        }
        if (this.sd != null) {
            this.sd.setEmptyText(emptyText);
        }
    }

    public void setTextItems(List<TextItem> textItems) {
        this.textItems = textItems;
        this.clear();
        ImageResource icon = null;
        String toolTip = null;
        for (TextItem item : textItems) {
            TextField field = this.createTextField();
            field.setEmptyText(this.filter.getMessages().emptyText());
            switch (item) {
                case CONTAINS: {
                    icon = ResourceBundle.INSTANCE.textContains();
                    toolTip = new String("Text Contains");
                    this.ct = field;
                    break;
                }
                case BEGINS: {
                    icon = ResourceBundle.INSTANCE.textBegins();
                    toolTip = new String("Text Begins");
                    this.bg = field;
                    break;
                }
                case ENDS: {
                    icon = ResourceBundle.INSTANCE.textEnds();
                    toolTip = new String("Text Ends");
                    this.en = field;
                    break;
                }
                case SOUNDEX: {
                    icon = ResourceBundle.INSTANCE.textSoundex();
                    toolTip = new String("Soundex Algorithm");
                    this.sd = field;
                }
            }
            MenuItem menuItem = new MenuItem();
            menuItem.setCanActivate(false);
            menuItem.setHideOnClick(false);
            menuItem.setIcon(icon);
            menuItem.setWidget((Widget)field);
            menuItem.setToolTip(toolTip);
            menuItem.getElement().removeClassName(CommonStyles.get().unselectable());
            menuItem.getElement().getStyle().setCursor(Style.Cursor.DEFAULT);
            this.add((Widget)menuItem);
        }
    }

    public void setValue(List<FilterConfig> values) {
        for (FilterConfig config : values) {
            String c = config.getComparison();
            String v = config.getValue();
            if (v == null) {
                v = "";
            }
            if ("st".equals(c)) {
                this.ct.setValue((Object)v);
                continue;
            }
            if ("bg".equals(c)) {
                this.bg.setValue((Object)v);
                continue;
            }
            if ("en".equals(c)) {
                this.en.setValue((Object)v);
                continue;
            }
            if (!"sd".equals(c)) continue;
            this.sd.setValue((Object)v);
        }
        this.fireUpdate();
    }

    protected TextField createTextField() {
        TextField field = new TextField(){

            protected void onKeyUp(Event event) {
                super.onKeyUp(event);
                TextMenu.this.onFieldKeyUp(this, event);
            }
        };
        return field;
    }

    protected void onAttach() {
        super.onAttach();
        this.updateTask.delay(this.filter.getUpdateBuffer());
    }

    protected void onFieldKeyUp(TextField field, Event event) {
        int kc = event.getKeyCode();
        if (kc == 13 && field.isCurrentValid()) {
            event.preventDefault();
            event.stopPropagation();
            this.hide(true);
            return;
        }
        this.updateTask.delay(this.filter.getUpdateBuffer());
    }

    private void fireUpdate() {
        this.filter.fireUpdate();
    }

    public static enum TextItem {
        CONTAINS("ct"),
        BEGINS("bg"),
        ENDS("en"),
        SOUNDEX("sd");

        private final String key;

        private TextItem(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

