/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.model.grid;

import com.google.gwt.core.client.JsArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.portlets.user.tdwx.client.model.json.JSonValue;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnKey;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;
import org.gcube.portlets.user.tdwx.shared.model.ValueType;

public class JSonValueConverter {
    protected ColumnDefinition[] columns;

    public JSonValueConverter(List<ColumnDefinition> columns) {
        this.columns = columns.toArray(new ColumnDefinition[columns.size()]);
    }

    public List<DataRow> convertToDataRow(List<JSonValue> json) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>(json.size());
        for (JSonValue value : json) {
            rows.add(this.convertToDataRow(value));
        }
        return rows;
    }

    public List<DataRow> convertToDataRow(JsArray<JSonValue> json) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>(json.length());
        int i = 0;
        while (i < json.length()) {
            rows.add(this.convertToDataRow((JSonValue)json.get(i)));
            ++i;
        }
        return rows;
    }

    public DataRow convertToDataRow(JSonValue json) {
        DataRow row = new DataRow(this.columns.length);
        ColumnDefinition[] columnDefinitionArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition column = columnDefinitionArray[n2];
            this.setValue(row, json, column.getKey(), column.getValueType());
            ++n2;
        }
        return row;
    }

    protected void setValue(DataRow row, JSonValue json, ColumnKey key, ValueType type) {
        try {
            if (json.isNull(key.getJSonIndex())) {
                row.set(key, null);
            } else {
                switch (type) {
                    case BOOLEAN: {
                        row.set(key, json.getAsBool(key.getJSonIndex()));
                        break;
                    }
                    case DATE: {
                        row.set(key, new Date((long)json.getAsNumber(key.getJSonIndex())));
                        break;
                    }
                    case DOUBLE: {
                        row.set(key, json.getAsNumber(key.getJSonIndex()));
                        break;
                    }
                    case INTEGER: {
                        row.set(key, (int)json.getAsNumber(key.getJSonIndex()));
                        break;
                    }
                    case LONG: {
                        row.set(key, (long)json.getAsNumber(key.getJSonIndex()));
                        break;
                    }
                    case STRING: {
                        row.set(key, json.getAsString(key.getJSonIndex()));
                        break;
                    }
                    case GEOMETRY: {
                        row.set(key, json.getAsString(key.getJSonIndex()));
                        break;
                    }
                    default: {
                        row.set(key, null);
                        break;
                    }
                }
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            System.out.println("JSonIndex: " + key.getJSonIndex());
        }
    }
}

