/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.style;

import com.sencha.gxt.core.client.ValueProvider;
import java.util.ArrayList;
import org.gcube.portlets.user.tdwx.client.config.Row;
import org.gcube.portlets.user.tdwx.client.config.RowStyleProvider;
import org.gcube.portlets.user.tdwx.client.resources.ResourceBundle;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;

public class DefaultRowStyle
implements RowStyleProvider {
    protected ResourceBundle res;
    protected boolean errorNotColored;

    public DefaultRowStyle() {
        this.errorNotColored = false;
        this.res = ResourceBundle.INSTANCE;
        this.res.tdGridCSS().ensureInjected();
    }

    public DefaultRowStyle(boolean errorNotColored) {
        this.errorNotColored = errorNotColored;
        this.res = ResourceBundle.INSTANCE;
        this.res.tdGridCSS().ensureInjected();
    }

    @Override
    public String getRowStyle(Row row, ArrayList<ColumnDefinition> validationColumns) {
        String style = "";
        for (ColumnDefinition c : validationColumns) {
            String valid = row.getFieldAsText(c.getColumnLocalId());
            Boolean b = new Boolean(valid);
            if (b.booleanValue()) continue;
            if (this.errorNotColored) {
                style = this.res.tdGridCSS().getGridRowNoColor();
                break;
            }
            style = this.res.tdGridCSS().getGridRowRed();
            break;
        }
        return style;
    }

    @Override
    public String getColStyle(Row row, ArrayList<ColumnDefinition> validationColumns, ValueProvider<? super DataRow, ?> valueProvider, int rowIndex, int colIndex) {
        String style = "";
        for (ColumnDefinition c : validationColumns) {
            String valid = row.getFieldAsText(c.getColumnLocalId());
            Boolean b = new Boolean(valid);
            if (b.booleanValue()) continue;
            if (this.errorNotColored) {
                style = this.res.tdGridCSS().getGridRowNoColor();
                break;
            }
            style = this.res.tdGridCSS().getGridRowRed();
            break;
        }
        return style;
    }
}

