/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataTypeParameter
extends LeafParameter<DataType> {
    public List<DataType> allowedDataTypes;

    private DataTypeParameter() {
    }

    public DataTypeParameter(String identifier, String name, String description, Cardinality cardinality, List<DataType> allowedDataTypes) {
        super(identifier, name, description, cardinality);
        this.allowedDataTypes = allowedDataTypes;
    }

    public DataTypeParameter(String identifier, String name, String description, Cardinality cardinality) {
        super(identifier, name, description, cardinality);
        this.allowedDataTypes = new ArrayList<DataType>();
        this.allowedDataTypes.add((DataType)new BooleanType());
        this.allowedDataTypes.add((DataType)new DateType());
        this.allowedDataTypes.add((DataType)new IntegerType());
        this.allowedDataTypes.add((DataType)new NumericType());
        this.allowedDataTypes.add((DataType)new TextType());
        this.allowedDataTypes.add((DataType)new GeometryType());
    }

    public List<DataType> getAllowedDataTypes() {
        return this.allowedDataTypes;
    }

    @Override
    public Class<DataType> getParameterType() {
        return DataType.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowedDataTypes == null ? 0 : this.allowedDataTypes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypeParameter other = (DataTypeParameter)obj;
        return !(this.allowedDataTypes == null ? other.allowedDataTypes != null : !this.allowedDataTypes.equals(other.allowedDataTypes));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataTypeParameter [getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append(", getAllowedDataTypes()=");
        builder.append(this.getAllowedDataTypes());
        builder.append(", getParameterType()=");
        builder.append(this.getParameterType());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validateValue(Object value) throws Exception {
        super.validateValue(value);
        boolean ok = false;
        for (DataType allowed : this.getAllowedDataTypes()) {
            if (!value.getClass().equals(allowed.getClass())) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", value, this.getAllowedDataTypes()));
        }
    }
}

