/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataflowSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.datastructure.DataflowSuperBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.DataStructureSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.StructureBuilderImpl;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.SuperBeansBuilderImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemorySdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataflowSuperBeanBuilder
extends StructureBuilderImpl<DataflowSuperBean, DataflowBean> {
    private static final Logger LOG = Logger.getLogger(SuperBeansBuilderImpl.class);
    @Autowired
    private DataStructureSuperBeanBuilder dataStructureSuperBeanBuilder;

    public DataflowSuperBean build(DataflowBean buildFrom, SdmxBeanRetrievalManager retrievalManager, SuperBeans existingBeans) {
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        InMemorySdmxSuperBeanRetrievalManager superBeanRetrievalManager = new InMemorySdmxSuperBeanRetrievalManager(existingBeans);
        MaintainableRefBean dsdRef = buildFrom.getDataStructureRef().getMaintainableReference();
        LOG.debug((Object)("Build Dataflow SuperBean. Get DSD Superbean :" + dsdRef));
        DataStructureSuperBean kfSuperBean = superBeanRetrievalManager.getDataStructureSuperBean(dsdRef);
        if (kfSuperBean == null) {
            LOG.debug((Object)"No existing dsd super bean found, build new");
            DataStructureBean keyFamily = (DataStructureBean)retrievalManager.getMaintainableBean(DataStructureBean.class, dsdRef);
            if (keyFamily != null) {
                kfSuperBean = this.dataStructureSuperBeanBuilder.build(keyFamily, retrievalManager, existingBeans);
                existingBeans.addDataStructure(kfSuperBean);
            } else {
                throw new CrossReferenceException(buildFrom.getDataStructureRef());
            }
        }
        return new DataflowSuperBeanImpl(buildFrom, kfSuperBean);
    }
}

