/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.builder.SuperBeansBuilder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.CategorySchemeSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.CodelistSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ConceptSchemeSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.DataStructureSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.DataflowSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.HierarchicalCodelistSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ProcessSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ProvisionSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.RegistrationSuperBeanBuilder;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SuperBeansBuilderImpl
implements SuperBeansBuilder {
    private static final Logger LOG = Logger.getLogger(SuperBeansBuilderImpl.class);
    @Autowired
    private CategorySchemeSuperBeanBuilder categorySchemeSuperBeanBuilder;
    @Autowired
    private CodelistSuperBeanBuilder codelistSuperBeanBuilder;
    @Autowired
    private ConceptSchemeSuperBeanBuilder conceptSchemeSuperBeanBuilder;
    @Autowired
    private DataflowSuperBeanBuilder dataflowSuperBeanBuilder;
    @Autowired
    private DataStructureSuperBeanBuilder dataStructureSuperBeanBuilder;
    @Autowired
    private HierarchicalCodelistSuperBeanBuilder hierarchicalCodelistSuperBeanBuilder;
    @Autowired
    private ProvisionSuperBeanBuilder provisionSuperBeanBuilder;
    @Autowired
    private ProcessSuperBeanBuilder processSuperBeanBuilder;
    @Autowired
    private RegistrationSuperBeanBuilder registrationSuperBeanBuilder;

    public SuperBeans build(SdmxBeans buildFrom) throws SdmxException {
        return this.build(buildFrom, null, (SdmxBeanRetrievalManager)new InMemoryRetrievalManager(buildFrom));
    }

    public SuperBeans build(SdmxBeans buildFrom, SuperBeans existingBeans, SdmxBeanRetrievalManager retrievalManager) throws SdmxException {
        LOG.debug((Object)"Build Superbeans: Create LocalRetrievalManager");
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        for (CategorySchemeBean currentBean : buildFrom.getCategorySchemes()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addCategoryScheme(this.categorySchemeSuperBeanBuilder.build(currentBean));
        }
        for (CategorySchemeBean currentBean : buildFrom.getCodelists()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addCodelist(this.codelistSuperBeanBuilder.build((CodelistBean)currentBean));
        }
        for (CategorySchemeBean currentBean : buildFrom.getConceptSchemes()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addConceptScheme(this.conceptSchemeSuperBeanBuilder.build((ConceptSchemeBean)currentBean, retrievalManager, existingBeans));
        }
        for (CategorySchemeBean currentBean : buildFrom.getDataflows()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addDataflow(this.dataflowSuperBeanBuilder.build((DataflowBean)currentBean, retrievalManager, existingBeans));
        }
        for (CategorySchemeBean currentBean : buildFrom.getDataStructures()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addDataStructure(this.dataStructureSuperBeanBuilder.build((DataStructureBean)currentBean, retrievalManager, existingBeans));
        }
        for (CategorySchemeBean currentBean : buildFrom.getHierarchicalCodelists()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addHierarchicalCodelist(this.hierarchicalCodelistSuperBeanBuilder.build((HierarchicalCodelistBean)currentBean, retrievalManager));
        }
        for (CategorySchemeBean currentBean : buildFrom.getProvisionAgreements()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addProvision(this.provisionSuperBeanBuilder.build((ProvisionAgreementBean)currentBean, retrievalManager, existingBeans));
        }
        for (CategorySchemeBean currentBean : buildFrom.getProcesses()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addProcess(this.processSuperBeanBuilder.build((ProcessBean)currentBean, retrievalManager));
        }
        for (CategorySchemeBean currentBean : buildFrom.getRegistrations()) {
            LOG.debug((Object)("Build SuperBean: " + currentBean.getUrn()));
            existingBeans.addRegistration(this.registrationSuperBeanBuilder.build((RegistrationBean)currentBean, retrievalManager, existingBeans));
        }
        return existingBeans;
    }
}

