/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.REGISTRY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.xml.XmlUtil;

public abstract class AbstractResponseBuilder<T>
implements Builder<List<T>, ReadableDataLocation> {
    public List<T> build(ReadableDataLocation buildFrom) throws SdmxException {
        if (!XmlUtil.isXML((ReadableDataLocation)buildFrom)) {
            throw new SdmxSemmanticException(ExceptionCode.PARSE_ERROR_NOT_XML, new Object[]{new String(StreamUtil.toByteArray((InputStream)buildFrom.getInputStream()))});
        }
        SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion((ReadableDataLocation)buildFrom);
        XMLParser.validateXML((ReadableDataLocation)buildFrom, (SDMX_SCHEMA)schemaVersion, (ReadableDataLocation[])new ReadableDataLocation[0]);
        REGISTRY_MESSAGE_TYPE message = SdmxMessageUtil.getRegistryMessageType((ReadableDataLocation)buildFrom);
        if (message != this.getExpectedMessageType()) {
            String type = message.getType();
            throw new SdmxSemmanticException("Expected '" + this.getExpectedMessageType().getType() + "' message, got " + type);
        }
        switch (schemaVersion) {
            case VERSION_TWO_POINT_ONE: {
                RegistryInterfaceDocument rid;
                try {
                    try {
                        rid = RegistryInterfaceDocument.Factory.parse((InputStream)buildFrom.getInputStream());
                    }
                    catch (XmlException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    buildFrom.close();
                }
                return this.buildInternal(rid);
            }
        }
        throw new SdmxNotImplementedException(new Object[]{schemaVersion});
    }

    abstract List<T> buildInternal(RegistryInterfaceDocument var1);

    abstract REGISTRY_MESSAGE_TYPE getExpectedMessageType();
}

