/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryStructureResponseType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeListsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamiliesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureDefinitionsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ReportingTaxonomiesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetsType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.AbstractResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.V2Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CategorySchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CodelistXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ConceptSchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.DataStructureXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.DataflowXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.HierarchicalCodelistXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.MetadataStructureDefinitionXmlBeansBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.MetadataflowXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.OrganisationSchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ProcessXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ReportingTaxonomyXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureHeaderXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureSetXmlBeanBuilder;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryStructureResponseBuilderV2
extends AbstractResponseBuilder {
    @Autowired
    private StructureHeaderXmlBeanBuilder headerXmlBeansBuilder;
    @Autowired
    private CategorySchemeXmlBeanBuilder categorySchemeXmlBeanBuilder;
    @Autowired
    private CodelistXmlBeanBuilder codelistXmlBeanBuilder;
    @Autowired
    private ConceptSchemeXmlBeanBuilder conceptSchemeXmlBeanBuilder;
    @Autowired
    private DataflowXmlBeanBuilder dataflowXmlBeanBuilder;
    @Autowired
    private HierarchicalCodelistXmlBeanBuilder hierarchicalCodelistXmlBeanBuilder;
    @Autowired
    private DataStructureXmlBeanBuilder dataStructureXmlBeanBuilder;
    @Autowired
    private MetadataflowXmlBeanBuilder metadataflowXmlBeanBuilder;
    @Autowired
    private MetadataStructureDefinitionXmlBeansBuilder metadataStructureDefinitionXmlBeansBuilder;
    @Autowired
    private OrganisationSchemeXmlBeanBuilder organisationSchemeXmlBeanBuilder;
    @Autowired
    private ProcessXmlBeanBuilder processXmlBeanBuilder;
    @Autowired
    private ReportingTaxonomyXmlBeanBuilder reportingTaxonomyXmlBeanBuilder;
    @Autowired
    private StructureSetXmlBeanBuilder structureSetXmlBeanBuilder;

    public RegistryInterfaceDocument buildErrorResponse(Throwable th) throws SdmxException {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryStructureResponseType returnType = regInterface.addNewQueryStructureResponse();
        V2Helper.setHeader(regInterface);
        StatusMessageType statusMessage = returnType.addNewStatusMessage();
        statusMessage.setStatus(StatusType.FAILURE);
        TextType tt = statusMessage.addNewMessageText();
        if (th instanceof SdmxException) {
            tt.setStringValue(((SdmxException)th).getFullMessage());
        } else {
            tt.setStringValue(th.getMessage());
        }
        return responseType;
    }

    public RegistryInterfaceDocument buildSuccessResponse(SdmxBeans beans) throws SdmxException {
        return this.buildSuccessResponse(beans, null);
    }

    public RegistryInterfaceDocument buildSuccessResponse(SdmxBeans beans, String warningMessage) throws SdmxException {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryStructureResponseType returnType = regInterface.addNewQueryStructureResponse();
        HeaderType headerType = null;
        if (beans.getHeader() != null) {
            headerType = this.headerXmlBeansBuilder.build(beans.getHeader());
            regInterface.setHeader(headerType);
        } else {
            headerType = regInterface.addNewHeader();
            V2Helper.setHeader(headerType, beans);
        }
        StatusMessageType statusMessage = returnType.addNewStatusMessage();
        if (ObjectUtil.validString((String[])new String[]{warningMessage}) || !ObjectUtil.validCollection((Collection)beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]))) {
            statusMessage.setStatus(StatusType.WARNING);
            TextType tt = statusMessage.addNewMessageText();
            if (ObjectUtil.validString((String[])new String[]{warningMessage})) {
                tt.setStringValue(warningMessage);
            } else {
                tt.setStringValue("No Structures Match The Query Parameters");
            }
        } else {
            statusMessage.setStatus(StatusType.SUCCESS);
        }
        Set categorisations = beans.getCategorisations();
        if (beans.getCategorySchemes().size() > 0) {
            CategorySchemesType catSchemesType = returnType.addNewCategorySchemes();
            for (CategorySchemeBean cateogrySchemeBean : beans.getCategorySchemes()) {
                HashSet<CategorisationBean> matchingCategorisations = new HashSet<CategorisationBean>();
                for (CategorisationBean cat : categorisations) {
                    if (!MaintainableUtil.match((MaintainableBean)cateogrySchemeBean, (StructureReferenceBean)cat.getCategoryReference())) continue;
                    matchingCategorisations.add(cat);
                }
                catSchemesType.getCategorySchemeList().add(this.categorySchemeXmlBeanBuilder.build(cateogrySchemeBean, categorisations));
            }
        }
        if (beans.getCodelists().size() > 0) {
            CodeListsType codeListsType = returnType.addNewCodeLists();
            for (CodelistBean codelistBean : beans.getCodelists()) {
                codeListsType.getCodeListList().add(this.codelistXmlBeanBuilder.build(codelistBean));
            }
        }
        if (beans.getConceptSchemes().size() > 0) {
            ConceptsType conceptsType = returnType.addNewConcepts();
            for (ConceptSchemeBean conceptSchemeBean : beans.getConceptSchemes()) {
                conceptsType.getConceptSchemeList().add(this.conceptSchemeXmlBeanBuilder.build(conceptSchemeBean));
            }
        }
        if (beans.getDataflows().size() > 0) {
            DataflowsType dataflowsType = returnType.addNewDataflows();
            for (DataflowBean currentBean : beans.getDataflows()) {
                dataflowsType.getDataflowList().add(this.dataflowXmlBeanBuilder.build(currentBean, this.getCategorisations((MaintainableBean)currentBean, categorisations)));
            }
        }
        if (beans.getHierarchicalCodelists().size() > 0) {
            HierarchicalCodelistsType hierarchicalCodelistsType = returnType.addNewHierarchicalCodelists();
            for (DataflowBean currentBean : beans.getHierarchicalCodelists()) {
                hierarchicalCodelistsType.getHierarchicalCodelistList().add(this.hierarchicalCodelistXmlBeanBuilder.build((HierarchicalCodelistBean)currentBean));
            }
        }
        if (beans.getDataStructures().size() > 0) {
            KeyFamiliesType keyFamiliesType = returnType.addNewKeyFamilies();
            for (DataflowBean currentBean : beans.getDataStructures()) {
                keyFamiliesType.getKeyFamilyList().add(this.dataStructureXmlBeanBuilder.build((DataStructureBean)currentBean));
            }
        }
        if (beans.getMetadataflows().size() > 0) {
            MetadataflowsType metadataflowsType = returnType.addNewMetadataflows();
            for (DataflowBean currentBean : beans.getMetadataflows()) {
                metadataflowsType.getMetadataflowList().add(this.metadataflowXmlBeanBuilder.build((MetadataFlowBean)currentBean, this.getCategorisations((MaintainableBean)currentBean, categorisations)));
            }
        }
        if (beans.getMetadataStructures().size() > 0) {
            MetadataStructureDefinitionsType msdsType = returnType.addNewMetadataStructureDefinitions();
            for (DataflowBean currentBean : beans.getMetadataStructures()) {
                msdsType.getMetadataStructureDefinitionList().add(this.metadataStructureDefinitionXmlBeansBuilder.build((MetadataStructureDefinitionBean)currentBean));
            }
        }
        OrganisationSchemesType orgSchemesType = null;
        if (beans.getAgenciesSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (DataflowBean currentBean : beans.getAgenciesSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build((AgencySchemeBean)currentBean));
            }
        }
        if (beans.getDataConsumerSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (DataflowBean currentBean : beans.getDataConsumerSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build((DataConsumerSchemeBean)currentBean));
            }
        }
        if (beans.getDataProviderSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (DataflowBean currentBean : beans.getDataProviderSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build((DataProviderSchemeBean)currentBean));
            }
        }
        if (beans.getProcesses().size() > 0) {
            ProcessesType processesType = returnType.addNewProcesses();
            for (ProcessBean currentBean : beans.getProcesses()) {
                processesType.getProcessList().add(this.processXmlBeanBuilder.build(currentBean));
            }
        }
        if (beans.getStructureSets().size() > 0) {
            StructureSetsType structureSetsType = returnType.addNewStructureSets();
            for (ProcessBean currentBean : beans.getStructureSets()) {
                structureSetsType.getStructureSetList().add(this.structureSetXmlBeanBuilder.build((StructureSetBean)currentBean));
            }
        }
        if (beans.getReportingTaxonomys().size() > 0) {
            ReportingTaxonomiesType reportingTaxonomiesType = returnType.addNewReportingTaxonomies();
            for (ProcessBean currentBean : beans.getReportingTaxonomys()) {
                reportingTaxonomiesType.getReportingTaxonomyList().add(this.reportingTaxonomyXmlBeanBuilder.build((ReportingTaxonomyBean)currentBean));
            }
        }
        if (beans.getAttachmentConstraints().size() > 0) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Attachment Constraint at SMDX v2.0 - please use SDMX v2.1"});
        }
        if (beans.getContentConstraintBeans().size() > 0) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Content Constraint at SMDX v2.0 - please use SDMX v2.1"});
        }
        if (beans.getMetadataStructures().size() > 0) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Metadata Structure Definition at SMDX v2.0 - please use SDMX v2.1"});
        }
        return responseType;
    }

    private Set<CategorisationBean> getCategorisations(MaintainableBean maint, Set<CategorisationBean> categorisations) {
        HashSet<CategorisationBean> returnSet = new HashSet<CategorisationBean>();
        for (CategorisationBean cat : categorisations) {
            if (cat.getStructureReference().getTargetReference() != maint.getStructureType() || !MaintainableUtil.match((MaintainableBean)maint, (StructureReferenceBean)cat.getStructureReference())) continue;
            returnSet.add(cat);
        }
        return returnSet;
    }
}

