/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisioningStatusType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.SubmitProvisioningResponseType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.AbstractResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.V2Helper;
import org.sdmxsource.util.ObjectUtil;

public class SubmitProvisionResponseBuilderV2
extends AbstractResponseBuilder {
    public static SubmitProvisionResponseBuilderV2 INSTANCE = new SubmitProvisionResponseBuilderV2();

    private SubmitProvisionResponseBuilderV2() {
    }

    public RegistryInterfaceDocument buildErrorResponse(Throwable th) {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        SubmitProvisioningResponseType returnType = regInterface.addNewSubmitProvisioningResponse();
        V2Helper.setHeader(regInterface);
        ProvisioningStatusType statusType = returnType.addNewProvisioningStatus();
        StatusMessageType statusMessage = statusType.addNewStatusMessage();
        this.addStatus(statusMessage, th);
        return responseType;
    }

    public RegistryInterfaceDocument buildResponse(Collection<ProvisionAgreementBean> response) {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        SubmitProvisioningResponseType returnType = regInterface.addNewSubmitProvisioningResponse();
        V2Helper.setHeader(regInterface);
        for (ProvisionAgreementBean provisionAgreement : response) {
            this.processResponse(returnType, provisionAgreement);
        }
        return responseType;
    }

    private void processResponse(SubmitProvisioningResponseType returnType, ProvisionAgreementBean provisionAgreement) {
        MaintainableRefBean maintRef;
        ProvisioningStatusType statusType = returnType.addNewProvisioningStatus();
        StatusMessageType statusMessage = statusType.addNewStatusMessage();
        this.addStatus(statusMessage, null);
        ProvisionAgreementRefType provRefType = statusType.addNewProvisionAgreementRef();
        if (ObjectUtil.validString((String[])new String[]{provisionAgreement.getUrn()})) {
            provRefType.setURN(provisionAgreement.getUrn());
        }
        if (provisionAgreement.getDataproviderRef() != null) {
            CrossReferenceBean crossRef = provisionAgreement.getDataproviderRef();
            maintRef = crossRef.getMaintainableReference();
            if (ObjectUtil.validString((String[])new String[]{maintRef.getAgencyId()})) {
                provRefType.setOrganisationSchemeAgencyID(maintRef.getAgencyId());
            }
            if (ObjectUtil.validString((String[])new String[]{maintRef.getMaintainableId()})) {
                provRefType.setOrganisationSchemeID(maintRef.getMaintainableId());
            }
            if (crossRef.getChildReference() != null && ObjectUtil.validString((String[])new String[]{crossRef.getChildReference().getId()})) {
                provRefType.setDataProviderID(crossRef.getChildReference().getId());
            }
            if (ObjectUtil.validString((String[])new String[]{maintRef.getVersion()})) {
                provRefType.setDataProviderVersion(maintRef.getVersion());
            }
        }
        if (provisionAgreement.getStructureUseage() != null) {
            CrossReferenceBean structUseageCrossRef = provisionAgreement.getStructureUseage();
            maintRef = structUseageCrossRef.getMaintainableReference();
            if (structUseageCrossRef.getTargetReference() == SDMX_STRUCTURE_TYPE.DATAFLOW) {
                if (ObjectUtil.validString((String[])new String[]{maintRef.getAgencyId()})) {
                    provRefType.setDataflowAgencyID(maintRef.getAgencyId());
                }
                if (ObjectUtil.validString((String[])new String[]{maintRef.getMaintainableId()})) {
                    provRefType.setDataflowID(maintRef.getMaintainableId());
                }
                if (ObjectUtil.validString((String[])new String[]{maintRef.getVersion()})) {
                    provRefType.setDataflowVersion(maintRef.getVersion());
                }
            }
        }
    }
}

