/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21;

import java.util.Collection;
import org.apache.xmlbeans.XmlAnyURI;
import org.sdmx.resources.sdmxml.schemas.v21.common.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.DataSourceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.QueryableDataSourceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.StatusType;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.model.impl.ErrorReport;

public abstract class AbstractResponseBuilder {
    AbstractResponseBuilder() {
    }

    public void addStatus(org.sdmx.resources.sdmxml.schemas.v21.registry.StatusMessageType statusMessage, Throwable th) {
        if (th == null) {
            statusMessage.setStatus(StatusType.SUCCESS);
        } else {
            statusMessage.setStatus(StatusType.FAILURE);
            ErrorReport errorReport = ErrorReport.build((Throwable)th);
            if (ObjectUtil.validCollection((Collection)errorReport.getErrorMessage())) {
                StatusMessageType tt = statusMessage.addNewMessageText();
                for (String errors : errorReport.getErrorMessage()) {
                    TextType text = tt.addNewText();
                    text.setStringValue(errors);
                }
            }
        }
    }

    public void addDatasource(DataSourceBean datasourceBean, DataSourceType datasourceType) {
        if (datasourceBean.isSimpleDatasource()) {
            XmlAnyURI simpleDatasource = datasourceType.addNewSimpleDataSource();
            simpleDatasource.setStringValue(datasourceBean.getDataUrl().toString());
        } else {
            QueryableDataSourceType queryableDatasourceType = datasourceType.addNewQueryableDataSource();
            queryableDatasourceType.setDataURL(datasourceBean.getDataUrl().toString());
            queryableDatasourceType.setIsRESTDatasource(datasourceBean.isRESTDatasource());
            queryableDatasourceType.setIsWebServiceDatasource(datasourceBean.isWebServiceDatasource());
            if (datasourceBean.getWSDLUrl() != null) {
                queryableDatasourceType.setWSDLURL(datasourceBean.getWSDLUrl().toString());
            }
            if (datasourceBean.getWadlUrl() != null) {
                queryableDatasourceType.setWADLURL(datasourceBean.getWSDLUrl().toString());
            }
        }
    }

    boolean hasAnnotations(AnnotableBean annotable) {
        return ObjectUtil.validCollection((Collection)annotable.getAnnotations());
    }
}

