/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import org.sdmx.resources.sdmxml.schemas.v20.registry.DatasourceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryableDatasourceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.RegistrationType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.springframework.stereotype.Service;

@Service(value="RegistrationXmlBeanBuilderV2")
public class RegistrationXmlBeanBuilder
extends AbstractBuilder {
    public static RegistrationXmlBeanBuilder INSTANCE = new RegistrationXmlBeanBuilder();

    private RegistrationXmlBeanBuilder() {
    }

    public RegistrationType build(RegistrationBean buildFrom) throws SdmxException {
        RegistrationType builtObj = RegistrationType.Factory.newInstance();
        if (buildFrom.getLastUpdated() != null) {
            builtObj.setLastUpdated(buildFrom.getLastUpdated().getDateAsCalendar());
        }
        if (buildFrom.getValidFrom() != null) {
            builtObj.setValidFrom(buildFrom.getValidFrom().getDateAsCalendar());
        }
        if (buildFrom.getValidTo() != null) {
            builtObj.setValidTo(buildFrom.getValidTo().getDateAsCalendar());
        }
        if (buildFrom.getProvisionAgreementRef() != null) {
            CrossReferenceBean provRefBean = buildFrom.getProvisionAgreementRef();
            ProvisionAgreementRefType provRefType = builtObj.addNewProvisionAgreementRef();
            if (provRefBean.getTargetReference() == SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT && this.validString(provRefBean.getTargetUrn())) {
                provRefType.setURN(provRefBean.getTargetUrn());
            }
        }
        if (buildFrom.getDataSource() != null) {
            DataSourceBean datasourceBean = buildFrom.getDataSource();
            DatasourceType datasourceType = builtObj.addNewDatasource();
            if (datasourceBean.isSimpleDatasource()) {
                datasourceType.setSimpleDatasource(datasourceBean.getDataUrl().toString());
            } else {
                QueryableDatasourceType qdst = datasourceType.addNewQueryableDatasource();
                qdst.setIsRESTDatasource(datasourceBean.isRESTDatasource());
                qdst.setIsWebServiceDatasource(datasourceBean.isWebServiceDatasource());
                qdst.setDataUrl(datasourceBean.getDataUrl().toString());
            }
        }
        return builtObj;
    }
}

