/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComponentType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintContentTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataSetTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IdentifiableObjectTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IdentifiableType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.KeyDescriptorValuesTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MaintainableType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataAttributeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataStructureComponentsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportPeriodTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.TextFormatType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ConstraintContentTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.DataSetTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.IdentifiableTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.KeyDescriptorValuesTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataAttributeBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportPeriodTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportStructureBean;
import org.sdmxsource.sdmx.sdmxbeans.util.XmlBeansEnumUtil;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.DataTypeBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.ComponentAssembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.MaintainableBeanAssembler;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetadataStructureXmlBeanBuilder
extends MaintainableBeanAssembler
implements Builder<MetadataStructureType, MetadataStructureDefinitionBean> {
    @Autowired
    private ComponentAssembler componentAssembler;
    @Autowired
    private DataTypeBuilder dataTypeBuilder;

    public MetadataStructureType build(MetadataStructureDefinitionBean buildFrom) throws SdmxException {
        MetadataStructureType builtObj = MetadataStructureType.Factory.newInstance();
        super.assembleMaintainable((MaintainableType)builtObj, (MaintainableBean)buildFrom);
        if (ObjectUtil.validCollection((Collection)buildFrom.getMetadataTargets()) || ObjectUtil.validCollection((Collection)buildFrom.getReportStructures())) {
            MetadataStructureComponentsType msdComponentType = builtObj.addNewMetadataStructureComponents();
            if (buildFrom.getMetadataTargets() != null) {
                for (MetadataTargetBean currentMetadataTarget : buildFrom.getMetadataTargets()) {
                    this.assembleMetadataTargetType(msdComponentType.addNewMetadataTarget(), currentMetadataTarget);
                }
            }
            if (buildFrom.getReportStructures() != null) {
                for (ReportStructureBean currentBean : buildFrom.getReportStructures()) {
                    this.assembleReportStructure(msdComponentType.addNewReportStructure(), currentBean);
                }
            }
        }
        return builtObj;
    }

    private void assembleMetadataTargetType(MetadataTargetType type, MetadataTargetBean bean) {
        super.assembleIdentifiable((IdentifiableType)type, (IdentifiableBean)bean);
        if (bean.getDataSetTargetBean() != null) {
            this.assembleDataSetTarget(type.addNewDataSetTarget(), bean.getDataSetTargetBean());
        }
        if (bean.getKeyDescriptorValuesTargetBean() != null) {
            this.assembleKeyDescriptorValuesTarget(type.addNewKeyDescriptorValuesTarget(), bean.getKeyDescriptorValuesTargetBean());
        }
        if (bean.getReportPeriodTargetBean() != null) {
            this.assembleReportPeriodTarget(type.addNewReportPeriodTarget(), bean.getReportPeriodTargetBean());
        }
        if (bean.getConstraintContentTargetBean() != null) {
            this.assembleConstraintContentTarget(type.addNewConstraintContentTarget(), bean.getConstraintContentTargetBean());
        }
        if (bean.getIdentifiableTargetBean() != null) {
            for (IdentifiableTargetBean currentBean : bean.getIdentifiableTargetBean()) {
                this.assembleIdentifiableObjectTarget(type.addNewIdentifiableObjectTarget(), currentBean);
            }
        }
    }

    private void assembleConstraintContentTarget(ConstraintContentTargetType type, ConstraintContentTargetBean bean) {
        super.assembleIdentifiable((IdentifiableType)type, (IdentifiableBean)bean);
        type.addNewLocalRepresentation().addNewTextFormat().setTextType(DataType.ATTACHMENT_CONSTRAINT_REFERENCE);
    }

    private void assembleKeyDescriptorValuesTarget(KeyDescriptorValuesTargetType type, KeyDescriptorValuesTargetBean bean) {
        super.assembleIdentifiable((IdentifiableType)type, (IdentifiableBean)bean);
        type.addNewLocalRepresentation().addNewTextFormat().setTextType(DataType.KEY_VALUES);
    }

    private void assembleDataSetTarget(DataSetTargetType type, DataSetTargetBean bean) {
        super.assembleIdentifiable((IdentifiableType)type, (IdentifiableBean)bean);
        type.addNewLocalRepresentation().addNewTextFormat().setTextType(DataType.DATA_SET_REFERENCE);
    }

    private void assembleReportPeriodTarget(ReportPeriodTargetType type, ReportPeriodTargetBean bean) {
        super.assembleIdentifiable((IdentifiableType)type, (IdentifiableBean)bean);
        TextFormatType ttType = type.addNewLocalRepresentation().addNewTextFormat();
        if (bean.getTextType() != null) {
            ttType.setTextType(this.dataTypeBuilder.build(bean.getTextType()));
        }
        if (bean.getStartTime() != null) {
            ttType.setStartTime((Object)bean.getStartTime().getDateInSdmxFormat());
        }
        if (bean.getEndTime() != null) {
            ttType.setEndTime((Object)bean.getEndTime().getDateInSdmxFormat());
        }
    }

    private void assembleIdentifiableObjectTarget(IdentifiableObjectTargetType type, IdentifiableTargetBean bean) {
        this.componentAssembler.assembleComponent((ComponentType)type, (ComponentBean)bean);
        type.setObjectType(XmlBeansEnumUtil.build((SDMX_STRUCTURE_TYPE)bean.getReferencedStructureType()));
    }

    private void assembleReportStructure(ReportStructureType type, ReportStructureBean bean) {
        super.assembleIdentifiable((IdentifiableType)type, (IdentifiableBean)bean);
        if (bean.getMetadataAttributes() != null) {
            for (MetadataAttributeBean currentMa : bean.getMetadataAttributes()) {
                this.assembleMetadataAttributes(type.addNewMetadataAttribute(), currentMa);
            }
        }
        if (bean.getTargetMetadatas() != null) {
            for (String metadataTarget : bean.getTargetMetadatas()) {
                type.addNewMetadataTarget().addNewRef().setId(metadataTarget);
            }
        }
    }

    private void assembleMetadataAttributes(MetadataAttributeType type, MetadataAttributeBean bean) {
        this.componentAssembler.assembleComponent((ComponentType)type, (ComponentBean)bean);
        if (bean.getMinOccurs() != null) {
            type.setMinOccurs(new BigInteger(bean.getMinOccurs().toString()));
        }
        if (bean.getMaxOccurs() != null) {
            type.setMaxOccurs((Object)bean.getMaxOccurs());
        } else {
            type.setMaxOccurs((Object)"unbounded");
        }
        if (bean.getPresentational().isSet()) {
            type.setIsPresentational(bean.getPresentational().isTrue());
        }
        if (bean.getMetadataAttributes() != null) {
            this.assembleMetadataAttributes(type, bean.getMetadataAttributes());
        }
    }

    private void assembleMetadataAttributes(MetadataAttributeType metadaAttributeType, List<MetadataAttributeBean> metadataAttributes) {
        for (MetadataAttributeBean currentMa : metadataAttributes) {
            this.assembleMetadataAttributes(metadaAttributeType.addNewMetadataAttribute(), currentMa);
        }
    }
}

