/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.GDuration;
import org.sdmx.resources.sdmxml.schemas.v21.structure.TextFormatType;
import org.sdmxsource.sdmx.api.constants.TEXT_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.DataTypeBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TextFormatAssembler
implements Assembler<TextFormatType, TextFormatBean> {
    private Logger log = Logger.getLogger(TextFormatAssembler.class);
    @Autowired
    private DataTypeBuilder dataTypeBuilder;

    @Override
    public void assemble(TextFormatType assembleInto, TextFormatBean assembleFrom) throws SdmxException {
        TEXT_TYPE textType = assembleFrom.getTextType();
        if (textType != null) {
            try {
                assembleInto.setTextType(this.dataTypeBuilder.build(textType));
            }
            catch (Throwable throwable) {
                assembleInto.unsetTextType();
                this.log.warn((Object)("SDMX 2.1 - Unable to set TextType on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getSequence().isSet()) {
            try {
                assembleInto.setIsSequence(assembleFrom.getSequence().isTrue());
            }
            catch (Throwable throwable) {
                assembleInto.unsetIsSequence();
                this.log.warn((Object)("SDMX 2.1 - Unable to set IsSequence on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getMinLength() != null) {
            try {
                assembleInto.setMinLength(assembleFrom.getMinLength());
            }
            catch (Throwable throwable) {
                assembleInto.unsetMinLength();
                this.log.warn((Object)("SDMX 2.1 - Unable to set MinLength on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getMaxLength() != null) {
            try {
                assembleInto.setMaxLength(assembleFrom.getMaxLength());
            }
            catch (Throwable throwable) {
                assembleInto.unsetMaxLength();
                this.log.warn((Object)("SDMX 2.1 - Unable to set MaxLength on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getMinValue() != null) {
            try {
                assembleInto.setMinValue(assembleFrom.getMinValue());
            }
            catch (Throwable throwable) {
                assembleInto.unsetMinValue();
                this.log.warn((Object)("SDMX 2.1 - Unable to set MinValue on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getMaxValue() != null) {
            try {
                assembleInto.setMaxValue(assembleFrom.getMaxValue());
            }
            catch (Throwable throwable) {
                assembleInto.unsetMaxValue();
                this.log.warn((Object)("SDMX 2.1 - Unable to set MaxValue on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getStartValue() != null) {
            try {
                assembleInto.setStartValue(assembleFrom.getStartValue());
            }
            catch (Throwable throwable) {
                assembleInto.unsetStartValue();
                this.log.warn((Object)("SDMX 2.1 - Unable to set StartValue on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getEndValue() != null) {
            try {
                assembleInto.setEndValue(assembleFrom.getEndValue());
            }
            catch (Throwable throwable) {
                assembleInto.unsetEndValue();
                this.log.warn((Object)("SDMX 2.1 - Unable to set EndValue on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getInterval() != null) {
            try {
                assembleInto.setInterval(assembleFrom.getInterval());
            }
            catch (Throwable throwable) {
                assembleInto.unsetInterval();
                this.log.warn((Object)("SDMX 2.1 - Unable to set Interval on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getTimeInterval() != null) {
            try {
                assembleInto.setTimeInterval(new GDuration((CharSequence)assembleFrom.getTimeInterval()));
            }
            catch (Throwable throwable) {
                assembleInto.unsetTimeInterval();
                this.log.warn((Object)("SDMX 2.1 - Unable to set TimeInterval on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getDecimals() != null) {
            try {
                assembleInto.setDecimals(assembleFrom.getDecimals());
            }
            catch (Throwable throwable) {
                assembleInto.unsetDecimals();
                this.log.warn((Object)("SDMX 2.1 - Unable to set Decimals on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getPattern() != null) {
            try {
                assembleInto.setPattern(assembleFrom.getPattern());
            }
            catch (Throwable throwable) {
                assembleInto.unsetPattern();
                this.log.warn((Object)("SDMX 2.1 - Unable to set Pattern on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getStartTime() != null) {
            try {
                assembleInto.setStartTime((Object)assembleFrom.getStartTime().getDateInSdmxFormat());
            }
            catch (Throwable throwable) {
                assembleInto.unsetStartTime();
                this.log.warn((Object)("SDMX 2.1 - Unable to set StartTime on " + assembleFrom.getParent().toString()));
            }
        }
        if (assembleFrom.getEndTime() != null) {
            // empty if block
        }
    }
}

