/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.response;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.ReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.registry.StatusType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubmissionResultType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.ErrorList;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.submissionresponse.SubmitStructureResponse;
import org.sdmxsource.sdmx.sdmxbeans.model.ErrorListImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.submissionresponse.SubmitStructureResponseImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.springframework.stereotype.Service;

@Service
public class SubmitStructureResponseBuilder_V21 {
    public List<SubmitStructureResponse> build(RegistryInterfaceDocument rid) throws SdmxException {
        ArrayList<SubmitStructureResponse> returnList = new ArrayList<SubmitStructureResponse>();
        for (SubmissionResultType rsType : rid.getRegistryInterface().getSubmitStructureResponse().getSubmissionResultList()) {
            StructureReferenceBean sRef = RefUtil.createReference((ReferenceType)rsType.getSubmittedStructure().getMaintainableObject());
            if (rsType.getStatusMessage() == null || rsType.getStatusMessage().getStatus() == null) continue;
            ArrayList<String> messages = new ArrayList<String>();
            if (rsType.getStatusMessage().getMessageTextList() != null) {
                for (StatusMessageType smt : rsType.getStatusMessage().getMessageTextList()) {
                    if (smt.getTextList() == null) continue;
                    for (TextType tt : smt.getTextList()) {
                        messages.add(tt.getStringValue());
                    }
                }
            }
            ErrorListImpl errors = null;
            if (rsType.getStatusMessage().getStatus().intValue() == StatusType.FAILURE.intValue()) {
                errors = new ErrorListImpl(messages, false);
            } else if (rsType.getStatusMessage().getStatus().intValue() == StatusType.WARNING.intValue()) {
                errors = new ErrorListImpl(messages, true);
            }
            returnList.add((SubmitStructureResponse)new SubmitStructureResponseImpl(sRef, (ErrorList)errors));
        }
        return returnList;
    }
}

