/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ProvisionAgreementBeanImpl;
import org.sdmxsource.sdmx.structureparser.manager.parsing.ProvisionParsingManager;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class ProvisionParsingManagerImpl
implements ProvisionParsingManager {
    @Override
    public List<ProvisionAgreementBean> parseXML(ReadableDataLocation dataLocation) {
        SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion((ReadableDataLocation)dataLocation);
        XMLParser.validateXML((ReadableDataLocation)dataLocation, (SDMX_SCHEMA)schemaVersion, (ReadableDataLocation[])new ReadableDataLocation[0]);
        InputStream stream = dataLocation.getInputStream();
        try {
            ArrayList<ProvisionAgreementBean> returnList = new ArrayList<ProvisionAgreementBean>();
            switch (schemaVersion) {
                case VERSION_TWO: {
                    RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.parse((InputStream)stream);
                    if (rid.getRegistryInterface().getQueryProvisioningResponse() != null && rid.getRegistryInterface().getQueryProvisioningResponse().getProvisionAgreementList() != null) {
                        for (ProvisionAgreementType provType : rid.getRegistryInterface().getQueryProvisioningResponse().getProvisionAgreementList()) {
                            returnList.add((ProvisionAgreementBean)new ProvisionAgreementBeanImpl(provType));
                        }
                        if (ObjectUtil.validCollection((Collection)rid.getRegistryInterface().getQueryProvisioningResponse().getDataflowRefList())) {
                            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Provision for Dataflow"});
                        }
                        if (ObjectUtil.validCollection((Collection)rid.getRegistryInterface().getQueryProvisioningResponse().getMetadataflowRefList())) {
                            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Provision for Metadataflow"});
                        }
                        if (ObjectUtil.validCollection((Collection)rid.getRegistryInterface().getQueryProvisioningResponse().getDataProviderRefList())) {
                            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Provision for Dataprovider"});
                        }
                    }
                    if (rid.getRegistryInterface().getSubmitProvisioningRequest() == null || rid.getRegistryInterface().getSubmitProvisioningRequest().getProvisionAgreementList() == null) break;
                    for (ProvisionAgreementType provType : rid.getRegistryInterface().getSubmitProvisioningRequest().getProvisionAgreementList()) {
                        returnList.add((ProvisionAgreementBean)new ProvisionAgreementBeanImpl(provType));
                    }
                    if (ObjectUtil.validCollection((Collection)rid.getRegistryInterface().getSubmitProvisioningRequest().getDataflowRefList())) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Submit Provision for Dataflow"});
                    }
                    if (ObjectUtil.validCollection((Collection)rid.getRegistryInterface().getSubmitProvisioningRequest().getMetadatataflowRefList())) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Submit Provision for Metadataflow"});
                    }
                    if (!ObjectUtil.validCollection((Collection)rid.getRegistryInterface().getSubmitProvisioningRequest().getDataProviderRefList())) break;
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Submit Provision for Dataprovider"});
                }
                default: {
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
                }
            }
            ArrayList<ProvisionAgreementBean> arrayList = returnList;
            return arrayList;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

