/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.factory.StructureParserFactory;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.ResolutionSettings;
import org.sdmxsource.sdmx.api.model.StructureWorkspace;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.structureparser.manager.ExternalReferenceManager;
import org.sdmxsource.sdmx.structureparser.workspace.impl.StructureWorkspaceImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class StructureParsingManagerImpl
implements StructureParsingManager,
ApplicationContextAware {
    private Logger LOG = Logger.getLogger(StructureParsingManagerImpl.class);
    @Autowired
    private ExternalReferenceManager externalReferenceManager;
    private ApplicationContext applicationContext;

    public StructureWorkspace parseStructures(ReadableDataLocation dataLocation) throws SdmxException, CrossReferenceException {
        ResolutionSettings settings = new ResolutionSettings(ResolutionSettings.RESOLVE_EXTERNAL_SETTING.DO_NOT_RESOLVE, ResolutionSettings.RESOLVE_CROSS_REFERENCES.DO_NOT_RESOLVE);
        return this.parseStructures(dataLocation, settings, null);
    }

    public StructureWorkspace parseStructures(ReadableDataLocation dataLocation, ResolutionSettings settings, SdmxBeanRetrievalManager retrievalManager) {
        this.LOG.info((Object)("Parse structures, resolution settings: " + settings + ", retrieval manager=" + retrievalManager));
        return this.buildWorkspace(this.getSdmxBeans(dataLocation), settings, retrievalManager);
    }

    public StructureWorkspace buildWorkspace(SdmxBeans beans, ResolutionSettings settings, SdmxBeanRetrievalManager retrievalManager) {
        if (settings.isResolveExternalReferences()) {
            this.externalReferenceManager.resolveExternalReferences(beans, settings.isSubstituteExternal(), settings.isLenient());
        }
        return new StructureWorkspaceImpl(beans, retrievalManager, settings.isResolveCrossReferences(), settings.isResolveAgencyReferences(), settings.getResolutionDepth());
    }

    private SdmxBeans getSdmxBeans(ReadableDataLocation sourceData) {
        for (StructureParserFactory currentFactory : this.getStructureParserFactory()) {
            SdmxBeans beans = currentFactory.getSdmxBeans(sourceData);
            if (beans == null) continue;
            return beans;
        }
        throw new SdmxNotImplementedException("Can not parse structures.  Structure format is either not supported, or has an invalid syntax");
    }

    private Collection<StructureParserFactory> getStructureParserFactory() throws IllegalArgumentException {
        return this.applicationContext.getBeansOfType(StructureParserFactory.class).values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

