/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.ExceptionHandler;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.dataparser.engine.DataValidationEngine;
import org.sdmxsource.util.ObjectUtil;

public abstract class AbstractDataValidationEngine
implements DataValidationEngine {
    private DataReaderEngine dataReaderEngine;
    private DataStructureBean dsd;
    protected Map<String, AttributeBean> seriesAttributes = new HashMap<String, AttributeBean>();
    protected Map<String, AttributeBean> obsAttributes = new HashMap<String, AttributeBean>();
    protected Map<String, DimensionBean> dimensionMap = new HashMap<String, DimensionBean>();
    int dimSize = 0;
    protected boolean isTimeSeries;
    protected String dimensionAtObservation;

    public AbstractDataValidationEngine(DataReaderEngine dataReaderEngine) {
        if (dataReaderEngine == null) {
            throw new IllegalArgumentException("AbstractDataValidationEngine can not be constructucted: DataReaderEngine can not be null");
        }
        this.dataReaderEngine = dataReaderEngine;
    }

    @Override
    public void validateData(ExceptionHandler exceptionHandler) {
        this.dataReaderEngine.reset();
        try {
            while (this.dataReaderEngine.moveNextDataset()) {
                this.processDataset(this.dataReaderEngine);
                while (this.moveNextKeyable(this.dataReaderEngine, exceptionHandler)) {
                    Keyable key = null;
                    try {
                        key = this.dataReaderEngine.getCurrentKey();
                    }
                    catch (SdmxException e) {
                        exceptionHandler.handleException((Throwable)e);
                    }
                    if (key == null) continue;
                    if (key.isSeries()) {
                        try {
                            this.validateSeriesKey(key);
                        }
                        catch (SdmxException e) {
                            exceptionHandler.handleException((Throwable)e);
                        }
                    } else {
                        GroupBean group = this.dsd.getGroup(key.getGroupName());
                        if (group == null) {
                            exceptionHandler.handleException((Throwable)new SdmxSemmanticException("Data Structure Definition does not contain group: " + key.getGroupName()));
                        }
                        for (KeyValue kv : key.getKey()) {
                            if (group.getDimensionRefs().contains(kv.getConcept())) continue;
                            exceptionHandler.handleException((Throwable)new SdmxSemmanticException("DSD group key component not found : " + kv.getConcept()));
                        }
                    }
                    while (this.moveNextObservation(this.dataReaderEngine, exceptionHandler)) {
                        try {
                            Observation obs = this.dataReaderEngine.getCurrentObservation();
                            this.validateObservation(obs);
                        }
                        catch (SdmxException e) {
                            exceptionHandler.handleException((Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Throwable th) {
            exceptionHandler.handleException(th);
        }
    }

    private boolean moveNextKeyable(DataReaderEngine dre, ExceptionHandler exceptionHandler) {
        boolean hasNext = false;
        try {
            hasNext = dre.moveNextKeyable();
        }
        catch (SdmxException e) {
            exceptionHandler.handleException((Throwable)e);
        }
        return hasNext;
    }

    private boolean moveNextObservation(DataReaderEngine dre, ExceptionHandler exceptionHandler) {
        boolean hasNext = false;
        try {
            hasNext = dre.moveNextObservation();
        }
        catch (SdmxException e) {
            exceptionHandler.handleException((Throwable)e);
        }
        return hasNext;
    }

    protected void processDataset(DataReaderEngine dre) {
        this.setDsd(dre.getDataStructure());
        this.dimSize = 0;
        for (DimensionBean dimension : this.dsd.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
            this.dimensionMap.put(dimension.getId(), dimension);
            ++this.dimSize;
        }
        this.isTimeSeries = this.dataReaderEngine.getCurrentDatasetHeaderBean().isTimeSeries();
        this.dimensionAtObservation = "TIME_PERIOD";
        if (this.dataReaderEngine.getCurrentDatasetHeaderBean().getDataStructureReference() != null) {
            this.dimensionAtObservation = this.dataReaderEngine.getCurrentDatasetHeaderBean().getDataStructureReference().getDimensionAtObservation();
        }
        for (AttributeBean att : this.dsd.getDimensionGroupAttributes()) {
            if (!this.isTimeSeries && att.getDimensionReferences().contains(this.dimensionAtObservation)) {
                this.obsAttributes.put(att.getId(), att);
                continue;
            }
            this.seriesAttributes.put(att.getId(), att);
        }
        for (AttributeBean att : this.dsd.getObservationAttributes()) {
            this.obsAttributes.put(att.getId(), att);
        }
        if (!this.isTimeSeries && !this.dimensionAtObservation.equals("AllDimensions")) {
            --this.dimSize;
        }
    }

    protected void setDsd(DataStructureBean dsd) {
        this.dsd = dsd;
    }

    protected abstract void validateSeriesKey(Keyable var1);

    protected void validateObservation(Observation obs) {
        if (this.isTimeSeries && !ObjectUtil.validString((String[])new String[]{obs.getObsTime()})) {
            throw new SdmxSemmanticException("Observation missing time dimension for time series data");
        }
    }
}

