/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.dataparser.engine.ReportedDateEngine;
import org.springframework.stereotype.Service;

@Service
public class ReportedDateEngineImpl
implements ReportedDateEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TIME_FORMAT, List<String>> getAllReportedDates(DataReaderEngine dataReaderEngine) {
        dataReaderEngine.reset();
        HashSet<String> processedDates = new HashSet<String>();
        HashMap timeFormatToSortedMap = new HashMap();
        try {
            while (dataReaderEngine.moveNextKeyable()) {
                while (dataReaderEngine.moveNextObservation()) {
                    Map<Date, String> sortedMap;
                    Observation obs = dataReaderEngine.getCurrentObservation();
                    String obsTime = obs.getObsTime();
                    if (processedDates.contains(obsTime)) continue;
                    TIME_FORMAT obsTimeFormat = obs.getObsTimeFormat();
                    if (timeFormatToSortedMap.containsKey(obsTimeFormat)) {
                        sortedMap = (Map)timeFormatToSortedMap.get(obsTimeFormat);
                    } else {
                        sortedMap = new TreeMap();
                        timeFormatToSortedMap.put(obsTimeFormat, sortedMap);
                    }
                    sortedMap.put(obs.getObsAsTimeDate(), obsTime);
                    processedDates.add(obsTime);
                }
            }
            HashMap<TIME_FORMAT, List<String>> responseMap = new HashMap<TIME_FORMAT, List<String>>();
            for (TIME_FORMAT currentTimeFormat : timeFormatToSortedMap.keySet()) {
                ArrayList sortedDateList = new ArrayList();
                responseMap.put(currentTimeFormat, sortedDateList);
                Map sortedMap = (Map)timeFormatToSortedMap.get(currentTimeFormat);
                for (Date sortedMapKey : sortedMap.keySet()) {
                    sortedDateList.add(sortedMap.get(sortedMapKey));
                }
            }
            HashMap<TIME_FORMAT, List<String>> hashMap = responseMap;
            return hashMap;
        }
        finally {
            dataReaderEngine.reset();
        }
    }
}

