/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.reader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.DATASET_POSITION;
import org.sdmxsource.sdmx.api.constants.DIMENSION_AT_OBSERVATION;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.ContactBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.engine.reader.AbstractDataReaderEngine;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ContactBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.PartyBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.util.ObjectUtil;

public abstract class AbstractSdmxDataReaderEngine
extends AbstractDataReaderEngine {
    private static final long serialVersionUID = 2653866522651246489L;
    protected static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    private static final Logger LOG = Logger.getLogger(AbstractSdmxDataReaderEngine.class);
    protected transient XMLStreamReader parser;
    private transient InputStream parserInputStream;
    protected transient XMLStreamReader runAheadParser;
    private transient InputStream runAheadParserInputStream;
    protected boolean isTwoPointOne;
    protected String groupId;
    protected boolean noSeries;
    private Observation flatObs;
    private Map<String, String> conceptToComponentId = new HashMap<String, String>();
    private LAST_CALL lastCall;

    public AbstractSdmxDataReaderEngine(ReadableDataLocation dataLocation, SdmxBeanRetrievalManager beanRetrieval, DataStructureBean defaultDsd, DataflowBean dataflowBean) {
        super(dataLocation, beanRetrieval, defaultDsd, dataflowBean);
        this.isTwoPointOne = SdmxMessageUtil.getSchemaVersion((ReadableDataLocation)dataLocation) == SDMX_SCHEMA.VERSION_TWO_POINT_ONE;
    }

    @Override
    protected void setCurrentDsd(DataStructureBean currentDsd) {
        super.setCurrentDsd(currentDsd);
        for (ComponentBean component : currentDsd.getComponents()) {
            this.conceptToComponentId.put(component.getConceptRef().getFullId(), component.getId());
        }
    }

    protected String getComponentId(String componentId) {
        if (this.isTwoPointOne) {
            return componentId;
        }
        if (this.conceptToComponentId.containsKey(componentId)) {
            return this.conceptToComponentId.get(componentId);
        }
        return componentId;
    }

    @Override
    public void reset() {
        super.reset();
        this.closeStreams();
        this.lastCall = null;
        this.groupId = null;
        this.flatObs = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.parserInputStream = this.dataLocation.getInputStream();
            this.parser = factory.createXMLStreamReader(this.parserInputStream, "UTF-8");
            this.runAheadParserInputStream = this.dataLocation.getInputStream();
            this.runAheadParser = factory.createXMLStreamReader(this.runAheadParserInputStream, "UTF-8");
            this.headerBean = this.processHeader();
        }
        catch (XMLStreamException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    @Override
    public HeaderBean getHeader() {
        return this.headerBean;
    }

    private HeaderBean processHeader() throws XMLStreamException {
        HashMap additionalAttributes = new HashMap();
        StructureReferenceBean dataProviderReference = null;
        ArrayList<Object> structure = new ArrayList<Object>();
        DATASET_ACTION datasetAction = null;
        String id = null;
        String datasetId = null;
        Date embargoDate = null;
        Date extracted = null;
        Date prepared = null;
        Date reportingBegin = null;
        Date reportingEnd = null;
        ArrayList<TextTypeWrapper> name = new ArrayList<TextTypeWrapper>();
        ArrayList<TextTypeWrapper> source = new ArrayList<TextTypeWrapper>();
        ArrayList<PartyBean> receiver = new ArrayList<PartyBean>();
        PartyBean sender = null;
        boolean test = false;
        String dsdId = null;
        String dsdAgency = null;
        while (this.parser.hasNext()) {
            String nodeName;
            int event = this.parser.next();
            if (event == 1) {
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("ID")) {
                    id = this.parser.getElementText();
                    continue;
                }
                if (nodeName.equals("Test")) {
                    test = Boolean.valueOf(this.parser.getElementText());
                    continue;
                }
                if (nodeName.equals("Prepared")) {
                    prepared = DateUtil.formatDate((Object)this.parser.getElementText(), (boolean)true);
                    continue;
                }
                if (nodeName.equals("Sender")) {
                    sender = this.processParty(nodeName);
                    continue;
                }
                if (nodeName.equals("Receiver")) {
                    receiver.add(this.processParty(nodeName));
                    continue;
                }
                if (nodeName.equals("Name")) {
                    this.addItemToLangMap(name);
                    continue;
                }
                if (nodeName.equals("Structure")) {
                    structure.add(this.processStructure());
                    continue;
                }
                if (nodeName.equals("DataProvider")) {
                    dataProviderReference = this.parseStructureReference(nodeName, SDMX_STRUCTURE_TYPE.DATA_PROVIDER);
                    continue;
                }
                if (nodeName.equals("DataSetAction")) {
                    datasetAction = DATASET_ACTION.getAction((String)this.parser.getElementText());
                    continue;
                }
                if (nodeName.equals("DataSetID")) {
                    datasetId = this.parser.getElementText();
                    continue;
                }
                if (nodeName.equals("Extracted")) {
                    extracted = DateUtil.formatDate((Object)this.parser.getElementText(), (boolean)true);
                    continue;
                }
                if (nodeName.equals("ReportingBegin")) {
                    reportingBegin = DateUtil.formatDate((Object)this.parser.getElementText(), (boolean)true);
                    continue;
                }
                if (nodeName.equals("ReportingEnd")) {
                    reportingEnd = DateUtil.formatDate((Object)this.parser.getElementText(), (boolean)true);
                    continue;
                }
                if (nodeName.equals("EmbargoDate")) {
                    embargoDate = DateUtil.formatDate((Object)this.parser.getElementText(), (boolean)true);
                    continue;
                }
                if (nodeName.equals("Source")) {
                    this.addItemToLangMap(source);
                    continue;
                }
                if (nodeName.equals("KeyFamilyAgency")) {
                    dsdAgency = this.parser.getElementText();
                    continue;
                }
                if (!nodeName.equals("KeyFamilyRef")) continue;
                dsdId = this.parser.getElementText();
                continue;
            }
            if (event != 2 || !(nodeName = this.parser.getLocalName()).equals("Header")) continue;
            if (dsdId != null) {
                if (this.defaultDsd != null && dsdId.equals(this.defaultDsd.getId())) {
                    structure.add(new DatasetStructureReferenceBeanImpl(this.defaultDsd.asReference()));
                } else {
                    structure.add(new DatasetStructureReferenceBeanImpl((StructureReferenceBean)new StructureReferenceBeanImpl(dsdAgency, dsdId, "1.0", SDMX_STRUCTURE_TYPE.DSD, new String[0])));
                }
            }
            return new HeaderBeanImpl(additionalAttributes, structure, dataProviderReference, datasetAction, id, datasetId, embargoDate, extracted, prepared, reportingBegin, reportingEnd, name, source, receiver, sender, test);
        }
        throw new IllegalArgumentException("Dataset does not contain a header");
    }

    private void addItemToLangMap(List<TextTypeWrapper> tts) throws XMLStreamException {
        String lang = "en";
        try {
            lang = this.parser.getAttributeValue(XML_NS, "lang");
        }
        catch (Throwable th) {
            // empty catch block
        }
        String value = this.parser.getElementText();
        tts.add((TextTypeWrapper)new TextTypeWrapperImpl(lang, value, null));
    }

    private DatasetStructureReferenceBean processStructure() throws XMLStreamException {
        String id = null;
        StructureReferenceBean structureReference = null;
        String serviceURL = null;
        String structureURL = null;
        String dimensionAtObservation = null;
        id = this.parser.getAttributeValue(null, "structureID");
        serviceURL = this.parser.getAttributeValue(null, "serviceURL");
        structureURL = this.parser.getAttributeValue(null, "structureURL");
        dimensionAtObservation = this.parser.getAttributeValue(null, "dimensionAtObservation");
        while (this.parser.hasNext()) {
            String nodeName;
            int event = this.parser.next();
            if (event == 1) {
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("ProvisionAgreement")) {
                    structureReference = this.parseStructureReference(nodeName, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT);
                    continue;
                }
                if (nodeName.equals("StructureUsage")) {
                    structureReference = this.parseStructureReference(nodeName, SDMX_STRUCTURE_TYPE.DATAFLOW);
                    continue;
                }
                if (!nodeName.equals("Structure")) continue;
                structureReference = this.parseStructureReference(nodeName, SDMX_STRUCTURE_TYPE.DSD);
                continue;
            }
            if (event != 2 || !(nodeName = this.parser.getLocalName()).equals("Structure")) continue;
            break;
        }
        if (structureReference == null) {
            throw new RuntimeException("Dataset Header.Structure expected to have one of the following nodes present (ProvisionAgreement|StructureUsage|Structure) to reference either a provision agreement, dataflow, or data structure definition");
        }
        if (dimensionAtObservation.equals(DIMENSION_AT_OBSERVATION.ALL.getVal())) {
            this.noSeries = true;
        }
        return new DatasetStructureReferenceBeanImpl(id, structureReference, serviceURL, structureURL, dimensionAtObservation);
    }

    private StructureReferenceBean parseStructureReference(String parseNodeName, SDMX_STRUCTURE_TYPE structureType) throws XMLStreamException {
        while (this.parser.hasNext()) {
            String nodeName;
            int event = this.parser.next();
            if (event == 1) {
                String urn;
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("Ref")) {
                    String agencyId = this.parser.getAttributeValue(null, "agencyID");
                    String id = this.parser.getAttributeValue(null, "id");
                    String maintainableId = this.parser.getAttributeValue(null, "maintainableParentId");
                    String version = this.parser.getAttributeValue(null, "version");
                    if (!ObjectUtil.validString((String[])new String[]{agencyId})) {
                        throw new RuntimeException("Dataset structure reference incomplete, missing agencyId");
                    }
                    if (!ObjectUtil.validString((String[])new String[]{id})) {
                        throw new RuntimeException("Dataset structure reference incomplete, missing id");
                    }
                    if (!structureType.isMaintainable()) {
                        if (!ObjectUtil.validString((String[])new String[]{maintainableId})) {
                            throw new RuntimeException("Dataset structure reference incomplete, missing maintainableParentId");
                        }
                        return new StructureReferenceBeanImpl(agencyId, maintainableId, version, structureType, new String[]{id});
                    }
                    return new StructureReferenceBeanImpl(agencyId, id, version, structureType, new String[0]);
                }
                if (!nodeName.equals("URN") || !ObjectUtil.validString((String[])new String[]{urn = this.parser.getElementText()})) continue;
                StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(this.parser.getElementText());
                if (sRef.getTargetReference() != structureType) {
                    throw new RuntimeException("Dataset Structure reference invalid '" + urn + "' , expecting a reference to '" + structureType.getType() + "' but got '" + sRef.getTargetReference().getType() + "'");
                }
                return sRef;
            }
            if (event != 2 || !(nodeName = this.parser.getLocalName()).equals(parseNodeName)) continue;
            break;
        }
        throw new RuntimeException("Dataset structure reference invalid, could not process reference, no Ref node or URN node found");
    }

    private PartyBean processParty(String partyNodeName) throws XMLStreamException {
        String id = this.parser.getAttributeValue(null, "id");
        String timeZone = null;
        ArrayList<TextTypeWrapper> nameMap = new ArrayList<TextTypeWrapper>();
        ArrayList<ContactBean> contacts = new ArrayList<ContactBean>();
        while (this.parser.hasNext()) {
            String nodeName;
            int event = this.parser.next();
            if (event == 1) {
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("Name")) {
                    this.addItemToLangMap(nameMap);
                    continue;
                }
                if (nodeName.equals("TimeZone")) {
                    timeZone = this.parser.getElementText();
                    continue;
                }
                if (!nodeName.equals("Contact")) continue;
                contacts.add(this.processContact());
                continue;
            }
            if (event != 2 || !(nodeName = this.parser.getLocalName()).equals(partyNodeName)) continue;
            break;
        }
        return new PartyBeanImpl(nameMap, id, contacts, timeZone);
    }

    private ContactBean processContact() throws XMLStreamException {
        ArrayList<TextTypeWrapper> name = new ArrayList<TextTypeWrapper>();
        ArrayList<TextTypeWrapper> role = new ArrayList<TextTypeWrapper>();
        ArrayList<TextTypeWrapper> departments = new ArrayList<TextTypeWrapper>();
        ArrayList<String> email = new ArrayList<String>();
        ArrayList<String> fax = new ArrayList<String>();
        ArrayList<String> telephone = new ArrayList<String>();
        ArrayList<String> uri = new ArrayList<String>();
        ArrayList<String> x400 = new ArrayList<String>();
        while (this.parser.hasNext()) {
            String nodeName;
            int event = this.parser.next();
            if (event == 1) {
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("Name")) {
                    this.addItemToLangMap(name);
                    continue;
                }
                if (nodeName.equals("Role")) {
                    this.addItemToLangMap(role);
                    continue;
                }
                if (nodeName.equals("Department")) {
                    this.addItemToLangMap(departments);
                    continue;
                }
                if (nodeName.equals("Telephone")) {
                    telephone.add(this.parser.getElementText());
                    continue;
                }
                if (nodeName.equals("Fax")) {
                    fax.add(this.parser.getElementText());
                    continue;
                }
                if (nodeName.equals("X400")) {
                    x400.add(this.parser.getElementText());
                    continue;
                }
                if (nodeName.equals("URI")) {
                    uri.add(this.parser.getElementText());
                    continue;
                }
                if (!nodeName.equals("Email")) continue;
                email.add(this.parser.getElementText());
                continue;
            }
            if (event != 2 || !(nodeName = this.parser.getLocalName()).equals("Contact")) continue;
            break;
        }
        return new ContactBeanImpl(name, role, departments, email, fax, telephone, uri, x400);
    }

    @Override
    protected boolean moveNextObservationInternal() {
        try {
            this.currentObs = null;
            if (!this.hasNext) {
                boolean bl = false;
                return bl;
            }
            if (this.datasetPosition == DATASET_POSITION.OBSERAVTION_AS_SERIES) {
                if (this.lastCall == LAST_CALL.HAS_NEXT_SERIES) {
                    this.processSeriesNode();
                    boolean bl = true;
                    return bl;
                }
                if (this.lastCall == LAST_CALL.NEXT_SERIES) {
                    boolean bl = true;
                    return bl;
                }
                this.datasetPosition = null;
                boolean bl = false;
                return bl;
            }
            if (this.next(true)) {
                boolean bl = this.datasetPosition == DATASET_POSITION.OBSERVATION;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (XMLStreamException e) {
            throw new SdmxException((Throwable)e, "Unrecoverable error while reading SDMX data");
        }
        catch (SdmxException e) {
            throw new SdmxException((Throwable)e, "Error while attempting to read observation");
        }
        finally {
            this.lastCall = LAST_CALL.HAS_NEXT_OBS;
        }
    }

    @Override
    protected Observation lazyLoadObservation() {
        try {
            if (!this.hasNext) {
                Observation observation = null;
                return observation;
            }
            if (this.datasetPosition == DATASET_POSITION.OBSERAVTION_AS_SERIES) {
                if (this.lastCall == LAST_CALL.NEXT_OBS) {
                    Observation observation = null;
                    return observation;
                }
                if (this.lastCall == LAST_CALL.HAS_NEXT_SERIES) {
                    this.processSeriesNode();
                }
                Observation observation = this.flatObs;
                return observation;
            }
            if (this.lastCall != LAST_CALL.HAS_NEXT_OBS) {
                if (this.moveNextObservation()) {
                    Observation observation = this.processObsNode(this.parser);
                    return observation;
                }
                Observation observation = null;
                return observation;
            }
            if (this.datasetPosition == DATASET_POSITION.OBSERVATION) {
                Observation observation = this.processObsNode(this.parser);
                return observation;
            }
            Observation observation = null;
            return observation;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unrecoverable error while reading SDMX data", e);
        }
        finally {
            this.lastCall = LAST_CALL.NEXT_OBS;
        }
    }

    @Override
    protected boolean moveNextDatasetInternal() {
        try {
            if (this.lastCall != LAST_CALL.HAS_NEXT_DATASET && this.datasetPosition == DATASET_POSITION.DATASET) {
                boolean bl = true;
                return bl;
            }
            this.datasetHeaderBean = null;
            while (this.next(false)) {
                if (this.datasetPosition != DATASET_POSITION.DATASET) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unrecoverable error while reading SDMX data", e);
        }
        finally {
            this.lastCall = LAST_CALL.HAS_NEXT_DATASET;
        }
    }

    @Override
    protected boolean moveNextKeyableInternal() {
        try {
            if (this.datasetPosition == DATASET_POSITION.DATASET && this.lastCall != LAST_CALL.HAS_NEXT_DATASET) {
                boolean bl = false;
                return bl;
            }
            if (this.lastCall == LAST_CALL.HAS_NEXT_OBS && (this.datasetPosition == DATASET_POSITION.OBSERAVTION_AS_SERIES || this.datasetPosition == DATASET_POSITION.SERIES || this.datasetPosition == DATASET_POSITION.GROUP)) {
                boolean bl = true;
                return bl;
            }
            while (this.next(false)) {
                if (this.datasetPosition == DATASET_POSITION.SERIES || this.datasetPosition == DATASET_POSITION.GROUP || this.datasetPosition == DATASET_POSITION.OBSERAVTION_AS_SERIES) {
                    boolean bl = true;
                    return bl;
                }
                if (this.datasetPosition != DATASET_POSITION.DATASET) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (XMLStreamException e) {
            throw new SdmxException((Throwable)e, "Unrecoverable error while reading SDMX data");
        }
        catch (SdmxException e) {
            throw new SdmxException((Throwable)e, "Error while attempting to read key");
        }
        finally {
            this.lastCall = LAST_CALL.HAS_NEXT_SERIES;
        }
    }

    @Override
    protected Keyable lazyLoadKey() {
        try {
            if ((this.lastCall == LAST_CALL.NEXT_SERIES || this.datasetPosition != DATASET_POSITION.SERIES && this.datasetPosition != DATASET_POSITION.GROUP && this.datasetPosition != DATASET_POSITION.OBSERAVTION_AS_SERIES) && !this.moveNextKeyable()) {
                Keyable keyable = null;
                return keyable;
            }
            if (this.datasetPosition == DATASET_POSITION.GROUP) {
                Keyable key = this.processGroupNode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Read Key " + key.toString()));
                }
                Keyable keyable = key;
                return keyable;
            }
            if (this.datasetPosition == DATASET_POSITION.SERIES || this.datasetPosition == DATASET_POSITION.OBSERAVTION_AS_SERIES) {
                Keyable key = this.processSeriesNode();
                this.flatObs = this.currentObs;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)key.toString());
                }
                Keyable keyable = key;
                return keyable;
            }
            Keyable key = null;
            return key;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unrecoverable error while reading SDMX data", e);
        }
        finally {
            this.lastCall = LAST_CALL.NEXT_SERIES;
        }
    }

    public void close() {
        this.closeStreams();
        if (this.dataLocation != null) {
            this.dataLocation.close();
            this.dataLocation = null;
        }
    }

    private void closeStreams() {
        if (this.parser != null) {
            try {
                this.parser.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Error trying to close parser : " + e);
            }
        }
        if (this.parserInputStream != null) {
            try {
                this.parserInputStream.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error trying to close parser InputStream : " + e);
            }
        }
        if (this.runAheadParser != null) {
            try {
                this.runAheadParser.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Error trying to close runAheadParser : " + e);
            }
        }
        if (this.runAheadParserInputStream != null) {
            try {
                this.runAheadParserInputStream.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error trying to close runAheadParserInputStream InputStream : " + e);
            }
        }
    }

    protected abstract Keyable processGroupNode() throws XMLStreamException;

    protected abstract Keyable processSeriesNode() throws XMLStreamException;

    protected abstract Observation processObsNode(XMLStreamReader var1) throws XMLStreamException;

    protected abstract boolean next(boolean var1) throws XMLStreamException;

    static enum LAST_CALL {
        HAS_NEXT_DATASET,
        HAS_NEXT_OBS,
        HAS_NEXT_SERIES,
        NEXT_OBS,
        NEXT_SERIES;

    }
}

