/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.writer;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.dataparser.engine.writer.SdmxDataWriterEngine;
import org.sdmxsource.util.ObjectUtil;

public class GenericDataWriterEngine
extends SdmxDataWriterEngine {
    private Map<String, String> componentVals = new HashMap<String, String>();
    private String conceptAttribute;

    public GenericDataWriterEngine(SDMX_SCHEMA schemaVersion, OutputStream out) {
        super(schemaVersion, BASE_DATA_FORMAT.GENERIC, out);
        this.setConceptAttribute();
    }

    private void setConceptAttribute() {
        this.conceptAttribute = this.isTwoPointOne() ? "id" : "concept";
    }

    @Override
    public void startDataset(DataflowBean dataflowBean, DataStructureBean dsd, DatasetHeaderBean header, AnnotationBean ... annotationBeans) {
        super.startDataset(dataflowBean, dsd, header, annotationBeans);
        if (!this.isTwoPointOne()) {
            try {
                this.startElement(this.writer, this.GENERIC_NS, "KeyFamilyRef");
                this.writer.writeCharacters(dsd.getId());
                this.writer.writeEndElement();
                this.datasetAnnotations = annotationBeans;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.writeAnnotations(this.writer, annotationBeans);
        }
    }

    @Override
    public void startSeries(AnnotationBean ... annotations) {
        if (this.isFlat) {
            this.componentVals = new HashMap<String, String>();
        } else {
            try {
                if (this.currentPosition != null) {
                    switch (this.currentPosition) {
                        case DATASET_ATTRIBUTE: {
                            this.writer.writeEndElement();
                            break;
                        }
                        case OBSERVATION: {
                            this.writeEndObs();
                            this.writeEndSeries();
                            break;
                        }
                        case OBSERVATION_ATTRIBUTE: {
                            this.seriesWriter.writeEndElement();
                            this.writeEndObs();
                            this.writeEndSeries();
                            break;
                        }
                        case SERIES_KEY_ATTRIBUTE: {
                            this.seriesWriter.writeEndElement();
                            this.writeEndSeries();
                            break;
                        }
                        case SERIES_KEY: {
                            this.seriesWriter.writeEndElement();
                            this.writeEndSeries();
                            break;
                        }
                        case GROUP: {
                            this.writeEndGroup();
                            break;
                        }
                        case GROUP_KEY: {
                            this.writer.writeEndElement();
                            this.writeEndGroup();
                            break;
                        }
                        case GROUP_KEY_ATTRIBUTE: {
                            this.writer.writeEndElement();
                            this.writeEndGroup();
                        }
                    }
                }
                this.startElement(this.seriesWriter, this.GENERIC_NS, "Series");
                if (this.isTwoPointOne()) {
                    this.writeAnnotations(this.seriesWriter, annotations);
                } else {
                    this.seriesAnnotations = annotations;
                }
                this.startElement(this.seriesWriter, this.GENERIC_NS, "SeriesKey");
                this.currentPosition = SdmxDataWriterEngine.POSITION.SERIES_KEY;
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close(DataWriterEngine.FooterMessage ... footer) {
        try {
            if (this.currentPosition != null) {
                switch (this.currentPosition) {
                    case DATASET_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case OBSERVATION: {
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY: {
                        this.seriesWriter.writeEndElement();
                        this.writeEndSeries();
                        break;
                    }
                    case GROUP: {
                        this.writeEndGroup();
                        break;
                    }
                    case GROUP_KEY: {
                        this.writer.writeEndElement();
                        this.writeEndGroup();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        this.writeEndGroup();
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        super.close(footer);
    }

    @Override
    public void writeAttributeValue(String conceptId, String conceptValue) {
        conceptId = this.getComponentId(conceptId);
        if (conceptValue == null) {
            conceptValue = "";
        }
        XMLStreamWriter attributeWriter = this.seriesWriter;
        try {
            switch (this.currentPosition) {
                case DATASET: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.DATASET_ATTRIBUTE;
                    this.startElement(this.writer, this.GENERIC_NS, "Attributes");
                    attributeWriter = this.writer;
                    break;
                }
                case DATASET_ATTRIBUTE: {
                    attributeWriter = this.writer;
                    break;
                }
                case OBSERVATION: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.OBSERVATION_ATTRIBUTE;
                    this.startElement(this.seriesWriter, this.GENERIC_NS, "Attributes");
                    break;
                }
                case SERIES_KEY: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.SERIES_KEY_ATTRIBUTE;
                    this.seriesWriter.writeEndElement();
                    this.startElement(this.seriesWriter, this.GENERIC_NS, "Attributes");
                    break;
                }
                case GROUP: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.GROUP_KEY_ATTRIBUTE;
                    this.startElement(this.writer, this.GENERIC_NS, "Attributes");
                    attributeWriter = this.writer;
                    break;
                }
                case GROUP_KEY: {
                    this.writer.writeEndElement();
                    this.currentPosition = SdmxDataWriterEngine.POSITION.GROUP_KEY_ATTRIBUTE;
                    this.startElement(this.writer, this.GENERIC_NS, "Attributes");
                    attributeWriter = this.writer;
                    break;
                }
                case GROUP_KEY_ATTRIBUTE: {
                    attributeWriter = this.writer;
                }
            }
            this.startElement(attributeWriter, this.GENERIC_NS, "Value");
            attributeWriter.writeAttribute(this.conceptAttribute, conceptId);
            attributeWriter.writeAttribute("value", conceptValue);
            attributeWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeGroupKeyValue(String conceptId, String conceptValue) {
        try {
            conceptId = this.getComponentId(conceptId);
            if (this.currentPosition != SdmxDataWriterEngine.POSITION.GROUP && this.currentPosition != SdmxDataWriterEngine.POSITION.GROUP_KEY) {
                throw new IllegalArgumentException("startGroup must be called before valling writeGroupKeyValue");
            }
            this.currentPosition = SdmxDataWriterEngine.POSITION.GROUP_KEY;
            this.startElement(this.writer, this.GENERIC_NS, "Value");
            this.writer.writeAttribute(this.conceptAttribute, conceptId);
            this.writer.writeAttribute("value", conceptValue);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeSeriesKeyValue(String dimensionId, String dimensionValue) {
        dimensionId = this.getComponentId(dimensionId);
        if (this.isFlat) {
            this.componentVals.put(dimensionId, dimensionValue);
        } else {
            try {
                if (this.currentPosition != SdmxDataWriterEngine.POSITION.SERIES_KEY) {
                    this.startSeries(new AnnotationBean[0]);
                }
                this.startElement(this.seriesWriter, this.GENERIC_NS, "Value");
                this.seriesWriter.writeAttribute(this.conceptAttribute, dimensionId);
                this.seriesWriter.writeAttribute("value", dimensionValue);
                this.seriesWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void closeGroupWriter() throws Exception {
        if (this.currentPosition != null) {
            switch (this.currentPosition) {
                case GROUP: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new SdmxSemmanticException("Attempting to write observation to group , an observation must belong to a series");
                }
                case GROUP_KEY: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new SdmxSemmanticException("Attempting to write observation to group , an observation must belong to a series");
                }
                case GROUP_KEY_ATTRIBUTE: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new SdmxSemmanticException("Attempting to write observation to group , an observation must belong to a series");
                }
            }
        }
        this.writer.flush();
    }

    public void writeObservation(String obsConceptValue, String obsValue, AnnotationBean ... annotations) {
        if (this.isFlat) {
            throw new IllegalArgumentException("Can not write observation, as no observation concept id was given, and this is writing a flat dataset. Plase use the method: writeObservation(String obsConceptId, String obsIdValue, String obsValue, AnnotationBean... annotations)");
        }
        if (this.isCrossSectional) {
            this.writeObservation(this.crossSectionConcept, obsConceptValue, obsValue, annotations);
        } else {
            this.writeObservation("TIME_PERIOD", obsConceptValue, obsValue, annotations);
        }
    }

    @Override
    public void writeObservation(String obsConceptId, String obsConceptValue, String obsValue, AnnotationBean ... annotations) {
        obsConceptId = this.getComponentId(obsConceptId);
        super.writeObservation(obsConceptId, obsConceptValue, obsValue, annotations);
        if (!ObjectUtil.validString((String[])new String[]{obsValue})) {
            obsValue = "NaN";
        }
        try {
            switch (this.currentPosition) {
                case OBSERVATION: {
                    this.writeEndObs();
                    break;
                }
                case OBSERVATION_ATTRIBUTE: {
                    this.seriesWriter.writeEndElement();
                    this.writeEndObs();
                    break;
                }
                case SERIES_KEY_ATTRIBUTE: {
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case SERIES_KEY: {
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case GROUP: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new SdmxSemmanticException("Attempting to write observation to group , an observation must belong to a series");
                }
                case GROUP_KEY: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new SdmxSemmanticException("Attempting to write observation to group , an observation must belong to a series");
                }
                case GROUP_KEY_ATTRIBUTE: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new SdmxSemmanticException("Attempting to write observation to group , an observation must belong to a series");
                }
                default: {
                    if (this.isTwoPointOne()) break;
                    throw new IllegalArgumentException("An observation may only be written while inside a series");
                }
            }
            this.currentPosition = SdmxDataWriterEngine.POSITION.OBSERVATION;
            this.startElement(this.seriesWriter, this.GENERIC_NS, "Obs");
            if (this.isFlat) {
                this.componentVals.put(obsConceptId, obsConceptValue);
                this.writeAnnotations(this.seriesWriter, annotations);
                this.startElement(this.seriesWriter, this.GENERIC_NS, "ObsKey");
                for (String componentId : this.componentVals.keySet()) {
                    this.startElement(this.seriesWriter, this.GENERIC_NS, "Value");
                    this.seriesWriter.writeAttribute("id", componentId);
                    this.seriesWriter.writeAttribute("value", this.componentVals.get(componentId));
                    this.seriesWriter.writeEndElement();
                }
                this.seriesWriter.writeEndElement();
            } else if (this.isTwoPointOne()) {
                this.writeAnnotations(this.seriesWriter, annotations);
                this.startElement(this.seriesWriter, this.GENERIC_NS, "ObsDimension");
                if (this.isCrossSectional) {
                    this.seriesWriter.writeAttribute("id", obsConceptId);
                }
                this.seriesWriter.writeAttribute("value", obsConceptValue);
                this.seriesWriter.writeEndElement();
            } else {
                this.obsAnnotations = annotations;
                this.startElement(this.seriesWriter, this.GENERIC_NS, "Time");
                this.seriesWriter.writeCharacters(obsConceptValue);
                this.seriesWriter.writeEndElement();
            }
            this.startElement(this.seriesWriter, this.GENERIC_NS, "ObsValue");
            if (ObjectUtil.validString((String[])new String[]{obsValue})) {
                this.seriesWriter.writeAttribute("value", obsValue);
            }
            this.seriesWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startGroup(String groupId, AnnotationBean ... annotations) {
        try {
            if (this.currentPosition != null) {
                switch (this.currentPosition) {
                    case DATASET_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case OBSERVATION: {
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY: {
                        this.seriesWriter.writeEndElement();
                        this.writeEndSeries();
                        break;
                    }
                    case GROUP: {
                        this.writeEndGroup();
                        break;
                    }
                    case GROUP_KEY: {
                        this.writer.writeEndElement();
                        this.writeEndGroup();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        this.writeEndGroup();
                    }
                }
            }
            this.startElement(this.writer, this.GENERIC_NS, "Group");
            this.writer.writeAttribute("type", groupId);
            if (this.isTwoPointOne()) {
                this.writeAnnotations(this.writer, annotations);
            } else {
                this.groupAnnotations = annotations;
            }
            this.startElement(this.writer, this.GENERIC_NS, "GroupKey");
            this.currentPosition = SdmxDataWriterEngine.POSITION.GROUP;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

