/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.writer;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.DIMENSION_AT_OBSERVATION;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.ContactBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.sdmx.util.stax.StaxUtil;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.io.OverflowWriteableDataLocation;
import org.sdmxsource.util.io.StreamUtil;

public abstract class SdmxDataWriterEngine
implements DataWriterEngine {
    protected AnnotationBean[] datasetAnnotations;
    protected AnnotationBean[] seriesAnnotations;
    protected AnnotationBean[] groupAnnotations;
    protected AnnotationBean[] obsAnnotations;
    protected boolean isClosed = false;
    protected String PREFIX_GENERIC = "generic";
    protected String PREFIX_MESSAGE = "message";
    protected String PREFIX_COMMON = "common";
    protected String PREFIX_CROSS = "cross";
    protected String PREFIX_COMPACT = "ns";
    protected static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    protected static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    protected Namespace GENERIC_NS;
    private Namespace MESSAGE_NS;
    private Namespace COMMON_NS;
    protected Namespace CROSS_NS;
    protected Namespace COMPACT_NS;
    private Namespace FOOTER_NS = new Namespace("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message/footer", "footer");
    protected boolean headerWritten = false;
    protected SDMX_SCHEMA schemaVersion;
    protected String crossSectionConcept;
    protected boolean isCrossSectional;
    protected boolean isFlat;
    private BASE_DATA_FORMAT dataFormat;
    protected XMLStreamWriter writer = null;
    protected XMLStreamWriter seriesWriter = null;
    private OutputStream seriesOut;
    private OutputStream out;
    private OutputStream finalOutputStream;
    protected List<String> conceptIds;
    protected List<String> currentGroupConceptIds;
    private Map<String, String> componentIdMapping = new HashMap<String, String>();
    POSITION currentPosition;
    private List<DataSetOutputStreams> outputDatasetLocations = new ArrayList<DataSetOutputStreams>();
    private DataSetOutputStreams currentDatasetOutputLocations;
    private HeaderBean header;
    boolean isCrossSectionalMeasure = false;
    private List<Namespace> knownNamespaces = new ArrayList<Namespace>();

    public SdmxDataWriterEngine(SDMX_SCHEMA schemaVersion, BASE_DATA_FORMAT dataFormat, OutputStream out) {
        this.finalOutputStream = out;
        this.schemaVersion = schemaVersion;
        this.dataFormat = dataFormat;
        this.createNamespaces();
    }

    void writeAnnotations(XMLStreamWriter annotationWriter, AnnotationBean ... annotations) {
        try {
            if (annotations != null && annotations.length > 0) {
                if (this.isTwoPointOne()) {
                    this.startElement(annotationWriter, this.COMMON_NS, "Annotations");
                } else if (this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                    this.startElement(annotationWriter, this.GENERIC_NS, "Annotations");
                } else {
                    this.startElement(annotationWriter, this.COMPACT_NS, "Annotations");
                }
                for (AnnotationBean currentAnnotation : annotations) {
                    this.startElement(annotationWriter, this.COMMON_NS, "Annotation");
                    if (this.isTwoPointOne() && ObjectUtil.validString((String[])new String[]{currentAnnotation.getId()})) {
                        annotationWriter.writeAttribute("id", currentAnnotation.getId());
                    }
                    if (ObjectUtil.validString((String[])new String[]{currentAnnotation.getTitle()})) {
                        this.startElement(annotationWriter, this.COMMON_NS, "AnnotationTitle");
                        annotationWriter.writeCharacters(currentAnnotation.getTitle());
                        annotationWriter.writeEndElement();
                    }
                    if (ObjectUtil.validString((String[])new String[]{currentAnnotation.getType()})) {
                        this.startElement(annotationWriter, this.COMMON_NS, "AnnotationType");
                        annotationWriter.writeCharacters(currentAnnotation.getType());
                        annotationWriter.writeEndElement();
                    }
                    if (currentAnnotation.getUri() != null) {
                        this.startElement(annotationWriter, this.COMMON_NS, "AnnotationURL");
                        annotationWriter.writeCharacters(currentAnnotation.getUri().toString());
                        annotationWriter.writeEndElement();
                    }
                    if (ObjectUtil.validCollection((Collection)currentAnnotation.getText())) {
                        for (TextTypeWrapper currentText : currentAnnotation.getText()) {
                            this.startElement(annotationWriter, this.COMMON_NS, "AnnotationText");
                            annotationWriter.writeAttribute("xml", XML_NS, "lang", currentText.getLocale());
                            annotationWriter.writeCharacters(currentText.getValue());
                            annotationWriter.writeEndElement();
                        }
                    }
                    annotationWriter.writeEndElement();
                }
                annotationWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void createNamespaces() {
        this.COMPACT_NS = new Namespace("http://www.sdmxfusion.com/ns/compact", this.PREFIX_COMPACT);
        if (this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE) {
            this.GENERIC_NS = new Namespace("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", this.PREFIX_GENERIC);
            this.MESSAGE_NS = new Namespace("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message", this.PREFIX_MESSAGE);
            this.COMMON_NS = new Namespace("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/common", this.PREFIX_COMMON);
        }
        if (this.schemaVersion == SDMX_SCHEMA.VERSION_TWO) {
            this.GENERIC_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v2_0/generic", this.PREFIX_GENERIC);
            this.MESSAGE_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v2_0/message", this.PREFIX_MESSAGE);
            this.COMMON_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v2_0/common", this.PREFIX_COMMON);
            if (this.dataFormat == BASE_DATA_FORMAT.CROSS_SECTIONAL) {
                this.CROSS_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v2_0/cross", this.PREFIX_CROSS);
            }
        }
        if (this.schemaVersion == SDMX_SCHEMA.VERSION_ONE) {
            this.GENERIC_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/generic", this.PREFIX_GENERIC);
            this.MESSAGE_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/message", this.PREFIX_MESSAGE);
            this.COMMON_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/common", this.PREFIX_COMMON);
            if (this.dataFormat == BASE_DATA_FORMAT.CROSS_SECTIONAL) {
                this.CROSS_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/cross", this.PREFIX_CROSS);
            }
        }
    }

    private void writeNameSpace(Namespace ns) throws XMLStreamException {
        if (ns != null) {
            this.writer.writeNamespace(ns.namespacePrefix, ns.namespaceURL);
        }
    }

    protected boolean isTwoPointOne() {
        return this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE;
    }

    protected void startElement(XMLStreamWriter streamWriter, Namespace ns, String elementName) throws XMLStreamException {
        streamWriter.writeStartElement(ns.namespacePrefix, elementName, ns.namespaceURL);
    }

    private String getStructureRef(MaintainableBean maint) {
        return maint.getAgencyId() + "_" + maint.getId() + "_" + maint.getVersion().replaceAll("\\.", "_");
    }

    public void startDataset(DataflowBean dataflowBean, DataStructureBean dsd, DatasetHeaderBean header, AnnotationBean ... annotationMutableBean) {
        this.checkClosed();
        if (dsd == null) {
            throw new IllegalArgumentException("Can not start dataset, no DataStructure provided");
        }
        this.componentIdMapping = new HashMap<String, String>();
        for (ComponentBean currentComponent : dsd.getComponents()) {
            this.componentIdMapping.put(currentComponent.getId(), this.getComponentId(currentComponent));
        }
        this.closeCurrentWriter();
        this.currentPosition = POSITION.DATASET;
        this.currentDatasetOutputLocations = new DataSetOutputStreams(dataflowBean, dsd, header, this.knownNamespaces, this.outputDatasetLocations.size() + 1);
        if (this.currentDatasetOutputLocations.dataNamespace != null) {
            this.knownNamespaces.add(this.currentDatasetOutputLocations.dataNamespace);
        }
        this.crossSectionConcept = this.currentDatasetOutputLocations.getDimensionAtObservation();
        this.isFlat = this.crossSectionConcept.equals(DIMENSION_AT_OBSERVATION.ALL.getVal());
        boolean bl = this.isCrossSectional = !this.crossSectionConcept.equals("TIME_PERIOD");
        if (!this.isFlat) {
            DimensionBean dimension = dsd.getDimension(this.crossSectionConcept);
            if (dimension == null) {
                throw new IllegalArgumentException("Can not start dataset.  The dimension at observation has been set to '" + this.crossSectionConcept + "', but this dimenison does not exist in the datastructure '" + dsd.getUrn() + "'");
            }
            this.isCrossSectionalMeasure = dimension.isMeasureDimension();
        }
        this.out = this.currentDatasetOutputLocations.outputStream;
        this.seriesOut = this.currentDatasetOutputLocations.seriesOutLocation.getOutputStream();
        this.outputDatasetLocations.add(this.currentDatasetOutputLocations);
    }

    public void writeHeader(HeaderBean header) {
        this.checkClosed();
        this.header = header;
    }

    protected String getComponentId(String componentId) {
        if (this.isTwoPointOne()) {
            return componentId;
        }
        if (this.componentIdMapping.containsKey(componentId)) {
            return this.componentIdMapping.get(componentId);
        }
        return componentId;
    }

    public void writeObservation(Date obsTime, String obsValue, TIME_FORMAT sdmxTimeFormat, AnnotationBean ... annotations) {
        this.checkClosed();
        if (!ObjectUtil.validString((String[])new String[]{obsValue})) {
            obsValue = "NaN";
        }
        this.writeObservation("TIME_PERIOD", DateUtil.formatDate((Date)obsTime, (TIME_FORMAT)sdmxTimeFormat), obsValue, annotations);
    }

    protected String getComponentId(ComponentBean component) {
        if (component == null) {
            return null;
        }
        if (this.isTwoPointOne()) {
            return component.getId();
        }
        return ConceptRefUtil.getConceptId((StructureReferenceBean)component.getConceptRef());
    }

    public void startGroup(String groupId, AnnotationBean ... annotationBean) {
        this.checkClosed();
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not startGroup, no call has been made to startDataset");
        }
    }

    public void writeGroupKeyValue(String id, String value) {
        this.checkClosed();
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeGroupKeyValue, no call has been made to startDataset");
        }
        if (this.currentPosition != POSITION.GROUP && this.currentPosition != POSITION.GROUP_KEY && this.currentPosition != POSITION.GROUP_KEY_ATTRIBUTE) {
            throw new IllegalArgumentException("Can not writeGroupKeyValue, not in a group");
        }
    }

    public void startSeries(AnnotationBean ... annotationMutableBean) {
        this.checkClosed();
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not startSeries, no call has been made to startDataset");
        }
    }

    public void writeSeriesKeyValue(String id, String value) {
        this.checkClosed();
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeSeriesKeyValue, no call has been made to startDataset");
        }
    }

    public void writeAttributeValue(String id, String value) {
        this.checkClosed();
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeAttributeValue, no call has been made to startDataset");
        }
    }

    public void writeObservation(String obsConceptId, String obsIdValue, String obsValue, AnnotationBean ... annotationBean) {
        this.checkClosed();
        if (obsConceptId == null) {
            if (this.isCrossSectional) {
                throw new SdmxSemmanticException("Error while writing observation, a value for cross sectional concept '" + this.crossSectionConcept + "' expected and not given");
            }
            throw new SdmxSemmanticException("Error while writing observation, an observation time was expected and not given");
        }
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeObservation, no call has been made to startDataset");
        }
    }

    public void writeDatasetAttribute(String id, String value) {
        this.checkClosed();
        this.currentDatasetOutputLocations.datasetAttributes.put(id, value);
    }

    protected void writeEndObs() throws XMLStreamException {
        if (!this.isTwoPointOne()) {
            this.writeAnnotations(this.seriesWriter, this.obsAnnotations);
            this.obsAnnotations = null;
        }
        this.seriesWriter.writeEndElement();
    }

    protected void writeEndSeries() throws XMLStreamException {
        if (!this.isTwoPointOne()) {
            this.writeAnnotations(this.seriesWriter, this.seriesAnnotations);
            this.seriesAnnotations = null;
        }
        this.seriesWriter.writeEndElement();
        this.currentPosition = POSITION.DATASET;
    }

    protected void writeEndGroup() throws XMLStreamException {
        if (!this.isTwoPointOne()) {
            this.writeAnnotations(this.writer, this.groupAnnotations);
            this.groupAnnotations = null;
        }
        this.writer.writeEndElement();
        this.currentPosition = POSITION.DATASET;
    }

    protected abstract void closeGroupWriter() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(DataWriterEngine.FooterMessage ... footer) {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.closeCurrentWriter();
        try {
            this.flushOutput();
        }
        finally {
            try {
                if (footer != null && footer.length > 0 && this.isTwoPointOne()) {
                    this.startElement(this.writer, this.FOOTER_NS, "Footer");
                    for (DataWriterEngine.FooterMessage currentFooter : footer) {
                        this.startElement(this.writer, this.FOOTER_NS, "Message");
                        this.writer.writeAttribute("code", currentFooter.getCode());
                        if (currentFooter.getSeverity() != null) {
                            this.writer.writeAttribute("severity", currentFooter.getSeverity().toString());
                        }
                        for (TextTypeWrapper ttw : currentFooter.getFooterText()) {
                            this.startElement(this.writer, this.COMMON_NS, "Text");
                            if (ttw.getLocale() != null) {
                                this.writer.writeAttribute("xml", XML_NS, "lang", ttw.getLocale());
                            }
                            if (ttw.getValue() != null) {
                                this.writer.writeCharacters(ttw.getValue());
                            }
                            this.writer.writeEndElement();
                        }
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                this.writer.writeEndDocument();
                this.writer.flush();
                this.writer.close();
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
            }
            catch (Throwable e) {
                System.err.println("Error trying to close resources");
                e.printStackTrace();
            }
        }
    }

    protected void checkClosed() {
        if (this.isClosed) {
            throw new RuntimeException("Data Write has already been closed and can not have any more information written to it");
        }
    }

    private void closeCurrentWriter() {
        if (this.currentDatasetOutputLocations != null) {
            DataStructureBean dsd = this.currentDatasetOutputLocations.dsd;
            try {
                if (this.isTwoPointOne() && dsd.getGroups().size() > 0) {
                    this.seriesWriter.writeEndDocument();
                    this.seriesWriter.flush();
                    this.seriesWriter.close();
                    this.closeGroupWriter();
                    this.copyToOutputStream((ReadableDataLocation)this.currentDatasetOutputLocations.seriesOutLocation);
                    StreamUtil.closeStream((OutputStream[])new OutputStream[]{this.seriesOut});
                } else {
                    this.writeAnnotations(this.writer, this.datasetAnnotations);
                    this.datasetAnnotations = null;
                }
                this.writer.writeEndDocument();
                this.writer.flush();
                this.writer.close();
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
            }
            catch (Throwable e) {
                this.currentDatasetOutputLocations.out.close();
                this.currentDatasetOutputLocations.seriesOutLocation.close();
                this.currentDatasetOutputLocations = null;
                this.isClosed = true;
                throw new RuntimeException(e);
            }
            finally {
                this.currentPosition = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToOutputStream(ReadableDataLocation rdl) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        InputStream is = rdl.getInputStream();
        XMLStreamReader parser = factory.createXMLStreamReader(is, "UTF-8");
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                this.writer.flush();
                if (event != 1) continue;
                StaxUtil.copyNode((XMLStreamReader)parser, (boolean)true, (boolean)false, (boolean)false, (XMLStreamWriter[])new XMLStreamWriter[]{this.writer});
            }
        }
        catch (Throwable throwable) {
            parser.close();
            StreamUtil.closeStream((InputStream[])new InputStream[]{is});
            rdl.close();
            throw throwable;
        }
        parser.close();
        StreamUtil.closeStream((InputStream[])new InputStream[]{is});
        rdl.close();
    }

    private void flushOutput() {
        try {
            boolean multipleDatasets;
            XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
            this.writer = xmlOutputfactory.createXMLStreamWriter(this.finalOutputStream, "UTF-8");
            this.writer.writeStartDocument();
            boolean bl = multipleDatasets = this.outputDatasetLocations.size() > 1;
            if (this.isTwoPointOne()) {
                if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                    this.startElement(this.writer, this.MESSAGE_NS, "StructureSpecificData");
                    this.writer.writeNamespace("ss", "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific");
                } else if (this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                    this.startElement(this.writer, this.MESSAGE_NS, "GenericData");
                }
                this.writeNameSpace(this.FOOTER_NS);
            } else if (multipleDatasets) {
                this.startElement(this.writer, this.MESSAGE_NS, "MessageGroup");
            } else {
                this.startElement(this.writer, this.MESSAGE_NS, this.dataFormat.getRootNode());
            }
            HashSet<String> nameSpacePrefixWritten = new HashSet<String>();
            if (this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                this.writeNameSpace(this.GENERIC_NS);
            } else {
                for (DataSetOutputStreams dsOut : this.outputDatasetLocations) {
                    if (!nameSpacePrefixWritten.contains(((DataSetOutputStreams)dsOut).dataNamespace.namespacePrefix)) {
                        this.writeNameSpace(dsOut.dataNamespace);
                        nameSpacePrefixWritten.add(((DataSetOutputStreams)dsOut).dataNamespace.namespacePrefix);
                    }
                    if (nameSpacePrefixWritten.contains(((DataSetOutputStreams)dsOut).datasetNamespace.namespacePrefix)) continue;
                    this.writeNameSpace(dsOut.datasetNamespace);
                    nameSpacePrefixWritten.add(((DataSetOutputStreams)dsOut).datasetNamespace.namespacePrefix);
                }
            }
            if (!nameSpacePrefixWritten.contains(this.COMMON_NS.namespacePrefix)) {
                this.writeNameSpace(this.COMMON_NS);
            }
            if (!nameSpacePrefixWritten.contains(this.MESSAGE_NS.namespacePrefix)) {
                this.writeNameSpace(this.MESSAGE_NS);
            }
            this.writer.writeNamespace("xsi", XSI_NS);
            this.writer.writeNamespace("xml", XML_NS);
            this.writeHeader();
            for (DataSetOutputStreams dsOut : this.outputDatasetLocations) {
                Namespace datasetNamespace = dsOut.datasetNamespace;
                if (multipleDatasets && !this.isTwoPointOne() && this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                    datasetNamespace = this.GENERIC_NS;
                }
                this.startElement(this.writer, datasetNamespace, "DataSet");
                if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                    for (String attributeName : dsOut.datasetAttributes.keySet()) {
                        this.writer.writeAttribute(attributeName, (String)dsOut.datasetAttributes.get(attributeName));
                    }
                }
                this.writeDatasetHeader(dsOut, multipleDatasets);
                this.copyToOutputStream((ReadableDataLocation)dsOut.out);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDatasetHeader(DataSetOutputStreams dsOut, boolean hasMultipleDatasets) throws XMLStreamException {
        if (this.isTwoPointOne()) {
            if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                this.writer.writeAttribute("ss", "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific", "dataScope", "DataStructure");
                this.writer.writeAttribute("xsi", XSI_NS, "type", this.COMPACT_NS.namespacePrefix + ":DataSetType");
                this.writer.writeAttribute("ss", "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific", "structureRef", this.getStructureRef(dsOut.getStructureForData()));
            } else {
                this.writer.writeAttribute("structureRef", this.getStructureRef(dsOut.getStructureForData()));
            }
        }
        if (dsOut.headerBean != null) {
            DatasetHeaderBean datasetHeader = dsOut.headerBean;
            if (ObjectUtil.validString((String[])new String[]{datasetHeader.getPublicationPeriod()})) {
                this.writer.writeAttribute("publicationPeriod", datasetHeader.getPublicationPeriod());
            }
            if (datasetHeader.getPublicationYear() > 0) {
                this.writer.writeAttribute("publicationYear", Integer.toString(datasetHeader.getPublicationYear()));
            }
            if (datasetHeader.getValidFrom() != null) {
                this.writer.writeAttribute("validFromDate", DateUtil.formatDate((Date)datasetHeader.getValidFrom()));
            }
            if (datasetHeader.getValidTo() != null) {
                this.writer.writeAttribute("validToDate", DateUtil.formatDate((Date)datasetHeader.getValidTo()));
            }
            if (hasMultipleDatasets) {
                if (datasetHeader.getAction() != null) {
                    this.writer.writeAttribute("action", datasetHeader.getAction().getAction());
                }
                if (ObjectUtil.validString((String[])new String[]{datasetHeader.getDatasetId()})) {
                    if (this.isTwoPointOne()) {
                        this.writer.writeAttribute("setID", datasetHeader.getDatasetId());
                    } else {
                        this.writer.writeAttribute("datasetID", datasetHeader.getDatasetId());
                    }
                }
                if (!this.isTwoPointOne()) {
                    this.writer.writeAttribute("keyFamilyURI", dsOut.dsd.getUrn());
                }
                if (datasetHeader.getReportingBeginDate() != null) {
                    this.writer.writeAttribute("reportingBeginDate", DateUtil.formatDate((Date)datasetHeader.getReportingBeginDate()));
                }
                if (datasetHeader.getReportingEndDate() != null) {
                    this.writer.writeAttribute("reportingEndDate", DateUtil.formatDate((Date)datasetHeader.getReportingEndDate()));
                }
            }
        }
    }

    private void writeHeader() {
        try {
            this.startElement(this.writer, this.MESSAGE_NS, "Header");
            this.startElement(this.writer, this.MESSAGE_NS, "ID");
            if (this.header != null && ObjectUtil.validString((String[])new String[]{this.header.getId()})) {
                this.writer.writeCharacters(this.header.getId());
            } else {
                this.writer.writeCharacters("DS" + Long.toString(new Date().getTime()));
            }
            this.writer.writeEndElement();
            this.startElement(this.writer, this.MESSAGE_NS, "Test");
            if (this.header != null) {
                this.writer.writeCharacters(new Boolean(this.header.isTest()).toString());
            } else {
                this.writer.writeCharacters("false");
            }
            this.writer.writeEndElement();
            if (!this.isTwoPointOne() && this.header != null && this.header.getName() != null) {
                this.writeTextTypes(this.MESSAGE_NS, "Name", this.header.getName());
            }
            this.startElement(this.writer, this.MESSAGE_NS, "Prepared");
            if (this.header != null && this.header.getPrepared() != null) {
                this.writer.writeCharacters(DateUtil.formatDate((Date)this.header.getPrepared()));
            } else {
                this.writer.writeCharacters(DateUtil.formatDate((Date)new Date()));
            }
            this.writer.writeEndElement();
            this.startElement(this.writer, this.MESSAGE_NS, "Sender");
            if (this.header != null && this.header.getSender() != null) {
                this.writeParty(this.header.getSender(), this.isTwoPointOne());
            } else {
                this.writer.writeAttribute("id", "MetadataTechnology");
            }
            this.writer.writeEndElement();
            if (this.header != null && this.header.getReceiver() != null) {
                this.writeReceiver(this.header.getReceiver());
            }
            if (this.isTwoPointOne() && this.header != null && this.header.getName() != null) {
                this.writeTextTypes(this.COMMON_NS, "Name", this.header.getName());
            }
            HashSet<MaintainableBean> constrainables = new HashSet<MaintainableBean>();
            for (DataSetOutputStreams os : this.outputDatasetLocations) {
                constrainables.add(os.getStructureForData());
            }
            if (this.isTwoPointOne()) {
                for (MaintainableBean currentStructure : constrainables) {
                    this.startElement(this.writer, this.MESSAGE_NS, "Structure");
                    this.writer.writeAttribute("structureID", this.getStructureRef(currentStructure));
                    if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                        this.writer.writeAttribute("namespace", this.COMPACT_NS.namespaceURL);
                    }
                    if (this.crossSectionConcept != null) {
                        this.writer.writeAttribute("dimensionAtObservation", this.crossSectionConcept);
                    } else {
                        this.writer.writeAttribute("dimensionAtObservation", "TIME_PERIOD");
                    }
                    if (currentStructure instanceof DataflowBean) {
                        this.startElement(this.writer, this.COMMON_NS, "StructureUsage");
                    } else {
                        this.startElement(this.writer, this.COMMON_NS, "Structure");
                    }
                    this.writer.writeStartElement("Ref");
                    this.writer.writeAttribute("agencyID", currentStructure.getAgencyId());
                    this.writer.writeAttribute("id", currentStructure.getId());
                    this.writer.writeAttribute("version", currentStructure.getVersion());
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
            } else if (constrainables.size() == 1) {
                Object maint = constrainables.toArray()[0];
                CrossReferenceBean dsdRef = null;
                if (maint instanceof DataflowBean) {
                    dsdRef = ((DataflowBean)maint).getDataStructureRef();
                } else if (maint instanceof DataStructureBean) {
                    dsdRef = ((DataStructureBean)maint).asReference();
                }
                this.startElement(this.writer, this.MESSAGE_NS, "KeyFamilyRef");
                this.writer.writeCharacters(dsdRef.getMaintainableReference().getMaintainableId());
                this.writer.writeEndElement();
                this.startElement(this.writer, this.MESSAGE_NS, "KeyFamilyAgency");
                this.writer.writeCharacters(dsdRef.getMaintainableReference().getAgencyId());
                this.writer.writeEndElement();
            }
            if (this.header != null) {
                String reportingEndDate;
                String reportingBeginDate;
                MaintainableRefBean ref;
                if (this.isTwoPointOne() && this.header.getDataProviderReference() != null && ObjectUtil.validString((String[])new String[]{(ref = this.header.getDataProviderReference().getMaintainableReference()).getAgencyId(), ref.getMaintainableId()})) {
                    this.startElement(this.writer, this.MESSAGE_NS, "DataProvider");
                    this.writer.writeStartElement("Ref");
                    this.writer.writeAttribute("agencyID", ref.getAgencyId());
                    this.writer.writeAttribute("id", ref.getMaintainableId());
                    if (ObjectUtil.validString((String[])new String[]{ref.getVersion()})) {
                        this.writer.writeAttribute("version", ref.getVersion());
                    } else {
                        this.writer.writeAttribute("version", "1.0");
                    }
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                if (!this.isTwoPointOne() && this.header.hasAdditionalAttribute("DATASET_AGENCY")) {
                    this.startElement(this.writer, this.MESSAGE_NS, "DataSetAgency");
                    this.writer.writeCharacters(this.header.getAdditionalAttribute("DATASET_AGENCY"));
                    this.writer.writeEndElement();
                }
                String datasetId = this.getDatasetIdForHeader();
                String datasetAction = this.getDatasetActionForHeader();
                if (this.isTwoPointOne()) {
                    this.writeDatasetAction(datasetAction);
                    this.writeDatasetId(datasetId);
                } else {
                    this.writeDatasetId(datasetId);
                    this.writeDatasetAction(datasetAction);
                }
                if (this.header.getExtracted() != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "Extracted");
                    this.writer.writeCharacters(DateUtil.formatDate((Date)this.header.getExtracted()));
                    this.writer.writeEndElement();
                }
                if ((reportingBeginDate = this.getReportingBeginForHeader()) != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "ReportingBegin");
                    this.writer.writeCharacters(reportingBeginDate);
                    this.writer.writeEndElement();
                }
                if ((reportingEndDate = this.getReportingEndForHeader()) != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "ReportingEnd");
                    this.writer.writeCharacters(reportingEndDate);
                    this.writer.writeEndElement();
                }
                if (this.isTwoPointOne() && this.header.getEmbargoDate() != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "EmbargoDate");
                    this.writer.writeCharacters(DateUtil.formatDate((Date)this.header.getEmbargoDate()));
                    this.writer.writeEndElement();
                }
                this.writeTextTypes(this.MESSAGE_NS, "Source", this.header.getSource());
            }
            this.writer.writeEndElement();
            this.headerWritten = true;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean writeDatasetId(String datasetId) throws XMLStreamException {
        if (ObjectUtil.validString((String[])new String[]{datasetId})) {
            this.startElement(this.writer, this.MESSAGE_NS, "DataSetID");
            this.writer.writeCharacters(datasetId);
            this.writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeDatasetAction(String datasetAction) throws XMLStreamException {
        if (ObjectUtil.validString((String[])new String[]{datasetAction})) {
            this.startElement(this.writer, this.MESSAGE_NS, "DataSetAction");
            this.writer.writeCharacters(datasetAction);
            this.writer.writeEndElement();
            return true;
        }
        return false;
    }

    private String getDatasetIdForHeader() {
        if (ObjectUtil.validString((String[])new String[]{this.header.getDatasetId()})) {
            return this.header.getDatasetId();
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return primaryHeaderBean.getDatasetId();
        }
        String primaryId = primaryHeaderBean.getDatasetId();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null) {
                return null;
            }
            if (primaryId.equals(headerBean.getDatasetId())) continue;
            return null;
        }
        return primaryId;
    }

    private String getDatasetActionForHeader() {
        if (this.header.getAction() != null) {
            return this.header.getAction().getAction();
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null || primaryHeaderBean.getAction() == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return primaryHeaderBean.getAction().getAction();
        }
        DATASET_ACTION primaryAction = primaryHeaderBean.getAction();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null || headerBean.getAction() == null) {
                return null;
            }
            if (primaryAction.equals((Object)headerBean.getAction())) continue;
            return null;
        }
        return primaryAction.getAction();
    }

    private String getReportingBeginForHeader() {
        if (this.header.getReportingBegin() != null) {
            return DateUtil.formatDate((Date)this.header.getReportingBegin());
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null || primaryHeaderBean.getReportingBeginDate() == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return DateUtil.formatDate((Date)primaryHeaderBean.getReportingBeginDate());
        }
        Date primaryDate = primaryHeaderBean.getReportingBeginDate();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null || headerBean.getReportingBeginDate() == null) {
                return null;
            }
            if (primaryDate.equals(headerBean.getReportingBeginDate())) continue;
            return null;
        }
        return DateUtil.formatDate((Date)primaryDate);
    }

    private String getReportingEndForHeader() {
        if (this.header.getReportingEnd() != null) {
            return DateUtil.formatDate((Date)this.header.getReportingEnd());
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null || primaryHeaderBean.getReportingEndDate() == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return DateUtil.formatDate((Date)primaryHeaderBean.getReportingEndDate());
        }
        Date primaryDate = primaryHeaderBean.getReportingEndDate();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null || headerBean.getReportingEndDate() == null) {
                return null;
            }
            if (primaryDate.equals(headerBean.getReportingEndDate())) continue;
            return null;
        }
        return DateUtil.formatDate((Date)primaryDate);
    }

    private void writeReceiver(List<PartyBean> receivers) throws XMLStreamException {
        if (receivers != null) {
            for (PartyBean currentReceiver : receivers) {
                this.startElement(this.writer, this.MESSAGE_NS, "Receiver");
                this.writeParty(currentReceiver, false);
                this.writer.writeEndElement();
            }
        }
    }

    private void writeParty(PartyBean party, boolean includeTimeZone) throws XMLStreamException {
        if (ObjectUtil.validString((String[])new String[]{party.getId()})) {
            this.writer.writeAttribute("id", party.getId());
            if (party.getName() != null) {
                Namespace nameNamespace = this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE ? this.COMMON_NS : this.MESSAGE_NS;
                this.writeTextTypes(nameNamespace, "Name", party.getName());
            }
            if (party.getContacts() != null) {
                this.writeContacts(party.getContacts());
            }
            if (includeTimeZone && ObjectUtil.validString((String[])new String[]{party.getTimeZone()})) {
                this.startElement(this.writer, this.MESSAGE_NS, "Timezone");
                this.writer.writeCharacters(party.getTimeZone());
                this.writer.writeEndElement();
            }
        } else {
            this.writer.writeAttribute("id", "unknown");
        }
    }

    private void writeTextTypes(Namespace ns, String elementName, List<TextTypeWrapper> textTypes) throws XMLStreamException {
        if (textTypes != null) {
            for (TextTypeWrapper tt : textTypes) {
                this.startElement(this.writer, ns, elementName);
                this.writer.writeAttribute("xml", XML_NS, "lang", tt.getLocale());
                this.writer.writeCharacters(tt.getValue());
                this.writer.writeEndElement();
            }
        }
    }

    private void writeListContents(Namespace nameSpace, String elementName, List<String> list) throws XMLStreamException {
        if (list != null) {
            for (String value : list) {
                if (!ObjectUtil.validString((String[])new String[]{value})) continue;
                this.startElement(this.writer, nameSpace, elementName);
                this.writer.writeCharacters(value);
                this.writer.writeEndElement();
            }
        }
    }

    private void writeContacts(List<ContactBean> contacts) throws XMLStreamException {
        if (contacts != null) {
            for (ContactBean currentContact : contacts) {
                this.startElement(this.writer, this.MESSAGE_NS, "Contact");
                this.writeContact(currentContact);
                this.writer.writeEndElement();
            }
        }
    }

    private void writeContact(ContactBean contact) throws XMLStreamException {
        Namespace nameNamespace = this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE ? this.COMMON_NS : this.MESSAGE_NS;
        this.writeTextTypes(nameNamespace, "Name", contact.getName());
        this.writeTextTypes(this.MESSAGE_NS, "Department", contact.getDepartments());
        this.writeTextTypes(this.MESSAGE_NS, "Role", contact.getRole());
        this.writeListContents(this.MESSAGE_NS, "Telephone", contact.getTelephone());
        this.writeListContents(this.MESSAGE_NS, "Fax", contact.getFax());
        this.writeListContents(this.MESSAGE_NS, "X400", contact.getX400());
        this.writeListContents(this.MESSAGE_NS, "URI", contact.getUri());
        this.writeListContents(this.MESSAGE_NS, "Email", contact.getEmail());
    }

    private class DataSetOutputStreams {
        private WriteableDataLocation seriesOutLocation;
        private WriteableDataLocation out;
        private OutputStream outputStream;
        private DatasetHeaderBean headerBean;
        private DataflowBean dataflow;
        private DataStructureBean dsd;
        private Namespace datasetNamespace;
        private Namespace dataNamespace;
        private String dimensionAtObservation;
        private Map<String, String> datasetAttributes = new HashMap<String, String>();

        public DataSetOutputStreams(DataflowBean dataflow, DataStructureBean dsd, DatasetHeaderBean headerBean, List<Namespace> knownNamespaces, int writerNumber) {
            this.dataflow = dataflow;
            this.dsd = dsd;
            this.out = new OverflowWriteableDataLocation();
            this.outputStream = this.out.getOutputStream();
            this.headerBean = headerBean;
            this.setDimensionAtObservation();
            SdmxDataWriterEngine.this.writer = this.createWriter(this.outputStream, knownNamespaces, writerNumber);
            try {
                SdmxDataWriterEngine.this.writer.flush();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            if (SdmxDataWriterEngine.this.isTwoPointOne() && dsd.getGroups().size() > 0) {
                this.seriesOutLocation = new OverflowWriteableDataLocation();
                SdmxDataWriterEngine.this.seriesWriter = this.createWriter(this.seriesOutLocation.getOutputStream(), knownNamespaces, writerNumber);
            } else {
                SdmxDataWriterEngine.this.seriesWriter = SdmxDataWriterEngine.this.writer;
                this.seriesOutLocation = this.out;
            }
        }

        public MaintainableBean getStructureForData() {
            if (this.dataflow != null) {
                return this.dataflow;
            }
            return this.dsd;
        }

        public String getDimensionAtObservation() {
            return this.dimensionAtObservation;
        }

        private void setDimensionAtObservation() {
            this.dimensionAtObservation = this.headerBean == null || this.headerBean.getDataStructureReference() == null || !ObjectUtil.validString((String[])new String[]{this.headerBean.getDataStructureReference().getDimensionAtObservation()}) ? "TIME_PERIOD" : this.headerBean.getDataStructureReference().getDimensionAtObservation();
        }

        private Namespace getNamespaceIfKnown(List<Namespace> knownNamespaces, String namespaceUrl) {
            for (Namespace currentNamespace : knownNamespaces) {
                if (!currentNamespace.namespaceURL.equals(namespaceUrl)) continue;
                return currentNamespace;
            }
            return null;
        }

        private XMLStreamWriter createWriter(OutputStream writerOut, List<Namespace> knownNamespaces, int writerNumber) {
            try {
                XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
                XMLStreamWriter writer = xmlOutputfactory.createXMLStreamWriter(writerOut, "UTF-8");
                writer.writeStartDocument();
                MaintainableBean constrainable = this.getStructureForData();
                if (SdmxDataWriterEngine.this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                    this.datasetNamespace = this.dataNamespace = this.generateStructureNameSpace(constrainable, writerNumber);
                    SdmxDataWriterEngine.this.COMPACT_NS = this.dataNamespace;
                } else if (SdmxDataWriterEngine.this.dataFormat == BASE_DATA_FORMAT.CROSS_SECTIONAL) {
                    this.dataNamespace = this.generateStructureNameSpace(constrainable, writerNumber);
                    this.datasetNamespace = SdmxDataWriterEngine.this.MESSAGE_NS;
                    SdmxDataWriterEngine.this.CROSS_NS = this.dataNamespace;
                } else {
                    this.datasetNamespace = SdmxDataWriterEngine.this.MESSAGE_NS;
                }
                SdmxDataWriterEngine.this.startElement(writer, this.datasetNamespace, "DataSet");
                if (SdmxDataWriterEngine.this.isTwoPointOne()) {
                    writer.writeNamespace(((SdmxDataWriterEngine)SdmxDataWriterEngine.this).FOOTER_NS.namespacePrefix, ((SdmxDataWriterEngine)SdmxDataWriterEngine.this).FOOTER_NS.namespaceURL);
                }
                writer.writeNamespace(((SdmxDataWriterEngine)SdmxDataWriterEngine.this).COMMON_NS.namespacePrefix, ((SdmxDataWriterEngine)SdmxDataWriterEngine.this).COMMON_NS.namespaceURL);
                writer.writeNamespace(((SdmxDataWriterEngine)SdmxDataWriterEngine.this).MESSAGE_NS.namespacePrefix, ((SdmxDataWriterEngine)SdmxDataWriterEngine.this).MESSAGE_NS.namespaceURL);
                if (this.dataNamespace != null && this.dataNamespace != this.datasetNamespace) {
                    writer.writeNamespace(this.dataNamespace.namespacePrefix, this.dataNamespace.namespaceURL);
                }
                if (SdmxDataWriterEngine.this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                    writer.writeNamespace(SdmxDataWriterEngine.this.GENERIC_NS.namespacePrefix, SdmxDataWriterEngine.this.GENERIC_NS.namespaceURL);
                }
                writer.writeNamespace("xsi", SdmxDataWriterEngine.XSI_NS);
                writer.writeNamespace("xml", SdmxDataWriterEngine.XML_NS);
                if (this.datasetNamespace != SdmxDataWriterEngine.this.MESSAGE_NS) {
                    writer.writeNamespace(this.datasetNamespace.namespacePrefix, this.datasetNamespace.namespaceURL);
                }
                if (constrainable instanceof DataflowBean && !SdmxDataWriterEngine.this.isTwoPointOne()) {
                    this.datasetAttributes.put("dataflowAgencyID", constrainable.getAgencyId());
                    this.datasetAttributes.put("dataflowID", constrainable.getId());
                }
                return writer;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        private Namespace generateStructureNameSpace(MaintainableBean bean, int writerNumber) {
            String ssNamespaceUrl = bean.getUrn() + ":ObsLevelDim:" + this.getDimensionAtObservation();
            Namespace dataNamespace = this.getNamespaceIfKnown(SdmxDataWriterEngine.this.knownNamespaces, ssNamespaceUrl);
            if (dataNamespace == null) {
                dataNamespace = new Namespace(ssNamespaceUrl, "ns" + writerNumber);
            }
            return dataNamespace;
        }
    }

    static enum POSITION {
        DATASET,
        DATASET_ATTRIBUTE,
        SERIES_KEY,
        SERIES_KEY_ATTRIBUTE,
        GROUP,
        GROUP_KEY,
        GROUP_KEY_ATTRIBUTE,
        OBSERVATION,
        OBSERVATION_ATTRIBUTE;

    }

    class Namespace {
        protected String namespaceURL;
        protected String namespacePrefix;

        public Namespace(String namespaceURL, String namespacePrefix) {
            this.namespaceURL = namespaceURL;
            this.namespacePrefix = namespacePrefix;
        }
    }
}

