/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.DATA_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.exception.SdmxSyntaxException;
import org.sdmxsource.sdmx.api.factory.WriteableDataLocationFactory;
import org.sdmxsource.sdmx.api.model.data.DataFormat;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.sdmx.dataparser.manager.DataInformationManager;
import org.sdmxsource.sdmx.dataparser.manager.SchemaGenerationManager;
import org.sdmxsource.sdmx.dataparser.manager.SchemaValidationManager;
import org.sdmxsource.springutil.xml.XMLParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchemaDataValidationManager
implements SchemaValidationManager {
    private static Logger LOG = Logger.getLogger(SchemaDataValidationManager.class);
    @Autowired
    private DataInformationManager dataInformationManager;
    @Autowired
    private SchemaGenerationManager schemaGenerationManager;
    @Autowired
    private WriteableDataLocationFactory writeableDataLocationFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateDatasetAgainstSchema(ReadableDataLocation dataset, DataStructureSuperBean dsd) throws SdmxSemmanticException, SdmxSyntaxException {
        LOG.info((Object)"Validating dataset against schema");
        DataFormat dataFormat = this.dataInformationManager.getDataType(dataset);
        if (dataFormat.getSdmxDataFormat() == null) {
            throw new IllegalArgumentException("Could not determine datatype of data.  Expecting an SDMX message");
        }
        if (dataFormat.getSdmxDataFormat() != null) {
            DATA_TYPE dataType = dataFormat.getSdmxDataFormat();
            if (dataType == DATA_TYPE.GENERIC_1_0 || dataType == DATA_TYPE.GENERIC_2_0) {
                LOG.debug((Object)"Validate against Generic XSD");
                XMLParser.validateXML((ReadableDataLocation)dataset, (SDMX_SCHEMA)dataType.getSchemaVersion(), (ReadableDataLocation[])new ReadableDataLocation[0]);
            } else {
                if (dsd == null) {
                    throw new IllegalArgumentException("Can not generate a Schema, no DataStructure was supplied");
                }
                WriteableDataLocation schemaLocation = this.writeableDataLocationFactory.getTemporaryWriteableDataLocation();
                OutputStream out = null;
                try {
                    out = schemaLocation.getOutputStream();
                    String targetNamespace = this.dataInformationManager.getTargetNamepace(dataset);
                    this.schemaGenerationManager.generateSchema(out, dsd, targetNamespace, dataType, null);
                    LOG.debug((Object)"schema generated, perform validation");
                    XMLParser.validateXML((ReadableDataLocation)dataset, (SDMX_SCHEMA)dataType.getSchemaVersion(), (ReadableDataLocation[])new ReadableDataLocation[]{schemaLocation});
                }
                finally {
                    schemaLocation.close();
                }
            }
            LOG.info((Object)"Dataset is valid against schema");
        }
    }
}

