/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.storage.FilesStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveFileAndDiscoverMimeTypeServlet
extends HttpServlet {
    private static final long serialVersionUID = -1649268678733476057L;
    private static Logger logger = LoggerFactory.getLogger(RetrieveFileAndDiscoverMimeTypeServlet.class);
    private static final String ATTRIBUTE_STORAGE_URI = "storageURI";
    private static final int BUFSIZE = 4096;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MediaType mimeType;
            FilesStorage storage;
            String uri;
            long startTime;
            block12: {
                logger.info("RetrieveFileAndDiscoverMimeTypeServlet");
                startTime = System.currentTimeMillis();
                HttpSession session = request.getSession();
                if (session == null) {
                    logger.error("Error getting the session, no session valid found: " + session);
                    response.sendError(500, "ERROR-Error getting the user session, no session found " + session);
                    return;
                }
                logger.debug("RetrieveFileAndDiscoverMimeTypeServlet session id: " + session.getId());
                SessionUtil.getAslSession(session);
                uri = request.getParameter(ATTRIBUTE_STORAGE_URI);
                logger.debug("Request storage uri: " + uri);
                if (uri == null || uri.isEmpty()) {
                    logger.error("Error getting request uri: " + uri);
                    response.sendError(500, "ERROR-Error getting request uri: " + session);
                    return;
                }
                storage = new FilesStorage();
                InputStream inMime = storage.retrieveImputStream(uri);
                TikaConfig tika = new TikaConfig();
                mimeType = null;
                try {
                    try {
                        mimeType = tika.getDetector().detect(inMime, new Metadata());
                    }
                    catch (Throwable e) {
                        logger.error("RetrieveFileAndDiscoverMimeTypeServlet parse: " + e.getLocalizedMessage());
                        inMime.close();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    inMime.close();
                    throw throwable;
                }
                inMime.close();
            }
            if (mimeType == null) {
                response.setContentType("unknown");
                logger.debug("Discover Mime Type: unknown");
            } else {
                response.setContentType(mimeType.toString());
                logger.debug("Discover Mime Type: " + mimeType.toString());
            }
            InputStream in = storage.retrieveImputStream(uri);
            ServletOutputStream out = response.getOutputStream();
            byte[] byteBuffer = new byte[4096];
            int length = 0;
            while (in != null && (length = in.read(byteBuffer)) != -1) {
                out.write(byteBuffer, 0, length);
            }
            response.setStatus(200);
            in.close();
            out.close();
            logger.trace("Response in " + (System.currentTimeMillis() - startTime));
        }
        catch (Throwable e) {
            logger.error("Error retrieving file from storage: " + e.getLocalizedMessage());
            e.printStackTrace();
            response.sendError(500, "Error retrieving file from storage: " + e.getLocalizedMessage());
            return;
        }
    }
}

