/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.rconnector.client.Constants;
import org.gcube.data.analysis.rconnector.client.proxy.ConnectorProxy;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDRStudioServlet
extends HttpServlet {
    private static final String TAB_RESOURCE_ID_PARAMETER = "TabResourceId";
    private static final long serialVersionUID = -1649268678733476057L;
    private static Logger logger = LoggerFactory.getLogger(TDRStudioServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            logger.info("TDRStudioServlet");
            long startTime = System.currentTimeMillis();
            HttpSession session = request.getSession();
            if (session == null) {
                logger.error("Error getting the session, no session valid found: " + session);
                response.sendError(500, "ERROR-Error getting the user session, no session found " + session);
                return;
            }
            logger.debug("TDRSTudioServlet session id: " + session.getId());
            ASLSession aslSession = SessionUtil.getAslSession(session);
            String tabResourceId = request.getParameter(TAB_RESOURCE_ID_PARAMETER);
            logger.debug("Request RStudio for TR: " + tabResourceId);
            URI url = ((ConnectorProxy)Constants.rConnector().build()).connect(aslSession.getUsername(), Long.valueOf(tabResourceId));
            logger.debug("URL retrieved from rConnector: " + url.toString());
            response.setStatus(301);
            response.setHeader("Location", url.toString());
            response.setHeader("gcube-scope", aslSession.getScope());
            logger.debug("Response: " + response.toString());
            logger.trace("Response in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Throwable e) {
            logger.error("Error TDRStudio: " + e.getLocalizedMessage());
            e.printStackTrace();
            response.sendError(500, "Error retrieving file from storage: " + e.getLocalizedMessage());
            return;
        }
    }
}

