/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularDataRowsXServlet
extends HttpServlet {
    private static final long serialVersionUID = 3995054634540860599L;
    protected Logger logger = LoggerFactory.getLogger(TabularDataRowsXServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.debug("TabularDataServlet handleRequest");
        try {
            HttpSession session = request.getSession();
            if (session == null) {
                this.logger.error("Error getting the upload session, no session valid found: " + session);
                response.sendError(500, "ERROR-Error getting the user session, no session found" + session);
                return;
            }
            this.logger.info("Session id: " + session.getId());
            ServletInputStream in = request.getInputStream();
            InputStreamReader buffIn = new InputStreamReader((InputStream)in);
            char[] buffer = new char[1024];
            int n = 0;
            StringWriter out = new StringWriter();
            while (-1 != (n = buffIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
            this.logger.debug("Stream: " + out);
            JSONObject jsonRequest = new JSONObject(out.toString());
            this.logger.debug("JSON request:" + jsonRequest.toString());
            JSONArray ids = null;
            ArrayList<String> rowsIds = new ArrayList<String>();
            try {
                ids = jsonRequest.getJSONArray("rowsIds");
            }
            catch (JSONException e) {
                this.logger.debug("rowsIds: " + e.getLocalizedMessage());
            }
            if (ids != null) {
                int i = 0;
                while (i < ids.length()) {
                    String filter = ids.getString(i);
                    rowsIds.add(filter);
                    ++i;
                }
            }
            this.logger.debug("rowsIds:" + rowsIds.size());
            String json = new String();
            response.getOutputStream().write(json.getBytes());
            response.setStatus(200);
            this.logger.trace("Response sent (" + json.length() + " bytes)");
        }
        catch (Exception e) {
            this.logger.error("Error processing the json data request", (Throwable)e);
            response.sendError(500, "Error processing the json data request: " + e.getMessage());
            return;
        }
    }
}

